/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.MetricsREST;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
public class RESTServlet
implements Constants {
    private static Logger LOG = Logger.getLogger(RESTServlet.class);
    private static RESTServlet INSTANCE;
    private final Configuration conf;
    private final MetricsREST metrics = new MetricsREST();
    private final Map<String, ConnectionInfo> connections = new ConcurrentHashMap<String, ConnectionInfo>();
    private final KeyLocker<String> locker = new KeyLocker();
    private final UserGroupInformation realUser;
    static final String CLEANUP_INTERVAL = "hbase.rest.connection.cleanup-interval";
    static final String MAX_IDLETIME = "hbase.rest.connection.max-idletime";
    private final ThreadLocal<UserGroupInformation> effectiveUser = new ThreadLocal<UserGroupInformation>(){

        @Override
        protected UserGroupInformation initialValue() {
            return RESTServlet.this.realUser;
        }
    };
    private final Chore connectionCleaner;
    private final Stoppable stoppable;
    private UserProvider userProvider;

    UserGroupInformation getRealUser() {
        return this.realUser;
    }

    public static synchronized RESTServlet getInstance() {
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static synchronized RESTServlet getInstance(Configuration conf, UserGroupInformation realUser) {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet(conf, realUser);
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    RESTServlet(Configuration conf, UserGroupInformation realUser) {
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.stoppable = new Stoppable(){
            private volatile boolean isStopped = false;

            public void stop(String why) {
                this.isStopped = true;
            }

            public boolean isStopped() {
                return this.isStopped;
            }
        };
        int cleanInterval = conf.getInt(CLEANUP_INTERVAL, 10000);
        int maxIdleTime = conf.getInt(MAX_IDLETIME, 600000);
        this.connectionCleaner = new ConnectionCleaner(cleanInterval, maxIdleTime);
        Threads.setDaemonThreadRunning((Thread)this.connectionCleaner.getThread());
        this.realUser = realUser;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HBaseAdmin getAdmin() throws IOException {
        ConnectionInfo connInfo = this.getCurrentConnection();
        if (connInfo.admin == null) {
            ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)this.effectiveUser.get().getUserName()));
            try {
                if (connInfo.admin == null) {
                    connInfo.admin = new HBaseAdmin(connInfo.connection);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return connInfo.admin;
    }

    HTableInterface getTable(String tableName) throws IOException {
        ConnectionInfo connInfo = this.getCurrentConnection();
        return connInfo.connection.getTable(tableName);
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    MetricsREST getMetrics() {
        return this.metrics;
    }

    boolean isReadOnly() {
        return this.getConfiguration().getBoolean("hbase.rest.readonly", false);
    }

    void setEffectiveUser(UserGroupInformation effectiveUser) {
        this.effectiveUser.set(effectiveUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionInfo getCurrentConnection() throws IOException {
        String userName = this.effectiveUser.get().getUserName();
        ConnectionInfo connInfo = this.connections.get(userName);
        if (connInfo == null || !connInfo.updateAccessTime()) {
            ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)userName));
            try {
                connInfo = this.connections.get(userName);
                if (connInfo == null) {
                    User user = this.userProvider.create(this.effectiveUser.get());
                    HConnection conn = HConnectionManager.createConnection((Configuration)this.conf, (User)user);
                    connInfo = new ConnectionInfo(conn, userName);
                    this.connections.put(userName, connInfo);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return connInfo;
    }

    class ConnectionCleaner
    extends Chore {
        private final int maxIdleTime;

        public ConnectionCleaner(int cleanInterval, int maxIdleTime) {
            super("REST-ConnectionCleaner", cleanInterval, RESTServlet.this.stoppable);
            this.maxIdleTime = maxIdleTime;
        }

        protected void chore() {
            for (Map.Entry entry : RESTServlet.this.connections.entrySet()) {
                ConnectionInfo connInfo = (ConnectionInfo)entry.getValue();
                if (!connInfo.timedOut(this.maxIdleTime)) continue;
                if (connInfo.admin != null) {
                    try {
                        connInfo.admin.close();
                    }
                    catch (Throwable t) {
                        LOG.info((Object)"Got exception in closing idle admin", t);
                    }
                }
                try {
                    connInfo.connection.close();
                }
                catch (Throwable t) {
                    LOG.info((Object)"Got exception in closing idle connection", t);
                }
            }
        }
    }

    class ConnectionInfo {
        final HConnection connection;
        final String userName;
        volatile HBaseAdmin admin;
        private long lastAccessTime = EnvironmentEdgeManager.currentTimeMillis();
        private boolean closed;

        ConnectionInfo(HConnection conn, String user) {
            this.connection = conn;
            this.closed = false;
            this.userName = user;
        }

        synchronized boolean updateAccessTime() {
            if (this.closed) {
                return false;
            }
            if (this.connection.isAborted() || this.connection.isClosed()) {
                LOG.info((Object)"Unexpected: cached HConnection is aborted/closed, removed from cache");
                RESTServlet.this.connections.remove(this.userName);
                return false;
            }
            this.lastAccessTime = EnvironmentEdgeManager.currentTimeMillis();
            return true;
        }

        synchronized boolean timedOut(int maxIdleTime) {
            long timeoutTime = this.lastAccessTime + (long)maxIdleTime;
            if (EnvironmentEdgeManager.currentTimeMillis() > timeoutTime) {
                RESTServlet.this.connections.remove(this.userName);
                this.closed = true;
            }
            return false;
        }
    }
}

