/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKVisibilityLabelWatcher
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ZKVisibilityLabelWatcher.class);
    private static final String VISIBILITY_LABEL_ZK_PATH = "zookeeper.znode.visibility.label.parent";
    private static final String DEFAULT_VISIBILITY_LABEL_NODE = "visibility/labels";
    private static final String VISIBILITY_USER_AUTHS_ZK_PATH = "zookeeper.znode.visibility.user.auths.parent";
    private static final String DEFAULT_VISIBILITY_USER_AUTHS_NODE = "visibility/user_auths";
    private VisibilityLabelsManager labelsManager;
    private String labelZnode;
    private String userAuthsZnode;

    public ZKVisibilityLabelWatcher(ZooKeeperWatcher watcher, VisibilityLabelsManager labelsManager, Configuration conf) {
        super(watcher);
        this.labelsManager = labelsManager;
        String labelZnodeParent = conf.get(VISIBILITY_LABEL_ZK_PATH, DEFAULT_VISIBILITY_LABEL_NODE);
        String userAuthsZnodeParent = conf.get(VISIBILITY_USER_AUTHS_ZK_PATH, DEFAULT_VISIBILITY_USER_AUTHS_NODE);
        this.labelZnode = ZKUtil.joinZNode((String)watcher.baseZNode, (String)labelZnodeParent);
        this.userAuthsZnode = ZKUtil.joinZNode((String)watcher.baseZNode, (String)userAuthsZnodeParent);
    }

    public void start() throws KeeperException {
        byte[] data;
        this.watcher.registerListener((ZooKeeperListener)this);
        if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.labelZnode) && (data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)this.labelZnode)) != null) {
            this.refreshVisibilityLabelsCache(data);
        }
        if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.userAuthsZnode) && (data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)this.userAuthsZnode)) != null) {
            this.refreshUserAuthsCache(data);
        }
    }

    private void refreshVisibilityLabelsCache(byte[] data) {
        try {
            this.labelsManager.refreshLabelsCache(data);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed parsing data from labels table  from zk", (Throwable)ioe);
        }
    }

    private void refreshUserAuthsCache(byte[] data) {
        try {
            this.labelsManager.refreshUserAuthsCache(data);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Failed parsing data from labels table  from zk", (Throwable)ioe);
        }
    }

    public void nodeCreated(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)path);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error setting watcher on node " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error obtaining label node children", (Throwable)ke);
            }
        }
    }

    public void nodeDeleted(String path) {
    }

    public void nodeDataChanged(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                this.watcher.sync(path);
                byte[] data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)path);
                if (path.equals(this.labelZnode)) {
                    this.refreshVisibilityLabelsCache(data);
                } else {
                    this.refreshUserAuthsCache(data);
                }
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for node " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error getting data for node " + path, (Throwable)ke);
            }
        }
    }

    public void nodeChildrenChanged(String path) {
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) {
        String znode = this.labelZnode;
        if (!labelsOrUserAuths) {
            znode = this.userAuthsZnode;
        }
        try {
            ZKUtil.createWithParents((ZooKeeperWatcher)this.watcher, (String)znode);
            ZKUtil.updateExistingNodeData((ZooKeeperWatcher)this.watcher, (String)znode, (byte[])data, (int)-1);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed writing to " + znode), (Throwable)e);
            this.watcher.abort("Failed writing node " + znode + " to zookeeper", (Throwable)e);
        }
    }
}

