/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper.lock;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.DeletionListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public abstract class ZKInterProcessLockBase
implements InterProcessLock {
    private static final Log LOG = LogFactory.getLog(ZKInterProcessLockBase.class);
    protected static final String READ_LOCK_CHILD_NODE_PREFIX = "read-";
    protected static final String WRITE_LOCK_CHILD_NODE_PREFIX = "write-";
    protected final ZooKeeperWatcher zkWatcher;
    protected final String parentLockNode;
    protected final String fullyQualifiedZNode;
    protected final String childZNode;
    protected final byte[] metadata;
    protected final InterProcessLock.MetadataHandler handler;
    protected final AtomicReference<AcquiredLock> acquiredLock = new AtomicReference<Object>(null);

    protected ZKInterProcessLockBase(ZooKeeperWatcher zkWatcher, String parentLockNode, byte[] metadata, InterProcessLock.MetadataHandler handler, String childNode) {
        this.zkWatcher = zkWatcher;
        this.parentLockNode = parentLockNode;
        this.fullyQualifiedZNode = ZKUtil.joinZNode((String)parentLockNode, (String)childNode);
        this.metadata = metadata;
        this.handler = handler;
        this.childZNode = childNode;
    }

    @Override
    public void acquire() throws IOException, InterruptedException {
        this.tryAcquire(-1L);
    }

    @Override
    public boolean tryAcquire(long timeoutMs) throws IOException, InterruptedException {
        String createdZNode;
        boolean hasTimeout = timeoutMs != -1L;
        long waitUntilMs = hasTimeout ? EnvironmentEdgeManager.currentTimeMillis() + timeoutMs : -1L;
        try {
            createdZNode = this.createLockZNode();
        }
        catch (KeeperException ex) {
            throw new IOException("Failed to create znode: " + this.fullyQualifiedZNode, ex);
        }
        while (true) {
            List children;
            try {
                children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)this.parentLockNode);
            }
            catch (KeeperException e) {
                LOG.error((Object)"Unexpected ZooKeeper error when listing children", (Throwable)e);
                throw new IOException("Unexpected ZooKeeper exception", e);
            }
            String pathToWatch = this.getLockPath(createdZNode, children);
            if (pathToWatch == null) break;
            CountDownLatch deletedLatch = new CountDownLatch(1);
            String zkPathToWatch = ZKUtil.joinZNode((String)this.parentLockNode, (String)pathToWatch);
            DeletionListener deletionListener = new DeletionListener(this.zkWatcher, zkPathToWatch, deletedLatch);
            this.zkWatcher.registerListener((ZooKeeperListener)deletionListener);
            try {
                if (!ZKUtil.setWatchIfNodeExists((ZooKeeperWatcher)this.zkWatcher, (String)zkPathToWatch)) continue;
                if (hasTimeout) {
                    long remainingMs = waitUntilMs - EnvironmentEdgeManager.currentTimeMillis();
                    if (remainingMs < 0L || !deletedLatch.await(remainingMs, TimeUnit.MILLISECONDS)) {
                        LOG.warn((Object)("Unable to acquire the lock in " + timeoutMs + " milliseconds."));
                        try {
                            ZKUtil.deleteNode((ZooKeeperWatcher)this.zkWatcher, (String)createdZNode);
                        }
                        catch (KeeperException e) {
                            LOG.warn((Object)("Unable to remove ZNode " + createdZNode));
                        }
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    deletedLatch.await();
                }
                if (!deletionListener.hasException()) continue;
                Throwable t = deletionListener.getException();
                throw new IOException("Exception in the watcher", t);
            }
            catch (KeeperException e) {
                throw new IOException("Unexpected ZooKeeper exception", e);
            }
            finally {
                this.zkWatcher.unregisterListener((ZooKeeperListener)deletionListener);
                continue;
            }
            break;
        }
        this.updateAcquiredLock(createdZNode);
        LOG.debug((Object)("Acquired a lock for " + createdZNode));
        return true;
    }

    private String createLockZNode() throws KeeperException {
        try {
            return ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)this.fullyQualifiedZNode, (byte[])this.metadata, (CreateMode)CreateMode.EPHEMERAL_SEQUENTIAL);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents((ZooKeeperWatcher)this.zkWatcher, (String)this.parentLockNode);
            return this.createLockZNode();
        }
    }

    protected static boolean isChildReadLock(String child) {
        int idx = child.lastIndexOf(47);
        String suffix = child.substring(idx + 1);
        return suffix.startsWith(READ_LOCK_CHILD_NODE_PREFIX);
    }

    protected static boolean isChildWriteLock(String child) {
        int idx = child.lastIndexOf(47);
        String suffix = child.substring(idx + 1);
        return suffix.startsWith(WRITE_LOCK_CHILD_NODE_PREFIX);
    }

    protected boolean isChildOfSameType(String child) {
        int idx = child.lastIndexOf(47);
        String suffix = child.substring(idx + 1);
        return suffix.startsWith(this.childZNode);
    }

    protected void updateAcquiredLock(String createdZNode) throws IOException {
        Stat stat = new Stat();
        byte[] data = null;
        KeeperException ex = null;
        try {
            data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)createdZNode, (Stat)stat);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Cannot getData for znode:" + createdZNode), (Throwable)e);
            ex = e;
        }
        if (data == null) {
            LOG.error((Object)("Can't acquire a lock on a non-existent node " + createdZNode));
            throw new IllegalStateException("ZNode " + createdZNode + "no longer exists!", ex);
        }
        AcquiredLock newLock = new AcquiredLock(createdZNode, stat.getVersion());
        if (!this.acquiredLock.compareAndSet(null, newLock)) {
            LOG.error((Object)("The lock " + this.fullyQualifiedZNode + " has already been acquired by another process!"));
            throw new IllegalStateException(this.fullyQualifiedZNode + " is held by another process");
        }
    }

    @Override
    public void release() throws IOException, InterruptedException {
        AcquiredLock lock = this.acquiredLock.get();
        if (lock == null) {
            LOG.error((Object)("Cannot release lock, process does not have a lock for " + this.fullyQualifiedZNode));
            throw new IllegalStateException("No lock held for " + this.fullyQualifiedZNode);
        }
        try {
            if (ZKUtil.checkExists((ZooKeeperWatcher)this.zkWatcher, (String)lock.getPath()) != -1) {
                boolean ret = ZKUtil.deleteNode((ZooKeeperWatcher)this.zkWatcher, (String)lock.getPath(), (int)lock.getVersion());
                if (!ret && ZKUtil.checkExists((ZooKeeperWatcher)this.zkWatcher, (String)lock.getPath()) != -1) {
                    throw new IllegalStateException("Couldn't delete " + lock.getPath());
                }
                if (!this.acquiredLock.compareAndSet(lock, null)) {
                    LOG.debug((Object)("Current process no longer holds " + lock + " for " + this.fullyQualifiedZNode));
                    throw new IllegalStateException("Not holding a lock for " + this.fullyQualifiedZNode + "!");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Released " + lock.getPath()));
            }
        }
        catch (KeeperException.BadVersionException e) {
            throw new IllegalStateException(e);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    protected boolean handleLockMetadata(String lockZNode) {
        return this.handleLockMetadata(lockZNode, this.handler);
    }

    protected boolean handleLockMetadata(String lockZNode, InterProcessLock.MetadataHandler handler) {
        if (handler == null) {
            return false;
        }
        try {
            byte[] metadata = ZKUtil.getData((ZooKeeperWatcher)this.zkWatcher, (String)lockZNode);
            handler.handleMetadata(metadata);
        }
        catch (KeeperException ex) {
            LOG.warn((Object)("Error processing lock metadata in " + lockZNode));
            return false;
        }
        return true;
    }

    @Override
    public void reapAllLocks() throws IOException {
        this.reapExpiredLocks(0L);
    }

    @Override
    public void reapExpiredLocks(long timeout) throws IOException {
        List children;
        try {
            children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)this.parentLockNode);
        }
        catch (KeeperException e) {
            LOG.error((Object)"Unexpected ZooKeeper error when listing children", (Throwable)e);
            throw new IOException("Unexpected ZooKeeper exception", e);
        }
        if (children == null) {
            return;
        }
        KeeperException deferred = null;
        Stat stat = new Stat();
        long expireDate = System.currentTimeMillis() - timeout;
        for (String child : children) {
            if (!this.isChildOfSameType(child)) continue;
            String znode = ZKUtil.joinZNode((String)this.parentLockNode, (String)child);
            try {
                ZKUtil.getDataNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)znode, (Stat)stat);
                if (stat.getCtime() >= expireDate) continue;
                LOG.info((Object)("Reaping lock for znode:" + znode));
                ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)this.zkWatcher, (String)znode);
            }
            catch (KeeperException ex) {
                LOG.warn((Object)("Error reaping the znode for write lock :" + znode));
                deferred = ex;
            }
        }
        if (deferred != null) {
            throw new IOException("ZK exception while reaping locks:", deferred);
        }
    }

    @Override
    public void visitLocks(InterProcessLock.MetadataHandler handler) throws IOException {
        List children;
        try {
            children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)this.parentLockNode);
        }
        catch (KeeperException e) {
            LOG.error((Object)"Unexpected ZooKeeper error when listing children", (Throwable)e);
            throw new IOException("Unexpected ZooKeeper exception", e);
        }
        if (children != null && children.size() > 0) {
            for (String child : children) {
                if (!this.isChildOfSameType(child)) continue;
                String znode = ZKUtil.joinZNode((String)this.parentLockNode, (String)child);
                String childWatchesZNode = this.getLockPath(child, children);
                if (childWatchesZNode == null) {
                    LOG.info((Object)("Lock is held by: " + child));
                }
                this.handleLockMetadata(znode, handler);
            }
        }
    }

    protected abstract String getLockPath(String var1, List<String> var2) throws IOException;

    protected static class ZNodeComparator
    implements Comparator<String> {
        public static final ZNodeComparator COMPARATOR = new ZNodeComparator();

        private ZNodeComparator() {
        }

        public static long getChildSequenceId(String childZNode) {
            Preconditions.checkNotNull((Object)childZNode);
            assert (childZNode.length() >= 10);
            String sequenceIdStr = childZNode.substring(childZNode.length() - 10);
            return Long.parseLong(sequenceIdStr);
        }

        @Override
        public int compare(String zNode1, String zNode2) {
            long seq2;
            long seq1 = ZNodeComparator.getChildSequenceId(zNode1);
            if (seq1 == (seq2 = ZNodeComparator.getChildSequenceId(zNode2))) {
                return 0;
            }
            return seq1 < seq2 ? -1 : 1;
        }
    }

    protected static class AcquiredLock {
        private final String path;
        private final int version;

        public AcquiredLock(String path, int version) {
            this.path = path;
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return "AcquiredLockInfo{path='" + this.path + '\'' + ", version=" + this.version + '}';
        }
    }
}

