/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionScanner;

@InterfaceAudience.Private
class AnnotationReadingPriorityFunction
implements PriorityFunction {
    public static final Log LOG = LogFactory.getLog((String)AnnotationReadingPriorityFunction.class.getName());
    private final Map<String, Integer> annotatedQos;
    private HRegionServer hRegionServer;
    private final Class<? extends Message>[] knownArgumentClasses = new Class[]{AdminProtos.GetRegionInfoRequest.class, AdminProtos.GetStoreFileRequest.class, AdminProtos.CloseRegionRequest.class, AdminProtos.FlushRegionRequest.class, AdminProtos.SplitRegionRequest.class, AdminProtos.CompactRegionRequest.class, ClientProtos.GetRequest.class, ClientProtos.MutateRequest.class, ClientProtos.ScanRequest.class};
    private final Map<String, Class<? extends Message>> argumentToClassMap = new HashMap<String, Class<? extends Message>>();
    private final Map<String, Map<Class<? extends Message>, Method>> methodMap = new HashMap<String, Map<Class<? extends Message>, Method>>();

    AnnotationReadingPriorityFunction(HRegionServer hrs) {
        this.hRegionServer = hrs;
        HashMap<String, Integer> qosMap = new HashMap<String, Integer>();
        for (Method method : HRegionServer.class.getMethods()) {
            HRegionServer.QosPriority p = method.getAnnotation(HRegionServer.QosPriority.class);
            if (p == null) continue;
            String capitalizedMethodName = this.capitalize(method.getName());
            qosMap.put(capitalizedMethodName, p.priority());
        }
        this.annotatedQos = qosMap;
        if (this.methodMap.get("getRegion") == null) {
            this.methodMap.put("hasRegion", new HashMap());
            this.methodMap.put("getRegion", new HashMap());
        }
        for (GenericDeclaration genericDeclaration : this.knownArgumentClasses) {
            this.argumentToClassMap.put(((Class)genericDeclaration).getName(), (Class<? extends Message>)genericDeclaration);
            try {
                this.methodMap.get("hasRegion").put((Class<? extends Message>)genericDeclaration, ((Class)genericDeclaration).getDeclaredMethod("hasRegion", new Class[0]));
                this.methodMap.get("getRegion").put((Class<? extends Message>)genericDeclaration, ((Class)genericDeclaration).getDeclaredMethod("getRegion", new Class[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String capitalize(String s) {
        StringBuilder strBuilder = new StringBuilder(s);
        strBuilder.setCharAt(0, Character.toUpperCase(strBuilder.charAt(0)));
        return strBuilder.toString();
    }

    public boolean isMetaRegion(byte[] regionName) {
        HRegion region;
        try {
            region = this.hRegionServer.getRegion(regionName);
        }
        catch (NotServingRegionException ignored) {
            return false;
        }
        return region.getRegionInfo().isMetaTable();
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param) {
        String methodName = header.getMethodName();
        Integer priorityByAnnotation = this.annotatedQos.get(methodName);
        if (priorityByAnnotation != null) {
            return priorityByAnnotation;
        }
        if (param == null) {
            return 0;
        }
        if (methodName.equalsIgnoreCase("multi") && param instanceof ClientProtos.MultiRequest) {
            return header.hasPriority() ? header.getPriority() : 0;
        }
        String cls = param.getClass().getName();
        Class<? extends Message> rpcArgClass = this.argumentToClassMap.get(cls);
        HBaseProtos.RegionSpecifier regionSpecifier = null;
        try {
            Method getRegion;
            HRegion region;
            Method hasRegion = this.methodMap.get("hasRegion").get(rpcArgClass);
            if (hasRegion != null && ((Boolean)hasRegion.invoke((Object)param, (Object[])null)).booleanValue() && (region = this.hRegionServer.getRegion(regionSpecifier = (HBaseProtos.RegionSpecifier)(getRegion = this.methodMap.get("getRegion").get(rpcArgClass)).invoke((Object)param, (Object[])null))).getRegionInfo().isMetaTable()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("High priority because region=" + region.getRegionNameAsString()));
                }
                return 100;
            }
        }
        catch (Exception ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Marking normal priority after getting exception=" + ex));
            }
            return 0;
        }
        if (methodName.equalsIgnoreCase("scan")) {
            ClientProtos.ScanRequest request = (ClientProtos.ScanRequest)param;
            if (!request.hasScannerId()) {
                return 0;
            }
            RegionScanner scanner = this.hRegionServer.getScanner(request.getScannerId());
            if (scanner != null && scanner.getRegionInfo().isMetaRegion()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("High priority scanner request " + TextFormat.shortDebugString((MessageOrBuilder)request)));
                }
                return 100;
            }
        }
        return 0;
    }

    @VisibleForTesting
    void setRegionServer(HRegionServer hrs) {
        this.hRegionServer = hrs;
    }
}

