/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKPermissionWatcher
extends ZooKeeperListener {
    private static Log LOG = LogFactory.getLog(ZKPermissionWatcher.class);
    static final String ACL_NODE = "acl";
    TableAuthManager authManager;
    String aclZNode;

    public ZKPermissionWatcher(ZooKeeperWatcher watcher, TableAuthManager authManager, Configuration conf) {
        super(watcher);
        this.authManager = authManager;
        String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", ACL_NODE);
        this.aclZNode = ZKUtil.joinZNode((String)watcher.baseZNode, (String)aclZnodeParent);
    }

    public void start() throws KeeperException {
        List existing;
        this.watcher.registerListener((ZooKeeperListener)this);
        if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.aclZNode) && (existing = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.aclZNode)) != null) {
            this.refreshNodes(existing);
        }
    }

    public void nodeCreated(String path) {
        if (path.equals(this.aclZNode)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error((Object)"Error reading data from zookeeper", (Throwable)ke);
                this.watcher.abort("Zookeeper error obtaining acl node children", (Throwable)ke);
            }
        }
    }

    public void nodeDeleted(String path) {
        if (this.aclZNode.equals(ZKUtil.getParent((String)path))) {
            String table = ZKUtil.getNodeName((String)path);
            if (AccessControlLists.isNamespaceEntry(table)) {
                this.authManager.removeNamespace(Bytes.toBytes((String)table));
            } else {
                this.authManager.removeTable(TableName.valueOf((String)table));
            }
        }
    }

    public void nodeDataChanged(String path) {
        if (this.aclZNode.equals(ZKUtil.getParent((String)path))) {
            String entry = ZKUtil.getNodeName((String)path);
            try {
                byte[] data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)path);
                this.refreshAuthManager(entry, data);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for node " + entry), (Throwable)ke);
                this.watcher.abort("Zookeeper error getting data for node " + entry, (Throwable)ke);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error reading permissions writables", (Throwable)ioe);
            }
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.aclZNode)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for path " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error get node children for path " + path, (Throwable)ke);
            }
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String entry = ZKUtil.getNodeName((String)path);
            try {
                this.refreshAuthManager(entry, n.getData());
            }
            catch (IOException ioe) {
                LOG.error((Object)("Failed parsing permissions for table '" + entry + "' from zk"), (Throwable)ioe);
            }
        }
    }

    private void refreshAuthManager(String entry, byte[] nodeData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating permissions cache from node " + entry + " with data: " + Bytes.toStringBinary((byte[])nodeData)));
        }
        if (AccessControlLists.isNamespaceEntry(entry)) {
            this.authManager.refreshNamespaceCacheFromWritable(AccessControlLists.fromNamespaceEntry(entry), nodeData);
        } else {
            this.authManager.refreshTableCacheFromWritable(TableName.valueOf((String)entry), nodeData);
        }
    }

    public void writeToZookeeper(byte[] entry, byte[] permsData) {
        String entryName = Bytes.toString((byte[])entry);
        String zkNode = ZKUtil.joinZNode((String)this.watcher.baseZNode, (String)ACL_NODE);
        zkNode = ZKUtil.joinZNode((String)zkNode, (String)entryName);
        try {
            ZKUtil.createWithParents((ZooKeeperWatcher)this.watcher, (String)zkNode);
            ZKUtil.updateExistingNodeData((ZooKeeperWatcher)this.watcher, (String)zkNode, (byte[])permsData, (int)-1);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed updating permissions for entry '" + entryName + "'"), (Throwable)e);
            this.watcher.abort("Failed writing node " + zkNode + " to zookeeper", (Throwable)e);
        }
    }
}

