/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.ZKVisibilityLabelWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class VisibilityLabelsCache
implements VisibilityLabelOrdinalProvider {
    private static final Log LOG = LogFactory.getLog(VisibilityLabelsCache.class);
    private static final int NON_EXIST_LABEL_ORDINAL = 0;
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private static final Set<Integer> EMPTY_SET = Collections.emptySet();
    private static VisibilityLabelsCache instance;
    private ZKVisibilityLabelWatcher zkVisibilityWatcher;
    private Map<String, Integer> labels = new HashMap<String, Integer>();
    private Map<Integer, String> ordinalVsLabels = new HashMap<Integer, String>();
    private Map<String, Set<Integer>> userAuths = new HashMap<String, Set<Integer>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private VisibilityLabelsCache(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.zkVisibilityWatcher = new ZKVisibilityLabelWatcher(watcher, this, conf);
        try {
            this.zkVisibilityWatcher.start();
        }
        catch (KeeperException ke) {
            LOG.error((Object)"ZooKeeper initialization failed", (Throwable)ke);
            throw new IOException(ke);
        }
    }

    public static synchronized VisibilityLabelsCache createAndGet(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        if (instance == null || watcher != VisibilityLabelsCache.instance.zkVisibilityWatcher.getWatcher()) {
            instance = new VisibilityLabelsCache(watcher, conf);
        }
        return instance;
    }

    public static VisibilityLabelsCache get() {
        if (instance == null) {
            throw new IllegalStateException("VisibilityLabelsCache not yet instantiated");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLabelsCache(byte[] data) throws IOException {
        List<VisibilityLabelsProtos.VisibilityLabel> visibilityLabels = null;
        try {
            visibilityLabels = VisibilityUtils.readLabelsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            this.labels.clear();
            this.ordinalVsLabels.clear();
            for (VisibilityLabelsProtos.VisibilityLabel visLabel : visibilityLabels) {
                String label = Bytes.toString((byte[])visLabel.getLabel().toByteArray());
                this.labels.put(label, visLabel.getOrdinal());
                this.ordinalVsLabels.put(visLabel.getOrdinal(), label);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUserAuthsCache(byte[] data) throws IOException {
        VisibilityLabelsProtos.MultiUserAuthorizations multiUserAuths = null;
        try {
            multiUserAuths = VisibilityUtils.readUserAuthsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            this.userAuths.clear();
            for (VisibilityLabelsProtos.UserAuthorizations userAuths : multiUserAuths.getUserAuthsList()) {
                String user = Bytes.toString((byte[])userAuths.getUser().toByteArray());
                this.userAuths.put(user, new HashSet(userAuths.getAuthList()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLabelOrdinal(String label) {
        Integer ordinal = null;
        this.lock.readLock().lock();
        try {
            ordinal = this.labels.get(label);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (ordinal != null) {
            return ordinal;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(int ordinal) {
        this.lock.readLock().lock();
        try {
            String string = this.ordinalVsLabels.get(ordinal);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLabelsCount() {
        this.lock.readLock().lock();
        try {
            int n = this.labels.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAuths(String user) {
        List<String> auths = EMPTY_LIST;
        this.lock.readLock().lock();
        try {
            Set<Integer> authOrdinals = this.userAuths.get(user);
            if (authOrdinals != null) {
                auths = new ArrayList<String>(authOrdinals.size());
                for (Integer authOrdinal : authOrdinals) {
                    auths.add(this.ordinalVsLabels.get(authOrdinal));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return auths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getAuthsAsOrdinals(String user) {
        this.lock.readLock().lock();
        try {
            Set<Integer> auths = this.userAuths.get(user);
            Set<Integer> set = auths == null ? EMPTY_SET : auths;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) {
        this.zkVisibilityWatcher.writeToZookeeper(data, labelsOrUserAuths);
    }
}

