/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public final class FSVisitor {
    private static final Log LOG = LogFactory.getLog(FSVisitor.class);

    private FSVisitor() {
    }

    public static void visitRegions(FileSystem fs, Path tableDir, RegionVisitor visitor) throws IOException {
        FileStatus[] regions = FSUtils.listStatus(fs, tableDir, new FSUtils.RegionDirFilter(fs));
        if (regions == null) {
            LOG.info((Object)("No regions under directory:" + tableDir));
            return;
        }
        for (FileStatus region : regions) {
            visitor.region(region.getPath().getName());
        }
    }

    public static void visitTableStoreFiles(FileSystem fs, Path tableDir, StoreFileVisitor visitor) throws IOException {
        FileStatus[] regions = FSUtils.listStatus(fs, tableDir, new FSUtils.RegionDirFilter(fs));
        if (regions == null) {
            LOG.info((Object)("No regions under directory:" + tableDir));
            return;
        }
        for (FileStatus region : regions) {
            FSVisitor.visitRegionStoreFiles(fs, region.getPath(), visitor);
        }
    }

    public static void visitRegionStoreFiles(FileSystem fs, Path regionDir, StoreFileVisitor visitor) throws IOException {
        FileStatus[] families = FSUtils.listStatus(fs, regionDir, new FSUtils.FamilyDirFilter(fs));
        if (families == null) {
            LOG.info((Object)("No families under region directory:" + regionDir));
            return;
        }
        FSUtils.FileFilter fileFilter = new FSUtils.FileFilter(fs);
        for (FileStatus family : families) {
            Path familyDir = family.getPath();
            String familyName = familyDir.getName();
            FileStatus[] storeFiles = FSUtils.listStatus(fs, familyDir, fileFilter);
            if (storeFiles == null) {
                LOG.debug((Object)("No hfiles found for family: " + familyDir + ", skipping."));
                continue;
            }
            for (FileStatus hfile : storeFiles) {
                Path hfilePath = hfile.getPath();
                visitor.storeFile(regionDir.getName(), familyName, hfilePath.getName());
            }
        }
    }

    public static void visitTableRecoveredEdits(FileSystem fs, Path tableDir, RecoveredEditsVisitor visitor) throws IOException {
        FileStatus[] regions = FSUtils.listStatus(fs, tableDir, new FSUtils.RegionDirFilter(fs));
        if (regions == null) {
            LOG.info((Object)("No recoveredEdits regions under directory:" + tableDir));
            return;
        }
        for (FileStatus region : regions) {
            FSVisitor.visitRegionRecoveredEdits(fs, region.getPath(), visitor);
        }
    }

    public static void visitRegionRecoveredEdits(FileSystem fs, Path regionDir, RecoveredEditsVisitor visitor) throws IOException {
        NavigableSet<Path> files = HLogUtil.getSplitEditFilesSorted(fs, regionDir);
        if (files == null || files.size() == 0) {
            return;
        }
        for (Path source : files) {
            FileStatus stat = fs.getFileStatus(source);
            if (stat.getLen() <= 0L) continue;
            visitor.recoveredEdits(regionDir.getName(), source.getName());
        }
    }

    public static void visitLogFiles(FileSystem fs, Path rootDir, LogFileVisitor visitor) throws IOException {
        Path logsDir = new Path(rootDir, "WALs");
        FileStatus[] logServerDirs = FSUtils.listStatus(fs, logsDir);
        if (logServerDirs == null) {
            LOG.info((Object)("No logs under directory:" + logsDir));
            return;
        }
        for (FileStatus serverLogs : logServerDirs) {
            String serverName = serverLogs.getPath().getName();
            FileStatus[] hlogs = FSUtils.listStatus(fs, serverLogs.getPath());
            if (hlogs == null) {
                LOG.debug((Object)("No hfiles found for server: " + serverName + ", skipping."));
                continue;
            }
            for (FileStatus hlogRef : hlogs) {
                visitor.logFile(serverName, hlogRef.getPath().getName());
            }
        }
    }

    public static interface LogFileVisitor {
        public void logFile(String var1, String var2) throws IOException;
    }

    public static interface RecoveredEditsVisitor {
        public void recoveredEdits(String var1, String var2) throws IOException;
    }

    public static interface StoreFileVisitor {
        public void storeFile(String var1, String var2, String var3) throws IOException;
    }

    public static interface RegionVisitor {
        public void region(String var1) throws IOException;
    }
}

