/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.net.BindException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClusterPortAssignment {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestClusterPortAssignment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testClusterPortAssignment() throws Exception {
        boolean retry = false;
        do {
            int masterPort = HBaseTestingUtility.randomFreePort();
            int masterInfoPort = HBaseTestingUtility.randomFreePort();
            int rsPort = HBaseTestingUtility.randomFreePort();
            int rsInfoPort = HBaseTestingUtility.randomFreePort();
            TEST_UTIL.getConfiguration().setBoolean("hbase.localcluster.assign.random.ports", false);
            TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", false);
            TEST_UTIL.getConfiguration().setBoolean("fs.hdfs.impl.disable.cache", true);
            TEST_UTIL.getConfiguration().setInt("hbase.master.port", masterPort);
            TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", masterInfoPort);
            TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", rsPort);
            TEST_UTIL.getConfiguration().setInt("hbase.regionserver.info.port", rsInfoPort);
            LOG.info((Object)("Ports: " + masterPort + ", " + masterInfoPort + ", " + rsPort + ", " + rsInfoPort));
            try {
                MiniHBaseCluster cluster = TEST_UTIL.startMiniCluster();
                Assert.assertTrue((String)"Cluster failed to come up", (boolean)cluster.waitForActiveAndReadyMaster(30000L));
                retry = false;
                Assert.assertEquals((String)"Master RPC port is incorrect", (long)masterPort, (long)cluster.getMaster().getRpcServer().getListenerAddress().getPort());
                Assert.assertEquals((String)"Master info port is incorrect", (long)masterInfoPort, (long)cluster.getMaster().getInfoServer().getPort());
                Assert.assertEquals((String)"RS RPC port is incorrect", (long)rsPort, (long)cluster.getRegionServer(0).getRpcServer().getListenerAddress().getPort());
                Assert.assertEquals((String)"RS info port is incorrect", (long)rsInfoPort, (long)cluster.getRegionServer(0).getInfoServer().getPort());
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof BindException) {
                    LOG.info((Object)"Failed bind, need to retry", (Throwable)e);
                    retry = true;
                    continue;
                }
                LOG.error((Object)"Failed to start mini cluster", (Throwable)e);
                retry = false;
                Assert.fail((String)"Failed to start mini cluster with assigned ports.");
            }
            finally {
                TEST_UTIL.shutdownMiniCluster();
            }
        } while (retry);
    }
}

