/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ExponentialClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientPushback {
    private static final Log LOG = LogFactory.getLog(TestClientPushback.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] tableName = Bytes.toBytes((String)"client-pushback");
    private static final byte[] family = Bytes.toBytes((String)"f");
    private static final byte[] qualifier = Bytes.toBytes((String)"q");
    private static long flushSizeBytes = 1024L;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.client.backpressure.enabled", true);
        conf.setClass("hbase.client.statistics.backoff-policy", ExponentialClientBackoffPolicy.class, ClientBackoffPolicy.class);
        conf.setLong("hbase.hregion.memstore.flush.size", flushSizeBytes);
        conf.setLong("hbase.hregion.memstore.block.multiplier", 4L);
        conf.setBoolean("hbase.client.metrics.enable", true);
        UTIL.startMiniCluster();
        UTIL.createTable(tableName, family);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testClientTracksServerPushback() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        TableName tablename = TableName.valueOf((byte[])tableName);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        HTable table = (HTable)conn.getTable(tablename);
        table.setAutoFlushTo(true);
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.add(family, qualifier, Bytes.toBytes((String)"value1"));
        table.put(p);
        ClusterConnection connection = table.connection;
        ClientBackoffPolicy backoffPolicy = connection.getBackoffPolicy();
        Assert.assertTrue((String)"Backoff policy is not correctly configured", (boolean)(backoffPolicy instanceof ExponentialClientBackoffPolicy));
        ServerStatisticTracker stats = connection.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        Region region = (Region)UTIL.getHBaseCluster().getRegionServer(0).getOnlineRegions(tablename).get(0);
        ServerName server = UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        byte[] regionName = region.getRegionInfo().getRegionName();
        ServerStatistics serverStats = stats.getServerStatsForTesting(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        int load = regionStats.getMemstoreLoadPercent();
        Assert.assertEquals((String)"We did not find some load on the memstore", (long)load, (long)regionStats.getMemstoreLoadPercent());
        long backoffTime = backoffPolicy.getBackoffTime(server, regionName, serverStats);
        Assert.assertNotEquals((String)"Reported load does not produce a backoff", (long)backoffTime, (long)0L);
        LOG.debug((Object)("Backoff calculated for " + region.getRegionInfo().getRegionNameAsString() + " @ " + server + " is " + backoffTime));
        ArrayList<Put> ops = new ArrayList<Put>(1);
        ops.add(p);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong endTime = new AtomicLong();
        long startTime = EnvironmentEdgeManager.currentTime();
        table.mutator.ap.submit(tablename, ops, true, (Batch.Callback)new Batch.Callback<Result>(){

            public void update(byte[] region, byte[] row, Result result) {
                endTime.set(EnvironmentEdgeManager.currentTime());
                latch.countDown();
            }
        }, true);
        String name = server.getServerName() + "," + Bytes.toStringBinary((byte[])regionName);
        MetricsConnection.RegionStats rsStats = (MetricsConnection.RegionStats)((ConcurrentMap)connection.getConnectionMetrics().serverStats.get(server)).get(regionName);
        Assert.assertEquals((Object)name, (Object)rsStats.name);
        Assert.assertEquals((double)rsStats.heapOccupancyHist.mean(), (double)regionStats.getHeapOccupancyPercent(), (double)0.1);
        Assert.assertEquals((double)rsStats.memstoreLoadHist.mean(), (double)regionStats.getMemstoreLoadPercent(), (double)0.1);
        MetricsConnection.RunnerStats runnerStats = connection.getConnectionMetrics().runnerStats;
        Assert.assertEquals((long)runnerStats.delayRunners.count(), (long)1L);
        Assert.assertEquals((long)runnerStats.normalRunners.count(), (long)1L);
        Assert.assertEquals((String)"", (double)runnerStats.delayIntevalHist.mean(), (double)backoffTime, (double)0.1);
        latch.await(backoffTime * 2L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((String)"AsyncProcess did not submit the work time", (long)endTime.get(), (long)0L);
        Assert.assertTrue((String)"AsyncProcess did not delay long enough", (endTime.get() - startTime >= backoffTime ? 1 : 0) != 0);
    }

    @Test
    public void testMutateRowStats() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        ClusterConnection conn = (ClusterConnection)ConnectionFactory.createConnection((Configuration)conf);
        HTable table = (HTable)conn.getTable(tableName);
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        Region region = (Region)rs.getOnlineRegions(TableName.valueOf((byte[])tableName)).get(0);
        RowMutations mutations = new RowMutations(Bytes.toBytes((String)"row"));
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.addColumn(family, qualifier, Bytes.toBytes((String)"value2"));
        mutations.add(p);
        table.mutateRow(mutations);
        ServerStatisticTracker stats = conn.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        ServerName server = rs.getServerName();
        byte[] regionName = region.getRegionInfo().getRegionName();
        ServerStatistics serverStats = stats.getServerStatsForTesting(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        Assert.assertNotNull((Object)regionStats);
        Assert.assertTrue((regionStats.getMemstoreLoadPercent() > 0 ? 1 : 0) != 0);
    }
}

