/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestSplitOrMergeStatus {
    private static final Log LOG = LogFactory.getLog(TestSplitOrMergeStatus.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", false);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSplitSwitch() throws Exception {
        TableName name = TableName.valueOf((String)"testSplitSwitch");
        HTable t = TEST_UTIL.createTable(name, FAMILY);
        TEST_UTIL.loadTable((Table)t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());
        int orignalCount = locator.getAllRegionLocations().size();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        this.initSwitchStatus((Admin)admin);
        boolean[] results = admin.setSplitOrMergeEnabled(false, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.SPLIT});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertTrue((boolean)results[0]);
        admin.split(t.getName());
        int count = this.waitOnSplitOrMerge((Table)t).size();
        Assert.assertTrue((orignalCount == count ? 1 : 0) != 0);
        results = admin.setSplitOrMergeEnabled(true, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.SPLIT});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertFalse((boolean)results[0]);
        admin.split(t.getName());
        count = this.waitOnSplitOrMerge((Table)t).size();
        Assert.assertTrue((orignalCount < count ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testMergeSwitch() throws Exception {
        TableName name = TableName.valueOf((String)"testMergeSwitch");
        HTable t = TEST_UTIL.createTable(name, FAMILY);
        TEST_UTIL.loadTable((Table)t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        this.initSwitchStatus((Admin)admin);
        admin.split(t.getName());
        this.waitOnSplitOrMerge((Table)t);
        this.waitForMergable((Admin)admin, name);
        int orignalCount = locator.getAllRegionLocations().size();
        boolean[] results = admin.setSplitOrMergeEnabled(false, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.MERGE});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertTrue((boolean)results[0]);
        List regions = admin.getTableRegions(t.getName());
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        admin.mergeRegions(((HRegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        int count = this.waitOnSplitOrMerge((Table)t).size();
        Assert.assertTrue((orignalCount == count ? 1 : 0) != 0);
        this.waitForMergable((Admin)admin, name);
        results = admin.setSplitOrMergeEnabled(true, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.MERGE});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertFalse((boolean)results[0]);
        admin.mergeRegions(((HRegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        count = this.waitOnSplitOrMerge((Table)t).size();
        Assert.assertTrue((orignalCount > count ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testMultiSwitches() throws IOException {
        boolean[] switches;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        for (boolean s : switches = admin.setSplitOrMergeEnabled(false, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.SPLIT, Admin.MasterSwitchType.MERGE})) {
            Assert.assertTrue((boolean)s);
        }
        Assert.assertFalse((boolean)admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT));
        Assert.assertFalse((boolean)admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE));
        admin.close();
    }

    private void initSwitchStatus(Admin admin) throws IOException {
        if (!admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT)) {
            admin.setSplitOrMergeEnabled(true, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.SPLIT});
        }
        if (!admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE)) {
            admin.setSplitOrMergeEnabled(true, false, new Admin.MasterSwitchType[]{Admin.MasterSwitchType.MERGE});
        }
        Assert.assertTrue((boolean)admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT));
        Assert.assertTrue((boolean)admin.isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE));
    }

    private void waitForMergable(Admin admin, TableName t) throws InterruptedException, IOException {
        MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
        int mergeable = 0;
        while (mergeable < 2) {
            Thread.sleep(100L);
            admin.majorCompact(t);
            mergeable = 0;
            for (JVMClusterUtil.RegionServerThread regionThread : miniCluster.getRegionServerThreads()) {
                for (Region region : regionThread.getRegionServer().getOnlineRegions(t)) {
                    mergeable += ((HRegion)region).isMergeable() ? 1 : 0;
                }
            }
        }
    }

    private List<HRegionLocation> waitOnSplitOrMerge(Table t) throws IOException {
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());){
            List regions = locator.getAllRegionLocations();
            int originalCount = regions.size();
            for (int i = 0; i < TEST_UTIL.getConfiguration().getInt("hbase.test.retries", 10); ++i) {
                Thread.currentThread();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                regions = locator.getAllRegionLocations();
                if (regions.size() != originalCount) break;
            }
            List list = regions;
            return list;
        }
    }
}

