/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableSnapshotScanner;
import org.apache.hadoop.hbase.mapreduce.TestTableSnapshotInputFormat;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestTableSnapshotScanner {
    private static final Log LOG = LogFactory.getLog(TestTableSnapshotInputFormat.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_REGION_SERVERS = 2;
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2")};
    public static byte[] bbb = Bytes.toBytes((String)"bbb");
    public static byte[] yyy = Bytes.toBytes((String)"yyy");
    private FileSystem fs;
    private Path rootDir;
    @Rule
    public TestName name = new TestName();

    public void setupCluster() throws Exception {
        TestTableSnapshotScanner.setupConf(this.UTIL.getConfiguration());
        this.UTIL.startMiniCluster(2, true);
        this.rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.fs = this.rootDir.getFileSystem(this.UTIL.getConfiguration());
    }

    public void tearDownCluster() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void createTableAndSnapshot(HBaseTestingUtility util, TableName tableName, String snapshotName, int numRegions) throws Exception {
        try {
            util.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numRegions > 1) {
            util.createTable(tableName, FAMILIES, 1, bbb, yyy, numRegions);
        } else {
            util.createTable(tableName, FAMILIES);
        }
        HBaseAdmin admin = util.getHBaseAdmin();
        HTable table = new HTable(util.getConfiguration(), tableName);
        util.loadTable((Table)table, FAMILIES);
        Path rootDir = FSUtils.getRootDir((Configuration)util.getConfiguration());
        FileSystem fs = rootDir.getFileSystem(util.getConfiguration());
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
        byte[] value = Bytes.toBytes((String)"after_snapshot_value");
        util.loadTable((Table)table, FAMILIES, value);
        admin.flush(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDuplicateResultsWhenSplitting() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testNoDuplicateResultsWhenSplitting");
        String snapshotName = "testSnapshotBug";
        try {
            if (this.UTIL.getHBaseAdmin().tableExists(tableName)) {
                this.UTIL.deleteTable(tableName);
            }
            this.UTIL.createTable(tableName, FAMILIES);
            HBaseAdmin admin = this.UTIL.getHBaseAdmin();
            Table table = this.UTIL.getConnection().getTable(tableName);
            this.UTIL.loadTable(table, FAMILIES);
            admin.split(tableName, Bytes.toBytes((String)"eee"));
            TestTableSnapshotInputFormat.blockUntilSplitFinished(this.UTIL, tableName, 2);
            Path rootDir = FSUtils.getRootDir((Configuration)this.UTIL.getConfiguration());
            FileSystem fs = rootDir.getFileSystem(this.UTIL.getConfiguration());
            SnapshotTestingUtils.createSnapshotAndValidate((Admin)admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
            byte[] value = Bytes.toBytes((String)"after_snapshot_value");
            this.UTIL.loadTable(table, FAMILIES, value);
            admin.flush(tableName);
            table.close();
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(bbb).withStopRow(yyy);
            TableSnapshotScanner scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanLimit() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = tableName + "Snapshot";
        TableSnapshotScanner scanner = null;
        try {
            Result result;
            TestTableSnapshotScanner.createTableAndSnapshot(this.UTIL, tableName, snapshotName, 50);
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(bbb).setLimit(100);
            scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            int count = 0;
            while ((result = scanner.next()) != null) {
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    @Test
    public void testWithSingleRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithSingleRegion", 1, false);
    }

    @Test
    public void testWithMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 10, false);
    }

    @Test
    public void testWithOfflineHBaseMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 20, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanner(HBaseTestingUtility util, String snapshotName, int numRegions, boolean shutdownCluster) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testScanner");
        try {
            TestTableSnapshotScanner.createTableAndSnapshot(util, tableName, snapshotName, numRegions);
            if (shutdownCluster) {
                util.shutdownMiniHBaseCluster();
            }
            Path restoreDir = util.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbb, yyy);
            TableSnapshotScanner scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
        }
        finally {
            if (!shutdownCluster) {
                util.getHBaseAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
                this.tearDownCluster();
            }
        }
    }

    private void verifyScanner(ResultScanner scanner, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        Result result;
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        while ((result = scanner.next()) != null) {
            TestTableSnapshotScanner.verifyRow(result);
            rowTracker.addRow(result.getRow());
        }
        rowTracker.validate();
    }

    private static void verifyRow(Result result) throws IOException {
        byte[] row = result.getRow();
        CellScanner scanner = result.cellScanner();
        while (scanner.advance()) {
            Cell cell = scanner.current();
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])row, (int)0, (int)row.length, (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        for (int j = 0; j < FAMILIES.length; ++j) {
            byte[] actual = result.getValue(FAMILIES[j], FAMILIES[j]);
            Assert.assertArrayEquals((String)("Row in snapshot does not match, expected:" + Bytes.toString((byte[])row) + " ,actual:" + Bytes.toString((byte[])actual)), (byte[])row, (byte[])actual);
        }
    }
}

