/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestRegionCoprocessorHost {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final boolean skip;

    @Parameterized.Parameters
    public static List<Object> params() {
        return Arrays.asList(new Boolean(true), new Boolean(false));
    }

    public TestRegionCoprocessorHost(boolean skip) {
        this.skip = skip;
    }

    @Before
    public void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.coprocessor.enabled", true);
        conf.setBoolean("hbase.coprocessor.user.enabled", true);
        conf.setBoolean("hbase.skip.load.duplicate.table.coprocessor", this.skip);
        conf.set("hbase.coprocessor.region.classes", SimpleRegionObserver.class.getName());
        TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testLoadDuplicateCoprocessor() throws Exception {
        TableName table = TableName.valueOf((String)"testLoadDuplicateCoprocessor");
        HTableDescriptor tableDesc = new HTableDescriptor(table);
        tableDesc.addFamily(new HColumnDescriptor("cf"));
        tableDesc.addCoprocessor(TestRegionObserver.class.getName());
        TEST_UTIL.getHBaseAdmin().createTable(tableDesc);
        Assert.assertEquals((long)(this.skip ? 1L : 2L), (long)TestRegionObserver.getNumInstances());
    }

    public static final class TestRegionObserver
    extends SimpleRegionObserver {
        public static final AtomicInteger numInstances = new AtomicInteger(0);

        @Override
        public void start(CoprocessorEnvironment e) throws IOException {
            super.start(e);
            numInstances.incrementAndGet();
        }

        public static int getNumInstances() {
            return numInstances.get();
        }
    }
}

