/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestScannerSelectionUsingKeyRange {
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static TableName TABLE = TableName.valueOf((String)"myTable");
    private static String FAMILY = "myCF";
    private static byte[] FAMILY_BYTES = Bytes.toBytes((String)FAMILY);
    private static final int NUM_ROWS = 8;
    private static final int NUM_COLS_PER_ROW = 5;
    private static final int NUM_FILES = 2;
    private static final Map<Object, Integer> TYPE_COUNT = new HashMap<Object, Integer>(3);
    private BloomType bloomType;
    private int expectedCount;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object type : TYPE_COUNT.keySet()) {
            params.add(new Object[]{type, TYPE_COUNT.get(type)});
        }
        return params;
    }

    public TestScannerSelectionUsingKeyRange(Object type, Object count) {
        this.bloomType = (BloomType)type;
        this.expectedCount = (Integer)count;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testScannerSelection() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.compactionThreshold", 10000);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY_BYTES).setBlockCacheEnabled(true).setBloomFilterType(this.bloomType);
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(TABLE);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)conf, (HTableDescriptor)htd);
        for (int iFile = 0; iFile < 2; ++iFile) {
            for (int iRow = 0; iRow < 8; ++iRow) {
                Put put = new Put(Bytes.toBytes((String)("row" + iRow)));
                for (int iCol = 0; iCol < 5; ++iCol) {
                    put.add(FAMILY_BYTES, Bytes.toBytes((String)("col" + iCol)), Bytes.toBytes((String)("value" + iFile + "_" + iRow + "_" + iCol)));
                }
                region.put(put);
            }
            region.flush(true);
        }
        Scan scan = new Scan(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"aaz"));
        CacheConfig.blockCacheDisabled = false;
        CacheConfig cacheConf = new CacheConfig(conf);
        LruBlockCache cache = (LruBlockCache)cacheConf.getBlockCache();
        cache.clearCache();
        RegionScanner scanner = region.getScanner(scan);
        ArrayList results = new ArrayList();
        while (scanner.next(results)) {
        }
        scanner.close();
        Assert.assertEquals((long)0L, (long)results.size());
        SortedSet accessedFiles = cache.getCachedFileNamesForTest();
        Assert.assertEquals((long)this.expectedCount, (long)accessedFiles.size());
        region.close();
    }

    static {
        TYPE_COUNT.put(BloomType.ROWCOL, 0);
        TYPE_COUNT.put(BloomType.ROW, 0);
        TYPE_COUNT.put(BloomType.NONE, 0);
    }
}

