/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStateStore;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransactionImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterFailover {
    private static final Log LOG = LogFactory.getLog(TestMasterFailover.class);

    @Test(timeout=240000L)
    public void testMasterFailoverWithMockedRIT() throws Exception {
        byte[] bytes;
        RegionTransition rt;
        boolean NUM_MASTERS = true;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.assignment.usezk", true);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj")};
        byte[] enabledTable = Bytes.toBytes((String)"enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(TableName.valueOf((byte[])enabledTable));
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        FileSystem filesystem = FileSystem.get((Configuration)conf);
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        FSTableDescriptors fstd = new FSTableDescriptors(conf, filesystem, rootdir);
        fstd.createTableDescriptor(htdEnabled);
        HRegionInfo hriEnabled = new HRegionInfo(htdEnabled.getTableName(), null, null);
        this.createRegion(hriEnabled, rootdir, conf, htdEnabled);
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        TableName disabledTable = TableName.valueOf((String)"disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        fstd.createTableDescriptor(htdDisabled);
        HRegionInfo hriDisabled = new HRegionInfo(htdDisabled.getTableName(), null, null);
        this.createRegion(hriDisabled, rootdir, conf, htdDisabled);
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        TableName tableWithMergingRegions = TableName.valueOf((String)"tableWithMergingRegions");
        TEST_UTIL.createTable(tableWithMergingRegions, FAMILY, (byte[][])new byte[][]{Bytes.toBytes((String)"m")});
        this.log("Regions in hbase:meta and namespace have been created");
        Assert.assertEquals((long)4L, (long)cluster.countServedRegions());
        AssignmentManager am = master.getAssignmentManager();
        RegionStates regionStates = am.getRegionStates();
        List mergingRegions = regionStates.getRegionsOfTable(tableWithMergingRegions);
        Assert.assertEquals((long)2L, (long)mergingRegions.size());
        HRegionInfo a = (HRegionInfo)mergingRegions.get(0);
        HRegionInfo b = (HRegionInfo)mergingRegions.get(1);
        HRegionInfo newRegion = RegionMergeTransactionImpl.getMergedRegionInfo((HRegionInfo)a, (HRegionInfo)b);
        ServerName mergingServer = regionStates.getRegionServerOfRegion(a);
        ServerName serverB = regionStates.getRegionServerOfRegion(b);
        if (!serverB.equals((Object)mergingServer)) {
            RegionPlan plan = new RegionPlan(b, serverB, mergingServer);
            am.balance(plan);
            Assert.assertTrue((boolean)am.waitForAssignment(b));
        }
        HRegionServer hrs = cluster.getRegionServer(0);
        ServerName serverName = hrs.getServerName();
        HRegionInfo closingRegion = enabledRegions.remove(0);
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(closingRegion);
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, serverName));
            master.assignmentManager.assign(hri, true);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, serverName));
            master.assignmentManager.assign(hri, true);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("Assignment completed");
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTableStateManager zktable = new ZKTableStateManager(zkw);
        zktable.setTableState(disabledTable, ZooKeeperProtos.Table.State.DISABLED);
        HRegionInfo region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
        regionsThatShouldBeOnline.add(closingRegion);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)closingRegion, (ServerName)serverName);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName, (int)version);
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName, (int)version);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices(), (ServerName)hrs.getServerName(), (HRegionInfo)region);
        while ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)serverName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices(), (ServerName)hrs.getServerName(), (HRegionInfo)region);
        while ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        hrs.getCoordinatedStateManager().getRegionMergeCoordination().startRegionMergeTransaction(newRegion, mergingServer, a, b);
        this.log("Done mocking data up in ZK");
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        regionStates = master.getAssignmentManager().getRegionStates();
        Assert.assertTrue((boolean)regionStates.isRegionInState(a, new RegionState.State[]{RegionState.State.MERGING}));
        Assert.assertTrue((boolean)regionStates.isRegionInState(b, new RegionState.State[]{RegionState.State.MERGING}));
        Assert.assertTrue((boolean)regionStates.isRegionInState(newRegion, new RegionState.State[]{RegionState.State.MERGING_NEW}));
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (HRegionInfo)newRegion);
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("No more RIT in ZK, now doing final test verification");
        TreeSet onlineRegions = new TreeSet();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            onlineRegions.addAll(ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rst.getRegionServer().getRSRpcServices()));
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            if (onlineRegions.contains(hri)) {
                LOG.debug((Object)hri);
            }
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMasterFailoverWithMockedRITOnDeadRS() throws Exception {
        byte[] bytes;
        RegionTransition rt;
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.assignment.usezk", true);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 2);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.error((Object)("Fatal ZK Error: " + why), e);
                Assert.assertFalse((String)"Fatal ZK error", (boolean)true);
            }

            public boolean isAborted() {
                return false;
            }
        });
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = TEST_UTIL.getRegionSplitStartKeys(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 30);
        byte[] enabledTable = Bytes.toBytes((String)"enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(TableName.valueOf((byte[])enabledTable));
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        FileSystem filesystem = FileSystem.get((Configuration)conf);
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        FSTableDescriptors fstd = new FSTableDescriptors(conf, filesystem, rootdir);
        fstd.createTableDescriptor(htdEnabled);
        HRegionInfo hriEnabled = new HRegionInfo(htdEnabled.getTableName(), null, null);
        this.createRegion(hriEnabled, rootdir, conf, htdEnabled);
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        TableName disabledTable = TableName.valueOf((String)"disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        fstd.createTableDescriptor(htdDisabled);
        HRegionInfo hriDisabled = new HRegionInfo(htdDisabled.getTableName(), null, null);
        this.createRegion(hriDisabled, rootdir, conf, htdDisabled);
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        this.log("Regions in hbase:meta and Namespace have been created");
        Assert.assertEquals((long)2L, (long)cluster.countServedRegions());
        List<JVMClusterUtil.RegionServerThread> regionservers = cluster.getRegionServerThreads();
        HRegionServer hrs = regionservers.get(0).getRegionServer();
        JVMClusterUtil.RegionServerThread hrsDeadThread = regionservers.get(1);
        HRegionServer hrsDead = hrsDeadThread.getRegionServer();
        ServerName deadServerName = hrsDead.getServerName();
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.addAll(enabledRegions.subList(0, 6));
        enabledRegions.removeAll(enabledAndAssignedRegions);
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.addAll(disabledRegions.subList(0, 6));
        disabledRegions.removeAll(disabledAndAssignedRegions);
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, hrs.getServerName()));
            master.assignmentManager.assign(hri, true);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, hrs.getServerName()));
            master.assignmentManager.assign(hri, true);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
        this.log("Assignment completed");
        Assert.assertTrue((String)" Table must be enabled.", (boolean)master.getAssignmentManager().getTableStateManager().isTableState(TableName.valueOf((String)"enabledTable"), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
        ArrayList<HRegionInfo> enabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        enabledAndOnDeadRegions.addAll(enabledRegions.subList(0, 6));
        enabledRegions.removeAll(enabledAndOnDeadRegions);
        ArrayList<HRegionInfo> disabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        disabledAndOnDeadRegions.addAll(disabledRegions.subList(0, 6));
        disabledRegions.removeAll(disabledAndOnDeadRegions);
        for (HRegionInfo hri : enabledAndOnDeadRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, deadServerName));
            master.assignmentManager.assign(hri, true);
        }
        for (HRegionInfo hri : disabledAndOnDeadRegions) {
            master.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, deadServerName));
            master.assignmentManager.assign(hri, true);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
        this.log("Assignment completed");
        this.verifyRegionLocation(hrs, enabledAndAssignedRegions);
        this.verifyRegionLocation(hrs, disabledAndAssignedRegions);
        this.verifyRegionLocation(hrsDead, enabledAndOnDeadRegions);
        this.verifyRegionLocation(hrsDead, disabledAndOnDeadRegions);
        Assert.assertTrue((String)" Didn't get enough regions of enabledTalbe on live rs.", (enabledAndAssignedRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of disalbedTable on live rs.", (disabledAndAssignedRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of enabledTalbe on dead rs.", (enabledAndOnDeadRegions.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)" Didn't get enough regions of disalbedTable on dead rs.", (disabledAndOnDeadRegions.size() >= 2 ? 1 : 0) != 0);
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTableStateManager zktable = new ZKTableStateManager(zkw);
        zktable.setTableState(disabledTable, ZooKeeperProtos.Table.State.DISABLED);
        Assert.assertTrue((String)" The enabled table should be identified on master fail over.", (boolean)zktable.isTableState(TableName.valueOf((String)"enabledTable"), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
        HRegionInfo region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        LOG.debug((Object)("\n\nRegion of enabled table was CLOSING on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        LOG.debug((Object)("\n\nRegion of disabled table was CLOSING on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName, (int)version);
        LOG.debug((Object)("\n\nRegion of enabled table was CLOSED on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName, (int)version);
        LOG.debug((Object)("\n\nRegion of disabled table was CLOSED on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        LOG.debug((Object)("\n\nRegion of enabled table was OPENING on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        LOG.debug((Object)("\n\nRegion of disabled table was OPENING on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrsDead.getRSRpcServices(), (ServerName)hrsDead.getServerName(), (HRegionInfo)region);
        while ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)("\n\nRegion of enabled table was OPENED on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrsDead.getRSRpcServices(), (ServerName)hrsDead.getServerName(), (HRegionInfo)region);
        while ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) == null || !rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)("\n\nRegion of disabled table was OPENED on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrsDead.getRSRpcServices(), (ServerName)hrsDead.getServerName(), (HRegionInfo)region);
        while (true) {
            if ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode((ZooKeeperWatcher)zkw, (String)region.getEncodedName(), (ServerName)rt.getServerName());
        LOG.debug((Object)("DELETED " + rt));
        LOG.debug((Object)("\n\nRegion of enabled table was open at steady-state on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (ServerName)deadServerName);
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrsDead.getRSRpcServices(), (ServerName)hrsDead.getServerName(), (HRegionInfo)region);
        while (true) {
            if ((rt = RegionTransition.parseFrom((byte[])(bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())))) != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_OPENED)) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode((ZooKeeperWatcher)zkw, (String)region.getEncodedName(), (ServerName)rt.getServerName());
        LOG.debug((Object)("\n\nRegion of disabled table was open at steady-state on dead RS\n" + region + "\n\n"));
        this.log("Done mocking data up in ZK");
        this.log("Killing RS " + deadServerName);
        hrsDead.abort("Killing for unit test");
        this.log("RS " + deadServerName + " killed");
        while (hrsDeadThread.isAlive()) {
            Threads.sleep((long)10L);
        }
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        this.log("Master is ready");
        while (master.getServerManager().areDeadServersInProgress()) {
            Thread.sleep(10L);
        }
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("No more RIT in ZK");
        long now = System.currentTimeMillis();
        long maxTime = 120000L;
        boolean done = master.assignmentManager.waitUntilNoRegionsInTransition(maxTime);
        if (!done) {
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            LOG.info((Object)("rit=" + regionStates.getRegionsInTransition()));
        }
        long elapsed = System.currentTimeMillis() - now;
        Assert.assertTrue((String)("Elapsed=" + elapsed + ", maxTime=" + maxTime + ", done=" + done), (elapsed < maxTime ? 1 : 0) != 0);
        this.log("No more RIT in RIT map, doing final test verification");
        TreeSet onlineRegions = new TreeSet();
        now = System.currentTimeMillis();
        maxTime = 30000L;
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            try {
                HRegionServer rs = rst.getRegionServer();
                while (!rs.getRegionsInTransitionInRS().isEmpty()) {
                    elapsed = System.currentTimeMillis() - now;
                    Assert.assertTrue((String)"Test timed out in getting online regions", (elapsed < maxTime ? 1 : 0) != 0);
                    if (rs.isAborted() || rs.isStopped()) break;
                    Thread.sleep(100L);
                }
                onlineRegions.addAll(ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()));
            }
            catch (RegionServerStoppedException e) {
                LOG.info((Object)"Got RegionServerStoppedException", (Throwable)e);
            }
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((String)("region=" + hri.getRegionNameAsString() + ", " + ((Object)onlineRegions).toString()), (boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    private void verifyRegionLocation(HRegionServer hrs, List<HRegionInfo> regions) throws IOException {
        List tmpOnlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
        Iterator<HRegionInfo> itr = regions.iterator();
        while (itr.hasNext()) {
            HRegionInfo tmp = itr.next();
            if (tmpOnlineRegions.contains(tmp)) continue;
            itr.remove();
        }
    }

    HRegion createRegion(HRegionInfo hri, Path rootdir, Configuration c, HTableDescriptor htd) throws IOException {
        HRegion r = HRegion.createHRegion((HRegionInfo)hri, (Path)rootdir, (Configuration)c, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)r);
        return r;
    }

    private void log(String string) {
        LOG.info((Object)("\n\n" + string + " \n\n"));
    }

    @Test(timeout=180000L)
    public void testShouldCheckMasterFailOverWhenMETAIsInOpenedState() throws Exception {
        LOG.info((Object)"Starting testShouldCheckMasterFailOverWhenMETAIsInOpenedState");
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.master.info.port", -1);
        conf.setBoolean("hbase.assignment.usezk", true);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = cluster.getRegionServerThreads();
        Region metaRegion = null;
        HRegionServer metaRegionServer = null;
        for (JVMClusterUtil.RegionServerThread regionServerThread : regionServerThreads) {
            HRegionServer regionServer = regionServerThread.getRegionServer();
            metaRegion = regionServer.getOnlineRegion(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
            regionServer.abort("");
            if (null == metaRegion) continue;
            metaRegionServer = regionServer;
            break;
        }
        Assert.assertNotNull(metaRegion);
        Assert.assertNotNull(metaRegionServer);
        TEST_UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(TEST_UTIL, metaRegion, metaRegionServer.getServerName());
        LOG.info((Object)"Staring cluster for second time");
        TEST_UTIL.startMiniHBaseCluster(1, 2);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        while (!master.isInitialized()) {
            Thread.sleep(100L);
        }
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        zkw.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=240000L)
    public void testOfflineRegionReAssginedAfterMasterRestart() throws Exception {
        ServerManager serverManager;
        TableName table = TableName.valueOf((String)"testOfflineRegionReAssginedAfterMasterRestart");
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.assignment.usezk", true);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 2);
        this.log("Cluster started");
        TEST_UTIL.createTable(table, Bytes.toBytes((String)"family"));
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        HRegionInfo hri = (HRegionInfo)regionStates.getRegionsOfTable(table).get(0);
        ServerName serverName = regionStates.getRegionServerOfRegion(hri);
        TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        ServerName dstName = null;
        for (ServerName tmpServer : master.serverManager.getOnlineServers().keySet()) {
            if (tmpServer.equals((Object)serverName)) continue;
            dstName = tmpServer;
            break;
        }
        Assert.assertTrue((dstName != null ? 1 : 0) != 0);
        TEST_UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)dstName);
        Stat stat = new Stat();
        byte[] data = ZKAssign.getDataNoWatch((ZooKeeperWatcher)zkw, (String)hri.getEncodedName(), (Stat)stat);
        Assert.assertTrue((data != null ? 1 : 0) != 0);
        RegionTransition rt = RegionTransition.parseFrom((byte[])data);
        Assert.assertTrue((rt.getEventType() == EventType.M_ZK_REGION_OFFLINE ? 1 : 0) != 0);
        LOG.info((Object)(hri.getEncodedName() + " region is in offline state with source server=" + serverName + " and dst server=" + dstName));
        TEST_UTIL.startMiniHBaseCluster(1, 2);
        while ((master = TEST_UTIL.getHBaseCluster().getMaster()) == null || !master.isInitialized() || (serverManager = master.getServerManager()).areDeadServersInProgress()) {
            Thread.sleep(200L);
        }
        master = TEST_UTIL.getHBaseCluster().getMaster();
        master.getAssignmentManager().waitForAssignment(hri);
        regionStates = master.getAssignmentManager().getRegionStates();
        RegionState newState = regionStates.getRegionState(hri);
        Assert.assertTrue((boolean)newState.isOpened());
    }

    @Test(timeout=240000L)
    public void testSimpleMasterFailover() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        int numActive = 0;
        int activeIndex = -1;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        LOG.info((Object)("Active master " + activeName));
        Assert.assertNotNull((Object)active);
        ClusterStatus status = active.getClusterStatus();
        Assert.assertEquals((Object)status.getMaster(), (Object)activeName);
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)2L, (long)status.getBackupMasters().size());
        int backupIndex = activeIndex == 0 ? 1 : activeIndex - 1;
        HMaster master = cluster.getMaster(backupIndex);
        LOG.debug((Object)("\n\nStopping a backup master: " + master.getServerName() + "\n"));
        cluster.stopMaster(backupIndex, false);
        cluster.waitOnMaster(backupIndex);
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            Assert.assertEquals((Object)activeName, (Object)masterThreads.get(i).getMaster().getServerName());
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)2L, (long)masterThreads.size());
        int rsCount = masterThreads.get(activeIndex).getMaster().getClusterStatus().getServersSize();
        LOG.info((Object)("Active master " + active.getServerName() + " managing " + rsCount + " regions servers"));
        Assert.assertEquals((long)3L, (long)rsCount);
        final HMaster activeFinal = active;
        TEST_UTIL.waitFor(TimeUnit.SECONDS.toMillis(30L), new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return activeFinal.getBackupMasters().size() == 1;
            }
        });
        Assert.assertNotNull((Object)active);
        final HMaster finalActive = active;
        TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ClusterStatus status = finalActive.getClusterStatus();
                return status.getBackupMastersSize() == 1 && status.getBackupMasters().size() == 1;
            }
        });
        status = active.getClusterStatus();
        Assert.assertEquals((Object)activeName, (Object)status.getMaster());
        LOG.debug((Object)("\n\nStopping the active master " + active.getServerName() + "\n"));
        cluster.stopMaster(activeIndex, false);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        LOG.debug((Object)"\n\nVerifying backup master is now active\n");
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        active = masterThreads.get(0).getMaster();
        Assert.assertNotNull((Object)active);
        status = active.getClusterStatus();
        ServerName masterName = status.getMaster();
        Assert.assertNotNull((Object)masterName);
        Assert.assertEquals((Object)active.getServerName(), (Object)masterName);
        Assert.assertTrue((boolean)active.isActiveMaster());
        Assert.assertEquals((long)0L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)0L, (long)status.getBackupMasters().size());
        int rss = status.getServersSize();
        LOG.info((Object)("Active master " + masterName.getServerName() + " managing " + rss + " region servers"));
        Assert.assertEquals((long)3L, (long)rss);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testPendingOpenOrCloseWhenMasterFailover() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.assignment.usezk", false);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 1);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        Table onlineTable = TEST_UTIL.createTable(TableName.valueOf((String)"onlineTable"), "family");
        onlineTable.close();
        HTableDescriptor offlineTable = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)"offlineTable")));
        offlineTable.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"family")));
        FileSystem filesystem = FileSystem.get((Configuration)conf);
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        FSTableDescriptors fstd = new FSTableDescriptors(conf, filesystem, rootdir);
        fstd.createTableDescriptor(offlineTable);
        HRegionInfo hriOffline = new HRegionInfo(offlineTable.getTableName(), null, null);
        this.createRegion(hriOffline, rootdir, conf, offlineTable);
        MetaTableAccessor.addRegionToMeta((Connection)master.getConnection(), (HRegionInfo)hriOffline);
        this.log("Regions in hbase:meta and namespace have been created");
        Assert.assertEquals((long)3L, (long)cluster.countServedRegions());
        HRegionInfo hriOnline = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(TableName.valueOf((String)"onlineTable"));){
            hriOnline = locator.getRegionLocation(HConstants.EMPTY_START_ROW).getRegionInfo();
        }
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        RegionStateStore stateStore = master.getAssignmentManager().getRegionStateStore();
        RegionState oldState = regionStates.getRegionState(hriOnline);
        RegionState newState = new RegionState(hriOnline, RegionState.State.PENDING_CLOSE, oldState.getServerName());
        stateStore.updateRegionState(-1L, newState, oldState);
        oldState = new RegionState(hriOffline, RegionState.State.OFFLINE);
        newState = new RegionState(hriOffline, RegionState.State.PENDING_OPEN, newState.getServerName());
        stateStore.updateRegionState(-1L, newState, oldState);
        HRegionInfo failedClose = new HRegionInfo(offlineTable.getTableName(), null, null);
        this.createRegion(failedClose, rootdir, conf, offlineTable);
        MetaTableAccessor.addRegionToMeta((Connection)master.getConnection(), (HRegionInfo)failedClose);
        oldState = new RegionState(failedClose, RegionState.State.PENDING_CLOSE);
        newState = new RegionState(failedClose, RegionState.State.FAILED_CLOSE, newState.getServerName());
        stateStore.updateRegionState(-1L, newState, oldState);
        HRegionInfo failedOpen = new HRegionInfo(offlineTable.getTableName(), null, null);
        this.createRegion(failedOpen, rootdir, conf, offlineTable);
        MetaTableAccessor.addRegionToMeta((Connection)master.getConnection(), (HRegionInfo)failedOpen);
        oldState = new RegionState(failedOpen, RegionState.State.PENDING_OPEN);
        newState = new RegionState(failedOpen, RegionState.State.FAILED_OPEN, newState.getServerName());
        stateStore.updateRegionState(-1L, newState, oldState);
        HRegionInfo failedOpenNullServer = new HRegionInfo(offlineTable.getTableName(), null, null);
        this.createRegion(failedOpenNullServer, rootdir, conf, offlineTable);
        MetaTableAccessor.addRegionToMeta((Connection)master.getConnection(), (HRegionInfo)failedOpenNullServer);
        oldState = new RegionState(failedOpenNullServer, RegionState.State.OFFLINE);
        newState = new RegionState(failedOpenNullServer, RegionState.State.FAILED_OPEN, null);
        stateStore.updateRegionState(-1L, newState, oldState);
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        master.getAssignmentManager().waitUntilNoRegionsInTransition(60000L);
        regionStates = master.getAssignmentManager().getRegionStates();
        Assert.assertTrue((boolean)regionStates.isRegionOnline(hriOffline));
        Assert.assertTrue((boolean)regionStates.isRegionOnline(hriOnline));
        Assert.assertTrue((boolean)regionStates.isRegionOnline(failedClose));
        Assert.assertTrue((boolean)regionStates.isRegionOnline(failedOpenNullServer));
        Assert.assertTrue((boolean)regionStates.isRegionOnline(failedOpen));
        this.log("Done with verification, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMetaInTransitionWhenMasterFailover() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.assignment.usezk", false);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 1);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        this.log("Moving meta off the master");
        HMaster activeMaster = cluster.getMaster();
        HRegionServer rs = cluster.getRegionServer(0);
        ServerName metaServerName = cluster.getLiveRegionServerThreads().get(0).getRegionServer().getServerName();
        activeMaster.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)metaServerName.getServerName()));
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertEquals((String)"Meta should be assigned on expected regionserver", (Object)metaServerName, (Object)activeMaster.getMetaTableLocator().getMetaRegionLocation(activeMaster.getZooKeeper()));
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        RegionState metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)rs.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)activeMaster.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)activeMaster.getZooKeeper(), (ServerName)rs.getServerName(), (RegionState.State)RegionState.State.PENDING_OPEN);
        Region meta = rs.getFromOnlineRegions(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        rs.removeFromOnlineRegions(meta, null);
        ((HRegion)meta).close();
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Meta was assigned");
        metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)activeMaster.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be onlined on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)activeMaster.getZooKeeper(), (ServerName)rs.getServerName(), (RegionState.State)RegionState.State.PENDING_CLOSE);
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        rs.getRSRpcServices().closeRegion(null, RequestConverter.buildCloseRegionRequest((ServerName)rs.getServerName(), (String)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName(), (boolean)false));
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Meta was assigned");
        rs.getRSRpcServices().closeRegion(null, RequestConverter.buildCloseRegionRequest((ServerName)rs.getServerName(), (String)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName(), (boolean)false));
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)activeMaster.getZooKeeper(), (ServerName)ServerName.valueOf((String)"dummyserver.example.org", (int)1234, (long)-1L), (RegionState.State)RegionState.State.OPEN);
        this.log("Aborting master");
        activeMaster.stop("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Meta was assigned");
        TEST_UTIL.shutdownMiniCluster();
    }
}

