/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotFileCache {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFileCache.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final long PERIOD = Long.MAX_VALUE;
    private static FileSystem fs;
    private static Path rootDir;
    private static Path snapshotDir;

    @BeforeClass
    public static void startCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
        fs = UTIL.getDFSCluster().getFileSystem();
        rootDir = UTIL.getDefaultRootDirPath();
        snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
    }

    @After
    public void cleanupFiles() throws Exception {
        fs.delete(snapshotDir, true);
    }

    @Test(timeout=10000000L)
    @Ignore(value="See HBASE-19275")
    public void testLoadAndDelete() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1a", false, true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2a", false, true, false);
    }

    @Test
    @Ignore(value="See HBASE-19275")
    public void testReloadModifiedDirectory() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1", false, true, false);
        this.createAndTestSnapshotV1(cache, "snapshot1", false, false, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, false, false);
    }

    @Test
    public void testSnapshotTempDirReload() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot0v1", false, false, false);
        this.createAndTestSnapshotV1(cache, "snapshot0v2", false, false, false);
    }

    @Test
    public void testCacheUpdatedWhenLastModifiedOfSnapDirNotUpdated() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1v1", false, false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1v2", false, false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2v1", true, false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2v2", true, false, true);
    }

    private SnapshotTestingUtils.SnapshotMock.SnapshotBuilder createAndTestSnapshotV1(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit, setFolderTime);
        return builder;
    }

    private void createAndTestSnapshotV2(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit, setFolderTime);
    }

    private void createAndTestSnapshot(SnapshotFileCache cache, SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < 3; ++i) {
            for (Path filePath : builder.addRegion()) {
                files.add(filePath);
            }
        }
        builder.commit();
        if (setFolderTime) {
            fs.setTimes(snapshotDir, 0L, -1L);
        }
        for (Path path : files) {
            Assert.assertFalse((String)("Cache didn't find " + path), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, path), path));
        }
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        if (removeOnExit) {
            LOG.debug((Object)"Deleting snapshot.");
            fs.delete(builder.getSnapshotsDir(), true);
            FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
            for (Path filePath : files) {
                Assert.assertFalse((String)("Cache didn't find " + filePath), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, filePath), filePath));
            }
            cache.triggerCacheRefreshForTesting();
            for (Path filePath : files) {
                Assert.assertFalse((String)("Cache found '" + filePath + "', but it shouldn't have."), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, filePath), filePath));
            }
        }
    }

    private static boolean contains(Iterable<FileStatus> files, Path filePath) {
        for (FileStatus status : files) {
            if (!filePath.equals((Object)status.getPath())) continue;
            return true;
        }
        return false;
    }

    private static Iterable<FileStatus> getNonSnapshotFiles(SnapshotFileCache cache, Path storeFile) throws IOException {
        return cache.getUnreferencedFiles(Arrays.asList(FSUtils.listStatus((FileSystem)fs, (Path)storeFile.getParent())), null);
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHFileNames((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)snapshotDir));
            return files;
        }
    }
}

