/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreChunkPool;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMemStoreChunkPool {
    private static final Configuration conf = new Configuration();
    private static MemStoreChunkPool chunkPool;
    private static boolean chunkPoolDisabledBeforeTest;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        conf.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        chunkPoolDisabledBeforeTest = MemStoreChunkPool.chunkPoolDisabled;
        MemStoreChunkPool.chunkPoolDisabled = false;
        chunkPool = MemStoreChunkPool.getPool((Configuration)conf);
        Assert.assertTrue((chunkPool != null ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        MemStoreChunkPool.chunkPoolDisabled = chunkPoolDisabledBeforeTest;
    }

    @After
    public void tearDown() throws Exception {
        chunkPool.clearChunks();
    }

    @Test
    public void testReusingChunks() {
        Random rand = new Random();
        HeapMemStoreLAB mslab = new HeapMemStoreLAB(conf);
        int expectedOff = 0;
        byte[] lastBuffer = null;
        for (int i = 0; i < 100; ++i) {
            int size = rand.nextInt(1000);
            ByteRange alloc = mslab.allocateBytes(size);
            if (alloc.getBytes() != lastBuffer) {
                expectedOff = 0;
                lastBuffer = alloc.getBytes();
            }
            Assert.assertEquals((long)expectedOff, (long)alloc.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (alloc.getOffset() + size <= alloc.getBytes().length ? 1 : 0) != 0);
            expectedOff += size;
        }
        mslab.close();
        int chunkCount = chunkPool.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
        mslab = new HeapMemStoreLAB(conf);
        mslab.allocateBytes(1000);
        Assert.assertEquals((long)(chunkCount - 1), (long)chunkPool.getPoolSize());
    }

    @Test
    public void testPuttingBackChunksAfterFlushing() throws UnexpectedStateException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val));
        memstore.add((Cell)new KeyValue(row, fam, qf2, val));
        memstore.add((Cell)new KeyValue(row, fam, qf3, val));
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.snapshotSection.getCellSkipListSet().sizeForTests());
        Assert.assertEquals((long)0L, (long)memstore.activeSection.getCellSkipListSet().sizeForTests());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val));
        memstore.add((Cell)new KeyValue(row, fam, qf5, val));
        Assert.assertEquals((long)2L, (long)memstore.activeSection.getCellSkipListSet().sizeForTests());
        memstore.clearSnapshot(snapshot.getId());
        int chunkCount = chunkPool.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPuttingBackChunksWithOpeningScanner() throws UnexpectedStateException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] qf6 = Bytes.toBytes((String)"testqualifier6");
        byte[] qf7 = Bytes.toBytes((String)"testqualifier7");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val));
        memstore.add((Cell)new KeyValue(row, fam, qf2, val));
        memstore.add((Cell)new KeyValue(row, fam, qf3, val));
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.snapshotSection.getCellSkipListSet().sizeForTests());
        Assert.assertEquals((long)0L, (long)memstore.activeSection.getCellSkipListSet().sizeForTests());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val));
        memstore.add((Cell)new KeyValue(row, fam, qf5, val));
        Assert.assertEquals((long)2L, (long)memstore.activeSection.getCellSkipListSet().sizeForTests());
        List scanners = memstore.getScanners(0L);
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkPool.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkPool.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkPool.clearChunks();
        snapshot = memstore.snapshot();
        memstore.add((Cell)new KeyValue(row, fam, qf6, val));
        memstore.add((Cell)new KeyValue(row, fam, qf7, val));
        scanners = memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkPool.getPoolSize() > 0 ? 1 : 0) != 0);
    }
}

