/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithDeletes {
    private static final Log LOG = LogFactory.getLog(TestVisibilityLabelsWithDeletes.class);
    private static final String TOPSECRET = "TOPSECRET";
    private static final String PUBLIC = "PUBLIC";
    private static final String PRIVATE = "PRIVATE";
    private static final String CONFIDENTIAL = "CONFIDENTIAL";
    private static final String SECRET = "SECRET";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] fam = Bytes.toBytes((String)"info");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    private static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    private static final byte[] value = Bytes.toBytes((String)"value");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithDeletes.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumns() throws Throwable {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, "SECRET&TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET&SECRET"));
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamily() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, SECRET, "CONFIDENTIAL|TOPSECRET");){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row2);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        long[] ts = new long[]{123L, 125L};
        try (Table table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, ts, "CONFIDENTIAL|TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.deleteFamilyVersion(fam, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnExactVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        long[] ts = new long[]{123L, 125L};
        try (Table table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, ts, "CONFIDENTIAL|TOPSECRET", SECRET);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.addColumn(fam, qual, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d1 = new Delete(row1);
                        d1.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d1.addColumns(fam, qual);
                        table.delete(d1);
                        Delete d2 = new Delete(row1);
                        d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d2.addColumns(fam, qual);
                        table.delete(d2);
                        Delete d3 = new Delete(row1);
                        d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d3.addColumns(fam, qual);
                        table.delete(d3);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithNoMatchVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.addColumns(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.addColumns(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d1 = new Delete(row1);
                        d1.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d1.addFamily(fam);
                        table.delete(d1);
                        Delete d2 = new Delete(row1);
                        d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d2.addFamily(fam);
                        table.delete(d2);
                        Delete d3 = new Delete(row1);
                        d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d3.addFamily(fam);
                        table.delete(d3);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnsWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            Delete d = new Delete(row1);
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)1L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteColumnsWithAndWithoutVisibilityLabels() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            Delete d = new Delete(row1);
            d.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteFamiliesWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            Delete d = new Delete(row1);
            d.addFamily(fam);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)1L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            d.addFamily(fam);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteFamiliesWithAndWithoutVisibilityLabels() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            Delete d = new Delete(row1);
            d.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            d.addFamily(fam);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.addFamily(fam);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeletesWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            Delete d = new Delete(row1);
            d.addColumn(fam, qual);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)1L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            d.addColumn(fam, qual);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)next.length, (long)0L);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithPutsReAppearing() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value1);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)next1.length, (long)0L);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithPutsReAppearing() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value1);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)next1.length, (long)0L);
        }
    }

    @Test
    public void testVisibilityCombinations() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 124L, value1);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d;
                    Throwable throwable;
                    Table table;
                    Throwable throwable2;
                    Connection connection;
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)conf);
                        throwable2 = null;
                        try {
                            table = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d = new Delete(row1);
                                d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                                d.addColumns(fam, qual, 126L);
                                table.delete(d);
                            }
                            catch (Throwable x2) {
                                throwable = x2;
                                throw x2;
                            }
                            finally {
                                if (table != null) {
                                    if (throwable != null) {
                                        try {
                                            table.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                    } else {
                                        table.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable x2) {
                            throwable2 = x2;
                            throw x2;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable2 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)conf);
                        throwable2 = null;
                        try {
                            table = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d = new Delete(row1);
                                d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                                d.addColumn(fam, qual, 123L);
                                table.delete(d);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (table != null) {
                                    if (throwable != null) {
                                        try {
                                            table.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                    } else {
                                        table.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable2 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL, SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)0L);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnWithSpecificVersionWithPutsReAppearing() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put1 = new Put(Bytes.toBytes((String)"row1"));
            put1.add(fam, qual, 123L, value);
            put1.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            Put put2 = new Put(Bytes.toBytes((String)"row1"));
            put2.add(fam, qual, 123L, value1);
            put2.setCellVisibility(new CellVisibility(SECRET));
            table.put(TestVisibilityLabelsWithDeletes.createList(put1, put2));
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL, SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Assert.assertEquals((long)scanner.next(3).length, (long)1L);
            scanner.close();
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d;
                    Throwable throwable;
                    Table table;
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                        table = connection.getTable(tableName);
                        throwable = null;
                        try {
                            d = new Delete(row1);
                            d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                            d.addColumn(fam, qual, 123L);
                            table.delete(d);
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (table != null) {
                                if (throwable != null) {
                                    try {
                                        table.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    table.close();
                                }
                            }
                        }
                    }
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)conf);
                        var2_3 = null;
                        try {
                            table = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d = new Delete(row1);
                                d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                                d.addColumn(fam, qual, 123L);
                                table.delete(d);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (table != null) {
                                    if (throwable != null) {
                                        try {
                                            table.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                    } else {
                                        table.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            var2_3 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (connection != null) {
                                if (var2_3 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable x2) {
                                        var2_3.addSuppressed(x2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            Assert.assertEquals((long)scanner.next(3).length, (long)0L);
            scanner.close();
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithNoMatchingVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(row1);
                    d1.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                    d1.addFamily(fam);
                    Delete d2 = new Delete(row1);
                    d2.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                    d2.addFamily(fam);
                    Delete d3 = new Delete(row1);
                    d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                    d3.addFamily(fam);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2, d3));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            scanner.close();
        }
    }

    @Test
    public void testDeleteFamilyAndDeleteColumnsWithAndWithoutVisibilityExp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(row1);
                    d1.addFamily(fam);
                    Delete d2 = new Delete(row1);
                    d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                    d2.addColumns(fam, qual);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            scanner.close();
        }
    }

    private Table doPuts(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 126L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2"));
        put.add(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        HTable table = new HTable(conf, tableName);
        table.put(puts);
        return table;
    }

    private Table doPutsWithDiffCols(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual1, 126L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual2, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        HTable table = new HTable(conf, tableName);
        table.put(puts);
        return table;
    }

    private Table doPutsWithoutVisibility(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 126L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 127L, value);
        puts.add(put);
        HTable table = new HTable(conf, tableName);
        table.put(puts);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2"));
        put.add(fam, qual, 127L, value);
        table.put(put);
        return table;
    }

    @Test
    public void testDeleteColumnWithSpecificTimeStampUsingMultipleVersionsUnMatchingVisExpression() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test(timeout=180000L)
    public void testDeleteColumnWithLatestTimeStampWhenNoVersionMatches() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 128L, value);
            put.setCellVisibility(new CellVisibility(TOPSECRET));
            table.put(put);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.addColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)128L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 129L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)129L);
        }
    }

    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersionsAfterCompaction() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.add(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            TEST_UTIL.getHBaseAdmin().majorCompact(tableName);
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnswithMultipleColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPutsWithDiffCols(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d = new Delete(row1);
                    d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                    d.addColumns(fam, qual, 125L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual1, (int)0, (int)qual1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual2, (int)0, (int)qual2.length));
        }
    }

    @Test
    public void testDeleteColumnsWithDiffColsAndTags() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(row1);
                    d1.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                    d1.addColumns(fam, qual, 126L);
                    Delete d2 = new Delete(row1);
                    d2.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                    d2.addColumns(fam, qual1, 125L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
        }
    }

    @Test
    public void testDeleteColumnsWithDiffColsAndTags1() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(row1);
                    d1.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                    d1.addColumns(fam, qual, 126L);
                    Delete d2 = new Delete(row1);
                    d2.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                    d2.addColumns(fam, qual1, 126L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
        }
    }

    @Test
    public void testDeleteFamilyWithoutCellVisibilityWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPutsWithoutVisibility(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersionsWithoutCellVisibilityInPuts() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPutsWithoutVisibility(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addFamily(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(6);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testScanAfterCompaction() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addFamily(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.add(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            TEST_UTIL.getHBaseAdmin().compact(tableName);
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addFamily(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addFamily(fam, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
    }

    @Test
    public void testMultipleDeleteFamilyVersionWithDiffLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET}, (String)SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable4) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = (VisibilityLabelsProtos.VisibilityLabelsResponse)SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamilyVersion(fam, 123L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
    }

    @Test(timeout=180000L)
    public void testSpecificDeletesFollowedByDeleteFamily() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 126L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
    }

    @Test(timeout=180000L)
    public void testSpecificDeletesFollowedByDeleteFamily1() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET}, (String)SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable4) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = (VisibilityLabelsProtos.VisibilityLabelsResponse)SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice1() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice2() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
    }

    @Test
    public void testDeleteColumnAndDeleteFamilylSpecificTimeStampWithMulipleVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addFamily(fam, 124L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
    }

    private void setAuths() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET, TestVisibilityLabelsWithDeletes.TOPSECRET}, (String)SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable4) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test
    public void testDiffDeleteTypesForTheSameCellUsingMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnLatestWithNoCellVisibility() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addFamily(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.deleteFamilyVersion(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
        }
    }

    @Test
    public void testDeleteWithNoVisibilitiesForPutsAndDeletes() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual, value);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual1, value);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(fam, qual, value);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(fam, qual1, value);
        table.put(p);
        Delete d = new Delete(Bytes.toBytes((String)"row1"));
        table.delete(d);
        Get g = new Get(Bytes.toBytes((String)"row1"));
        g.setMaxVersions();
        g.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE}));
        Result result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
        p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual, value);
        table.put(p);
        result = table.get(g);
        Assert.assertEquals((long)1L, (long)result.rawCells().length);
    }

    @Test
    public void testDeleteWithFamilyDeletesOfSameTsButDifferentVisibilities() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        long t1 = 1234L;
        CellVisibility cellVisibility1 = new CellVisibility(SECRET);
        CellVisibility cellVisibility2 = new CellVisibility(PRIVATE);
        Put p = new Put(row1);
        p.addColumn(fam, qual, t1, value);
        p.setCellVisibility(cellVisibility1);
        table.put(p);
        p = new Put(row1);
        p.addColumn(fam, qual1, t1, value);
        p.setCellVisibility(cellVisibility2);
        table.put(p);
        Delete d = new Delete(row1);
        d.addFamily(fam, t1);
        d.setCellVisibility(cellVisibility2);
        table.delete(d);
        d = new Delete(row1);
        d.addFamily(fam, t1);
        d.setCellVisibility(cellVisibility1);
        table.delete(d);
        Get g = new Get(row1);
        g.setMaxVersions();
        g.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE}));
        Result result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
        p = new Put(row2);
        p.addColumn(fam, qual, t1, value);
        p.setCellVisibility(cellVisibility1);
        table.put(p);
        p = new Put(row2);
        p.addColumn(fam, qual1, t1, value);
        p.setCellVisibility(cellVisibility2);
        table.put(p);
        d = new Delete(row2);
        d.addFamilyVersion(fam, t1);
        d.setCellVisibility(cellVisibility2);
        table.delete(d);
        d = new Delete(row2);
        d.addFamilyVersion(fam, t1);
        d.setCellVisibility(cellVisibility1);
        table.delete(d);
        g = new Get(row2);
        g.setMaxVersions();
        g.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE}));
        result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
    }

    private void scanAll(Result[] next) throws IOException {
        CellScanner cellScanner = next[0].cellScanner();
        cellScanner.advance();
        Cell current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)126L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)125L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)123L);
        cellScanner = next[1].cellScanner();
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
    }

    @Test
    public void testVisibilityExpressionWithNotEqualORCondition() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        try (HTable table = new HTable(conf, tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 124L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL|PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(row1);
                        d.addColumn(fam, qual, 124L);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.PRIVATE));
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
        }
    }

    public static Table createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        HTable table = null;
        table = TEST_UTIL.createTable(tableName, fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            ++i;
        }
        return table;
    }

    public static Table createTableAndWriteDataWithLabels(TableName tableName, long[] timestamp, String ... labelExps) throws Exception {
        HTable table = null;
        table = TEST_UTIL.createTable(tableName, fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.add(fam, qual, timestamp[i - 1], value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            ++i;
        }
        return table;
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabelsWithDeletes.SECRET, TestVisibilityLabelsWithDeletes.TOPSECRET, TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PUBLIC, TestVisibilityLabelsWithDeletes.PRIVATE};
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    private static Delete addDeleteMark(Delete d, DeleteMark mark, long now) {
        switch (mark) {
            case ROW: {
                break;
            }
            case FAMILY: {
                d.addFamily(fam);
                break;
            }
            case FAMILY_VERSION: {
                d.addFamilyVersion(fam, now);
                break;
            }
            case COLUMN: {
                d.addColumns(fam, qual);
                break;
            }
            case CELL: {
                d.addColumn(fam, qual);
                break;
            }
        }
        return d;
    }

    @Test
    public void testDeleteCellWithoutVisibility() throws IOException, InterruptedException {
        for (DeleteMark mark : DeleteMark.values()) {
            this.testDeleteCellWithoutVisibility(mark);
        }
    }

    private void testDeleteCellWithoutVisibility(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithoutVisibility-" + mark.name()));
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        long now = System.currentTimeMillis();
        ArrayList<Put> puts = new ArrayList<Put>(1);
        Put put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    @Test
    public void testDeleteCellWithVisibility() throws IOException, InterruptedException {
        for (DeleteMark mark : DeleteMark.values()) {
            this.testDeleteCellWithVisibility(mark);
            this.testDeleteCellWithVisibilityV2(mark);
        }
    }

    private void testDeleteCellWithVisibility(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithVisibility-" + mark.name()));
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        long now = System.currentTimeMillis();
        ArrayList<Put> puts = new ArrayList<Put>(2);
        Put put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value1);
        } else {
            put.addColumn(fam, qual, value1);
        }
        put.setCellVisibility(new CellVisibility(PRIVATE));
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1).setCellVisibility(new CellVisibility(PRIVATE)), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    private void testDeleteCellWithVisibilityV2(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithVisibilityV2-" + mark.name()));
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        long now = System.currentTimeMillis();
        ArrayList<Put> puts = new ArrayList<Put>(2);
        Put put = new Put(row1);
        put.setCellVisibility(new CellVisibility(PRIVATE));
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value1);
        } else {
            put.addColumn(fam, qual, value1);
        }
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)0L, (long)r.size());
            d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1).setCellVisibility(new CellVisibility(PRIVATE)), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{PRIVATE})));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    private static enum DeleteMark {
        ROW,
        FAMILY,
        FAMILY_VERSION,
        COLUMN,
        CELL;

    }
}

