/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotDescriptionUtils {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path root;
    private static final Log LOG;

    @BeforeClass
    public static void setupFS() throws Exception {
        fs = UTIL.getTestFileSystem();
        root = new Path(UTIL.getDataTestDir(), "hbase");
    }

    @After
    public void cleanupFS() throws Exception {
        if (fs.exists(root)) {
            if (!fs.delete(root, true)) {
                throw new IOException("Failed to delete root test dir: " + root);
            }
            if (!fs.mkdirs(root)) {
                throw new IOException("Failed to create root test dir: " + root);
            }
        }
        EnvironmentEdgeManagerTestHelper.reset();
    }

    @Test
    public void testValidateMissingTableName() {
        Configuration conf = new Configuration(false);
        try {
            SnapshotDescriptionUtils.validate((HBaseProtos.SnapshotDescription)HBaseProtos.SnapshotDescription.newBuilder().setName("fail").build(), (Configuration)conf);
            Assert.fail((String)"Snapshot was considered valid without a table name");
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"Correctly failed when snapshot doesn't have a tablename");
        }
        catch (IOException e) {
            LOG.debug((Object)"Correctly failed when saving acl into snapshot");
        }
    }

    @Test
    public void testCompleteSnapshotWithNoSnapshotDirectoryFailure() throws Exception {
        Path snapshotDir = new Path(root, ".hbase-snapshot");
        Path tmpDir = new Path(snapshotDir, ".tmp");
        Path workingDir = new Path(tmpDir, "not_a_snapshot");
        Configuration conf = new Configuration();
        Assert.assertFalse((String)("Already have working snapshot dir: " + workingDir + " but shouldn't. Test file leak?"), (boolean)fs.exists(workingDir));
        try {
            SnapshotDescriptionUtils.completeSnapshot((Path)snapshotDir, (Path)workingDir, (FileSystem)fs, (FileSystem)workingDir.getFileSystem(conf), (Configuration)conf);
            Assert.fail((String)"Shouldn't successfully complete move of a non-existent directory.");
        }
        catch (IOException e) {
            LOG.info((Object)"Correctly failed to move non-existant directory: ", (Throwable)e);
        }
    }

    @Test
    public void testIsSubDirectoryWorks() {
        Path rootDir = new Path("hdfs://root/.hbase-snapshot/");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)rootDir, (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshotdir"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://.hbase-snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://.hbase-snapshot/.tmp"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root"), (Path)rootDir));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot/.tmp"), (Path)rootDir));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot/.tmp/snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root/.hbase-snapshot/"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root/.hbase-snapshot/.tmp/snapshot"), (Path)rootDir));
    }

    @Test
    public void testIsWithinWorkingDir() throws IOException {
        Configuration conf = new Configuration();
        FSUtils.setRootDir((Configuration)conf, (Path)root);
        Path rootDir = root.makeQualified(fs);
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)rootDir, (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path(rootDir, ".hbase-snapshotdir"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path(rootDir, ".hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://.hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://.hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://root"), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path(rootDir, ".hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path(rootDir, ".hbase-snapshot/.tmp/snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://root/.hbase-snapshot/"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://root"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://root/.hbase-snapshot/.tmp/snapshot"), (Configuration)conf));
    }

    @Test
    public void testShouldSkipRenameSnapshotDirectories() {
        URI workingDirURI = URI.create("/User/test1");
        URI rootDirURI = URI.create("hdfs:///User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("/User/test1");
        rootDirURI = URI.create("file:///User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://otherhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("file:///User/test1");
        rootDirURI = URI.create("hdfs://localhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs:///User/test1");
        rootDirURI = URI.create("hdfs:///User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://localhost:8020/User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://user:password@localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://user:password@localhost:8020/User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://user:password@localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://user2:password2@localhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
    }

    static {
        LOG = LogFactory.getLog(TestSnapshotDescriptionUtils.class);
    }
}

