/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TestSnapshotClientRetries;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSnapshotWhenChoreCleaning {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration CONF = TEST_UTIL.getConfiguration();
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotClientRetries.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testTable");
    private static final int MAX_SPLIT_KEYS_NUM = 100;
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static Table TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        CONF.setInt("hbase.snapshot.thread.pool.max", 1);
        CONF.setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.startMiniCluster(3);
        TestSnapshotWhenChoreCleaning.createTable();
    }

    private static byte[] integerToBytes(int i) {
        return Bytes.toBytes((String)String.format("%06d", i));
    }

    private static void createTable() throws IOException {
        byte[][] splitKeys = new byte[100][];
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = TestSnapshotWhenChoreCleaning.integerToBytes(i);
        }
        TABLE = TEST_UTIL.createTable(TABLE_NAME, FAMILY, (byte[][])splitKeys);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void loadDataAndFlush() throws IOException {
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(TestSnapshotWhenChoreCleaning.integerToBytes(i)).addColumn(FAMILY, QUALIFIER, Bytes.add((byte[])VALUE, (byte[])Bytes.toBytes((int)i)));
            TABLE.put(put);
        }
        TEST_UTIL.flush(TABLE_NAME);
    }

    private static List<Path> listHFileNames(FileSystem fs, final Path tableDir) throws IOException {
        final ArrayList<Path> hfiles = new ArrayList<Path>();
        FSVisitor.visitTableStoreFiles((FileSystem)fs, (Path)tableDir, (FSVisitor.StoreFileVisitor)new FSVisitor.StoreFileVisitor(){

            public void storeFile(String region, String family, String hfileName) throws IOException {
                hfiles.add(new Path(new Path(new Path(tableDir, region), family), hfileName));
            }
        });
        Collections.sort(hfiles);
        return hfiles;
    }

    private static boolean isAnySnapshots(FileSystem fs) throws IOException {
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)FSUtils.getRootDir((Configuration)CONF));
        FileStatus[] snapFiles = fs.listStatus(snapshotDir);
        if (snapFiles.length == 0) {
            return false;
        }
        Path firstPath = snapFiles[0].getPath();
        LOG.info("firstPath in isAnySnapshots: " + firstPath);
        if (snapFiles.length == 1 && firstPath.getName().equals(".tmp")) {
            FileStatus[] tmpSnapFiles = fs.listStatus(firstPath);
            return tmpSnapFiles != null && tmpSnapFiles.length > 0;
        }
        return true;
    }

    @Test
    public void testSnapshotWhenSnapshotHFileCleanerRunning() throws Exception {
        TestSnapshotWhenChoreCleaning.loadDataAndFlush();
        final SnapshotHFileCleaner cleaner = new SnapshotHFileCleaner();
        HashMap<String, HMaster> params = new HashMap<String, HMaster>();
        params.put("master", TEST_UTIL.getHBaseCluster().getMaster());
        cleaner.init(params);
        cleaner.setConf(CONF);
        final FileSystem fs = FSUtils.getCurrentFileSystem((Configuration)CONF);
        List<Path> fileNames = TestSnapshotWhenChoreCleaning.listHFileNames(fs, FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)CONF), (TableName)TABLE_NAME));
        final ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        for (Path fileName : fileNames) {
            files.add(fs.getFileStatus(fileName));
        }
        TEST_UTIL.getHBaseAdmin().snapshot("snapshotName_prev", TABLE_NAME);
        Assert.assertEquals((long)Lists.newArrayList((Iterable)cleaner.getDeletableFiles(files)).size(), (long)0L);
        TEST_UTIL.getHBaseAdmin().deleteSnapshot("snapshotName_prev");
        cleaner.getFileCacheForTesting().triggerCacheRefreshForTesting();
        Assert.assertEquals((long)Lists.newArrayList((Iterable)cleaner.getDeletableFiles(files)).size(), (long)100L);
        Runnable snapshotRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (int k = 0; k < 5; ++k) {
                        TEST_UTIL.getHBaseAdmin().snapshot("snapshotName_" + k, TABLE_NAME);
                    }
                }
                catch (Exception e) {
                    LOG.error("Snapshot failed: ", (Throwable)e);
                }
            }
        };
        final AtomicBoolean success = new AtomicBoolean(true);
        Runnable cleanerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TestSnapshotWhenChoreCleaning.isAnySnapshots(fs)) {
                        LOG.info("Not found any snapshot, sleep 100ms");
                        Thread.sleep(100L);
                    }
                    for (int k = 0; k < 5; ++k) {
                        cleaner.getFileCacheForTesting().triggerCacheRefreshForTesting();
                        Iterable toDeleteFiles = cleaner.getDeletableFiles((Iterable)files);
                        ArrayList deletableFiles = Lists.newArrayList((Iterable)toDeleteFiles);
                        LOG.info("Size of deletableFiles is: " + deletableFiles.size());
                        for (int i = 0; i < deletableFiles.size(); ++i) {
                            LOG.debug("toDeleteFiles[{}] is: {}", (Object)i, deletableFiles.get(i));
                        }
                        if (deletableFiles.size() <= 0) continue;
                        success.set(false);
                    }
                }
                catch (Exception e) {
                    LOG.error("Chore cleaning failed: ", (Throwable)e);
                }
            }
        };
        Thread t1 = new Thread(snapshotRunnable);
        t1.start();
        Thread t2 = new Thread(cleanerRunnable);
        t2.start();
        t1.join();
        t2.join();
        Assert.assertTrue((boolean)success.get());
    }
}

