/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class ConstantDelayQueue<E>
implements BlockingQueue<E> {
    private final long delayMs;
    private DelayQueue<DelayedElement<E>> queue = new DelayQueue();

    public ConstantDelayQueue(TimeUnit timeUnit, long delay) {
        this.delayMs = TimeUnit.MILLISECONDS.convert(delay, timeUnit);
    }

    @Override
    public E remove() {
        DelayedElement el = (DelayedElement)this.queue.remove();
        return el == null ? null : (E)el.element;
    }

    @Override
    public E poll() {
        DelayedElement el = (DelayedElement)this.queue.poll();
        return el == null ? null : (E)el.element;
    }

    @Override
    public E element() {
        DelayedElement el = (DelayedElement)this.queue.element();
        return el == null ? null : (E)el.element;
    }

    @Override
    public E peek() {
        DelayedElement el = (DelayedElement)this.queue.peek();
        return el == null ? null : (E)el.element;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean add(E e) {
        return this.queue.add(new DelayedElement<E>(e, this.delayMs));
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offer(new DelayedElement<E>(e, this.delayMs));
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.queue.put(new DelayedElement<E>(e, this.delayMs));
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(new DelayedElement<E>(e, this.delayMs), timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        DelayedElement el = (DelayedElement)this.queue.take();
        return el == null ? null : (E)el.element;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        DelayedElement el = (DelayedElement)this.queue.poll(timeout, unit);
        return el == null ? null : (E)el.element;
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    private static final class DelayedElement<T>
    implements Delayed {
        T element;
        long end;

        public DelayedElement(T element, long delayMs) {
            this.element = element;
            this.end = EnvironmentEdgeManager.currentTime() + delayMs;
        }

        @Override
        public int compareTo(Delayed o) {
            long cmp = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
            return cmp == 0L ? 0 : (cmp < 0L ? -1 : 1);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

