/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.master.HMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionsRecoveryChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsRecoveryChore.class);
    private static final String REGIONS_RECOVERY_CHORE_NAME = "RegionsRecoveryChore";
    private static final String ERROR_REOPEN_REIONS_MSG = "Error reopening regions with high storeRefCount. ";
    private final HMaster hMaster;
    private final int storeFileRefCountThreshold;
    private static final PerClientRandomNonceGenerator NONCE_GENERATOR = new PerClientRandomNonceGenerator();

    RegionsRecoveryChore(Stoppable stopper, Configuration configuration, HMaster hMaster) {
        super(REGIONS_RECOVERY_CHORE_NAME, stopper, configuration.getInt("hbase.master.regions.recovery.check.interval", 1200000));
        this.hMaster = hMaster;
        this.storeFileRefCountThreshold = configuration.getInt("hbase.regions.recovery.store.file.ref.count", -1);
    }

    protected void chore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting up Regions Recovery chore for reopening regions based on storeFileRefCount...");
        }
        try {
            if (this.storeFileRefCountThreshold > 0) {
                ClusterStatus clusterStatus = this.hMaster.getClusterStatus();
                Map serverMetricsMap = clusterStatus.getLiveServersLoad();
                Map<TableName, List<HRegionInfo>> tableToReopenRegionsMap = this.getTableToRegionsByRefCount(serverMetricsMap);
                if (MapUtils.isNotEmpty(tableToReopenRegionsMap)) {
                    for (Map.Entry<TableName, List<HRegionInfo>> tableRegionEntry : tableToReopenRegionsMap.entrySet()) {
                        TableName tableName = tableRegionEntry.getKey();
                        List<HRegionInfo> hRegionInfos = tableRegionEntry.getValue();
                        try {
                            LOG.warn("Reopening regions due to high storeFileRefCount. TableName: {} , noOfRegions: {}", (Object)tableName, (Object)hRegionInfos.size());
                            this.hMaster.reopenRegions(tableName, hRegionInfos, NONCE_GENERATOR.getNonceGroup(), NONCE_GENERATOR.newNonce());
                        }
                        catch (IOException e) {
                            ArrayList<String> regionNames = new ArrayList<String>();
                            for (HRegionInfo hRegionInfo : hRegionInfos) {
                                regionNames.add(hRegionInfo.getRegionNameAsString());
                            }
                            LOG.error("{} tableName: {}, regionNames: {}", new Object[]{ERROR_REOPEN_REIONS_MSG, tableName, regionNames, e});
                        }
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Reopening regions with very high storeFileRefCount is disabled. Provide threshold value > 0 for {} to enable it.", (Object)"hbase.regions.recovery.store.file.ref.count");
            }
        }
        catch (Exception e) {
            LOG.error("Error while reopening regions based on storeRefCount threshold", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exiting Regions Recovery chore for reopening regions based on storeFileRefCount...");
        }
    }

    private Map<TableName, List<HRegionInfo>> getTableToRegionsByRefCount(Map<ServerName, ServerLoad> serverMetricsMap) {
        HashMap<TableName, List<HRegionInfo>> tableToReopenRegionsMap = new HashMap<TableName, List<HRegionInfo>>();
        for (ServerLoad serverLoad : serverMetricsMap.values()) {
            Map regionLoadsMap = serverLoad.getRegionsLoad();
            for (RegionLoad regionLoad : regionLoadsMap.values()) {
                int maxCompactedStoreFileRefCount = regionLoad.getMaxCompactedStoreFileRefCount();
                if (maxCompactedStoreFileRefCount <= this.storeFileRefCountThreshold) continue;
                byte[] regionName = regionLoad.getName();
                this.prepareTableToReopenRegionsMap(tableToReopenRegionsMap, regionName, maxCompactedStoreFileRefCount);
            }
        }
        return tableToReopenRegionsMap;
    }

    private void prepareTableToReopenRegionsMap(Map<TableName, List<HRegionInfo>> tableToReopenRegionsMap, byte[] regionName, int regionStoreRefCount) {
        HRegionInfo hRegionInfo = this.hMaster.getAssignmentManager().getRegionInfo(regionName);
        TableName tableName = hRegionInfo.getTable();
        if (TableName.META_TABLE_NAME.equals((Object)tableName)) {
            return;
        }
        LOG.warn("Region {} for Table {} has high storeFileRefCount {}, considering it for reopen..", new Object[]{hRegionInfo.getRegionNameAsString(), tableName, regionStoreRefCount});
        if (!tableToReopenRegionsMap.containsKey(tableName)) {
            tableToReopenRegionsMap.put(tableName, new ArrayList());
        }
        tableToReopenRegionsMap.get(tableName).add(hRegionInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && ((Object)((Object)this)).getClass() == o.getClass();
    }

    public int hashCode() {
        return 31;
    }
}

