/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;

public class ServerRegionReplicaUtil
extends RegionReplicaUtil {
    public static final String REGION_REPLICA_REPLICATION_CONF_KEY = "hbase.region.replica.replication.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION = false;
    private static final String REGION_REPLICA_REPLICATION_PEER = "region_replica_replication";
    public static final String REGION_REPLICA_STORE_FILE_REFRESH = "hbase.region.replica.storefile.refresh";
    private static final boolean DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH = true;
    public static final String REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = "hbase.region.replica.storefile.refresh.memstore.multiplier";
    private static final double DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = 4.0;

    public static HRegionInfo getRegionInfoForFs(HRegionInfo regionInfo) {
        if (regionInfo == null) {
            return null;
        }
        return RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)regionInfo);
    }

    public static boolean isReadOnly(HRegion region) {
        return region.getTableDesc().isReadOnly() || !ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static boolean shouldReplayRecoveredEdits(HRegion region) {
        return ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static StoreFileInfo getStoreFileInfo(Configuration conf, FileSystem fs, HRegionInfo regionInfo, HRegionInfo regionInfoForFs, String familyName, Path path) throws IOException {
        if (regionInfo.equals((Object)regionInfoForFs)) {
            return new StoreFileInfo(conf, fs, path);
        }
        if (HFileLink.isHFileLink(path) || StoreFileInfo.isHFile(path)) {
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), link);
        }
        if (StoreFileInfo.isReference(path)) {
            Reference reference = Reference.read(fs, path);
            Path referencePath = StoreFileInfo.getReferredToFile(path);
            if (HFileLink.isHFileLink(referencePath)) {
                HFileLink link = HFileLink.buildFromHFileLinkPattern(conf, referencePath);
                return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference, link);
            }
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference);
        }
        throw new IOException("path=" + path + " doesn't look like a valid StoreFile");
    }

    public static void setupRegionReplicaReplication(Configuration conf) throws IOException {
        if (!ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(conf)) {
            return;
        }
        try (ReplicationAdmin repAdmin = new ReplicationAdmin(conf);){
            if (repAdmin.getPeerConfig(REGION_REPLICA_REPLICATION_PEER) == null) {
                ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
                peerConfig.setClusterKey(ZKConfig.getZooKeeperClusterKey((Configuration)conf));
                peerConfig.setReplicationEndpointImpl(RegionReplicaReplicationEndpoint.class.getName());
                repAdmin.addPeer(REGION_REPLICA_REPLICATION_PEER, peerConfig, null);
            }
        }
    }

    public static boolean isRegionReplicaReplicationEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_REPLICATION_CONF_KEY, false);
    }

    public static boolean isRegionReplicaWaitForPrimaryFlushEnabled(Configuration conf) {
        return conf.getBoolean("hbase.region.replica.wait.for.primary.flush", true);
    }

    public static boolean isRegionReplicaStoreFileRefreshEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_STORE_FILE_REFRESH, true);
    }

    public static double getRegionReplicaStoreFileRefreshMultiplier(Configuration conf) {
        return conf.getDouble(REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER, 4.0);
    }

    public static String getReplicationPeerId() {
        return REGION_REPLICA_REPLICATION_PEER;
    }
}

