/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.backup.example.ZKTableArchiveClient;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
class HFileArchiveManager {
    private final String archiveZnode;
    private static final Log LOG = LogFactory.getLog(HFileArchiveManager.class);
    private final ZooKeeperWatcher zooKeeper;
    private volatile boolean stopped = false;

    public HFileArchiveManager(Connection connection, Configuration conf) throws ZooKeeperConnectionException, IOException {
        this.zooKeeper = new ZooKeeperWatcher(conf, "hfileArchiveManager-on-" + connection.toString(), (Abortable)connection);
        this.archiveZnode = ZKTableArchiveClient.getArchiveZNode(this.zooKeeper.getConfiguration(), this.zooKeeper);
    }

    public HFileArchiveManager enableHFileBackup(byte[] table) throws KeeperException {
        this.enable(this.zooKeeper, table);
        return this;
    }

    public HFileArchiveManager disableHFileBackup(byte[] table) throws KeeperException {
        this.disable(this.zooKeeper, table);
        return this;
    }

    public HFileArchiveManager disableHFileBackup() throws IOException {
        LOG.debug((Object)"Disabling backups on all tables.");
        try {
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.zooKeeper, (String)this.archiveZnode);
            return this;
        }
        catch (KeeperException e) {
            throw new IOException("Unexpected ZK exception!", e);
        }
    }

    private void enable(ZooKeeperWatcher zooKeeper, byte[] table) throws KeeperException {
        LOG.debug((Object)"Ensuring archiving znode exists");
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zooKeeper, (String)this.archiveZnode);
        String tableNode = this.getTableNode(table);
        LOG.debug((Object)("Creating: " + tableNode + ", data: []"));
        ZKUtil.createSetData((ZooKeeperWatcher)zooKeeper, (String)tableNode, (byte[])new byte[0]);
    }

    private void disable(ZooKeeperWatcher zooKeeper, byte[] table) throws KeeperException {
        zooKeeper.sync(this.archiveZnode);
        if (ZKUtil.checkExists((ZooKeeperWatcher)zooKeeper, (String)this.archiveZnode) < 0) {
            return;
        }
        String tableNode = this.getTableNode(table);
        zooKeeper.sync(tableNode);
        LOG.debug((Object)("Attempting to delete table node:" + tableNode));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zooKeeper, (String)tableNode);
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            LOG.debug((Object)"Stopping HFileArchiveManager...");
            this.zooKeeper.close();
        }
    }

    public boolean isArchivingEnabled(byte[] table) throws KeeperException {
        String tableNode = this.getTableNode(table);
        return ZKUtil.checkExists((ZooKeeperWatcher)this.zooKeeper, (String)tableNode) >= 0;
    }

    private String getTableNode(byte[] table) {
        return ZKUtil.joinZNode((String)this.archiveZnode, (String)Bytes.toString((byte[])table));
    }
}

