/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hadoop.hbase.constraint.ConstraintProcessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Constraints {
    private static final int DEFAULT_PRIORITY = -1;
    private static final Log LOG = LogFactory.getLog(Constraints.class);
    private static final String CONSTRAINT_HTD_KEY_PREFIX = "constraint $";
    private static final Pattern CONSTRAINT_HTD_ATTR_KEY_PATTERN = Pattern.compile("constraint $", 16);
    private static final String ENABLED_KEY = "_ENABLED";
    private static final String PRIORITY_KEY = "_PRIORITY";
    private static final long MIN_PRIORITY = 0L;
    private static final long UNSET_PRIORITY = -1L;
    private static String COUNTER_KEY = "hbase.constraint.counter";
    private static final Comparator<Constraint> constraintComparator = new Comparator<Constraint>(){

        @Override
        public int compare(Constraint c1, Constraint c2) {
            return Long.compare(c1.getConf().getLong(Constraints.PRIORITY_KEY, -1L), c2.getConf().getLong(Constraints.PRIORITY_KEY, -1L));
        }
    };

    private Constraints() {
    }

    public static void enable(HTableDescriptor desc) throws IOException {
        String clazz = ConstraintProcessor.class.getName();
        if (desc.hasCoprocessor(clazz)) {
            return;
        }
        desc.addCoprocessor(clazz);
    }

    public static void disable(HTableDescriptor desc) {
        desc.removeCoprocessor(ConstraintProcessor.class.getName());
    }

    public static void remove(HTableDescriptor desc) {
        Constraints.disable(desc);
        ArrayList keys = new ArrayList();
        for (Map.Entry e : desc.getValues().entrySet()) {
            String key = Bytes.toString((byte[])((Bytes)e.getKey()).get());
            String[] className = CONSTRAINT_HTD_ATTR_KEY_PATTERN.split(key);
            if (className.length != 2) continue;
            keys.add(e.getKey());
        }
        for (Bytes key : keys) {
            desc.remove(key);
        }
    }

    public static boolean has(HTableDescriptor desc, Class<? extends Constraint> clazz) {
        return Constraints.getKeyValueForClass(desc, clazz) != null;
    }

    private static Pair<String, String> getKeyValueForClass(HTableDescriptor desc, Class<? extends Constraint> clazz) {
        String key = Constraints.serializeConstraintClass(clazz);
        String value = desc.getValue(key);
        return value == null ? null : new Pair((Object)key, (Object)value);
    }

    public static void add(HTableDescriptor desc, Class<? extends Constraint> ... constraints) throws IOException {
        Constraints.enable(desc);
        long priority = Constraints.getNextPriority(desc);
        for (Class<? extends Constraint> clazz : constraints) {
            Constraints.addConstraint(desc, clazz, null, priority++);
        }
        Constraints.updateLatestPriority(desc, priority);
    }

    public static void add(HTableDescriptor desc, Pair<Class<? extends Constraint>, Configuration> ... constraints) throws IOException {
        Constraints.enable(desc);
        long priority = Constraints.getNextPriority(desc);
        for (Pair<Class<? extends Constraint>, Configuration> pair : constraints) {
            Constraints.addConstraint(desc, (Class)pair.getFirst(), (Configuration)pair.getSecond(), priority++);
        }
        Constraints.updateLatestPriority(desc, priority);
    }

    public static void add(HTableDescriptor desc, Class<? extends Constraint> constraint, Configuration conf) throws IOException {
        Constraints.enable(desc);
        long priority = Constraints.getNextPriority(desc);
        Constraints.addConstraint(desc, constraint, conf, priority++);
        Constraints.updateLatestPriority(desc, priority);
    }

    private static void addConstraint(HTableDescriptor desc, Class<? extends Constraint> clazz, Configuration conf, long priority) throws IOException {
        Constraints.writeConstraint(desc, Constraints.serializeConstraintClass(clazz), Constraints.configure(conf, true, priority));
    }

    private static Configuration configure(Configuration conf, boolean enabled, long priority) {
        Configuration toWrite = conf == null ? new Configuration() : new Configuration(conf);
        toWrite.setBooleanIfUnset(ENABLED_KEY, enabled);
        if (toWrite.getLong(PRIORITY_KEY, -1L) == -1L) {
            toWrite.setLong(PRIORITY_KEY, priority);
        }
        return toWrite;
    }

    private static String serializeConstraintClass(Class<? extends Constraint> clazz) {
        String constraintClazz = clazz.getName();
        return CONSTRAINT_HTD_KEY_PREFIX + constraintClazz;
    }

    private static void writeConstraint(HTableDescriptor desc, String key, Configuration conf) throws IOException {
        desc.setValue(key, Constraints.serializeConfiguration(conf));
    }

    private static String serializeConfiguration(Configuration conf) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        conf.writeXml((OutputStream)dos);
        dos.flush();
        byte[] data = bos.toByteArray();
        return Bytes.toString((byte[])data);
    }

    private static Configuration readConfiguration(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)is);
        return conf;
    }

    private static Configuration readConfiguration(String bytes) throws IOException {
        return Constraints.readConfiguration(Bytes.toBytes((String)bytes));
    }

    private static long getNextPriority(HTableDescriptor desc) {
        String value = desc.getValue(COUNTER_KEY);
        long priority = value == null ? 0L : Long.parseLong(value) + 1L;
        return priority;
    }

    private static void updateLatestPriority(HTableDescriptor desc, long priority) {
        desc.setValue(COUNTER_KEY, Long.toString(priority));
    }

    public static void setConfiguration(HTableDescriptor desc, Class<? extends Constraint> clazz, Configuration configuration) throws IOException, IllegalArgumentException {
        Pair<String, String> e = Constraints.getKeyValueForClass(desc, clazz);
        if (e == null) {
            throw new IllegalArgumentException("Constraint: " + clazz.getName() + " is not associated with this table.");
        }
        Configuration conf = new Configuration(configuration);
        Configuration internal = Constraints.readConfiguration((String)e.getSecond());
        conf.setIfUnset(ENABLED_KEY, internal.get(ENABLED_KEY));
        conf.setIfUnset(PRIORITY_KEY, internal.get(PRIORITY_KEY));
        Constraints.writeConstraint(desc, (String)e.getFirst(), conf);
    }

    public static void remove(HTableDescriptor desc, Class<? extends Constraint> clazz) {
        String key = Constraints.serializeConstraintClass(clazz);
        desc.remove(key);
    }

    public static void enableConstraint(HTableDescriptor desc, Class<? extends Constraint> clazz) throws IOException {
        Constraints.changeConstraintEnabled(desc, clazz, true);
    }

    public static void disableConstraint(HTableDescriptor desc, Class<? extends Constraint> clazz) throws IOException {
        Constraints.changeConstraintEnabled(desc, clazz, false);
    }

    private static void changeConstraintEnabled(HTableDescriptor desc, Class<? extends Constraint> clazz, boolean enabled) throws IOException {
        Pair<String, String> entry = Constraints.getKeyValueForClass(desc, clazz);
        if (entry == null) {
            throw new IllegalArgumentException("Constraint: " + clazz.getName() + " is not associated with this table. You can't enable it!");
        }
        Configuration conf = Constraints.readConfiguration((String)entry.getSecond());
        conf.setBoolean(ENABLED_KEY, enabled);
        Constraints.writeConstraint(desc, (String)entry.getFirst(), conf);
    }

    public static boolean enabled(HTableDescriptor desc, Class<? extends Constraint> clazz) throws IOException {
        Pair<String, String> entry = Constraints.getKeyValueForClass(desc, clazz);
        if (entry == null) {
            return false;
        }
        Configuration conf = Constraints.readConfiguration((String)entry.getSecond());
        return conf.getBoolean(ENABLED_KEY, false);
    }

    static List<? extends Constraint> getConstraints(TableDescriptor desc, ClassLoader classloader) throws IOException {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Map.Entry e : desc.getValues().entrySet()) {
            Configuration conf;
            String key = Bytes.toString((byte[])((Bytes)e.getKey()).get()).trim();
            String[] className = CONSTRAINT_HTD_ATTR_KEY_PATTERN.split(key);
            if (className.length != 2) continue;
            key = className[1];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading constraint:" + key));
            }
            try {
                conf = Constraints.readConfiguration(((Bytes)e.getValue()).get());
            }
            catch (IOException e1) {
                LOG.warn((Object)("Corrupted configuration found for key:" + key + ",  skipping it."));
                continue;
            }
            if (!conf.getBoolean(ENABLED_KEY, false)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Constraint: " + key + " is DISABLED - skipping it"));
                continue;
            }
            try {
                Class<Constraint> clazz = classloader.loadClass(key).asSubclass(Constraint.class);
                Constraint constraint = clazz.newInstance();
                constraint.setConf(conf);
                constraints.add(constraint);
            }
            catch (ClassNotFoundException e1) {
                throw new IOException(e1);
            }
            catch (InstantiationException e1) {
                throw new IOException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new IOException(e1);
            }
        }
        Collections.sort(constraints, constraintComparator);
        return constraints;
    }
}

