/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZKNamespaceManager;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.master.ClusterSchema;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="TODO: synchronize access on nsTable but it is done in tiers above and this class is going away/shrinking")
public class TableNamespaceManager {
    private static final Log LOG = LogFactory.getLog(TableNamespaceManager.class);
    private Configuration conf;
    private MasterServices masterServices;
    private Table nsTable = null;
    private ZKNamespaceManager zkNamespaceManager;
    private boolean initialized;
    public static final String KEY_MAX_REGIONS = "hbase.namespace.quota.maxregions";
    public static final String KEY_MAX_TABLES = "hbase.namespace.quota.maxtables";
    static final String NS_INIT_TIMEOUT = "hbase.master.namespace.init.timeout";
    static final int DEFAULT_NS_INIT_TIMEOUT = 300000;

    TableNamespaceManager(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.conf = masterServices.getConfiguration();
    }

    public void start() throws IOException {
        if (!MetaTableAccessor.tableExists((Connection)this.masterServices.getConnection(), (TableName)TableName.NAMESPACE_TABLE_NAME)) {
            LOG.info((Object)"Namespace table not found. Creating...");
            this.createNamespaceTable(this.masterServices);
        }
        try {
            long startTime = EnvironmentEdgeManager.currentTime();
            int timeout = this.conf.getInt(NS_INIT_TIMEOUT, 300000);
            while (!this.isTableAvailableAndInitialized()) {
                if (EnvironmentEdgeManager.currentTime() - startTime + 100L > (long)timeout) {
                    throw new IOException("Timedout " + timeout + "ms waiting for namespace table to be assigned and enabled: " + this.getTableState());
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    private synchronized Table getNamespaceTable() throws IOException {
        if (!this.isTableNamespaceManagerInitialized()) {
            throw new IOException(this.getClass().getName() + " isn't ready to serve");
        }
        return this.nsTable;
    }

    public boolean doesNamespaceExist(String namespaceName) throws IOException {
        if (this.nsTable == null) {
            throw new IOException(this.getClass().getName() + " isn't ready to serve");
        }
        return this.get(this.nsTable, namespaceName) != null;
    }

    public synchronized NamespaceDescriptor get(String name) throws IOException {
        if (!this.isTableNamespaceManagerInitialized()) {
            return null;
        }
        return this.zkNamespaceManager.get(name);
    }

    private NamespaceDescriptor get(Table table, String name) throws IOException {
        Result res = table.get(new Get(Bytes.toBytes((String)name)));
        if (res.isEmpty()) {
            return null;
        }
        byte[] val = CellUtil.cloneValue((Cell)res.getColumnLatestCell(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES));
        return ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])val));
    }

    public void insertIntoNSTable(NamespaceDescriptor ns) throws IOException {
        if (this.nsTable == null) {
            throw new IOException(this.getClass().getName() + " isn't ready to serve");
        }
        Put p = new Put(Bytes.toBytes((String)ns.getName()));
        p.addImmutable(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES, ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns).toByteArray());
        this.nsTable.put(p);
    }

    public void updateZKNamespaceManager(NamespaceDescriptor ns) throws IOException {
        try {
            this.zkNamespaceManager.update(ns);
        }
        catch (IOException ex) {
            String msg = "Failed to update namespace information in ZK.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new IOException(msg, ex);
        }
    }

    public void removeFromNSTable(String namespaceName) throws IOException {
        if (this.nsTable == null) {
            throw new IOException(this.getClass().getName() + " isn't ready to serve");
        }
        Delete d = new Delete(Bytes.toBytes((String)namespaceName));
        this.nsTable.delete(d);
    }

    public void removeFromZKNamespaceManager(String namespaceName) throws IOException {
        this.zkNamespaceManager.remove(namespaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NavigableSet<NamespaceDescriptor> list() throws IOException {
        TreeSet ret = Sets.newTreeSet((Comparator)NamespaceDescriptor.NAMESPACE_DESCRIPTOR_COMPARATOR);
        try (ResultScanner scanner = this.getNamespaceTable().getScanner(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES);){
            for (Result r : scanner) {
                byte[] val = CellUtil.cloneValue((Cell)r.getColumnLatestCell(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES));
                ret.add(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])val)));
            }
        }
        return ret;
    }

    private void createNamespaceTable(MasterServices masterServices) throws IOException {
        masterServices.createSystemTable((TableDescriptor)HTableDescriptor.NAMESPACE_TABLEDESC);
    }

    private boolean isTableNamespaceManagerInitialized() throws IOException {
        if (this.initialized) {
            this.nsTable = this.masterServices.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);
            return true;
        }
        return false;
    }

    private void blockingCreateNamespace(NamespaceDescriptor namespaceDescriptor) throws IOException {
        ClusterSchema clusterSchema = this.masterServices.getClusterSchema();
        long procId = clusterSchema.createNamespace(namespaceDescriptor, null);
        TableNamespaceManager.block(this.masterServices, procId);
    }

    private static void block(MasterServices services, long procId) throws TimeoutIOException {
        int timeoutInMillis = services.getConfiguration().getInt("hbase.master.cluster.schema.operation.timeout", 300000);
        long deadlineTs = EnvironmentEdgeManager.currentTime() + (long)timeoutInMillis;
        ProcedureExecutor<MasterProcedureEnv> procedureExecutor = services.getMasterProcedureExecutor();
        while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
            if (procedureExecutor.isFinished(procId)) {
                return;
            }
            Threads.sleep((long)10L);
        }
        throw new TimeoutIOException("Procedure pid=" + procId + " is still running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isTableAvailableAndInitialized() throws IOException {
        if (this.isTableNamespaceManagerInitialized()) {
            return true;
        }
        if (this.isTableAssigned() && this.isTableEnabled()) {
            try {
                boolean initGoodSofar = true;
                this.nsTable = this.masterServices.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);
                this.zkNamespaceManager = new ZKNamespaceManager(this.masterServices.getZooKeeper());
                this.zkNamespaceManager.start();
                if (this.get(this.nsTable, NamespaceDescriptor.DEFAULT_NAMESPACE.getName()) == null) {
                    this.blockingCreateNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE);
                }
                if (this.get(this.nsTable, NamespaceDescriptor.SYSTEM_NAMESPACE.getName()) == null) {
                    this.blockingCreateNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE);
                }
                if (!initGoodSofar) {
                    return false;
                }
                try (ResultScanner scanner = this.nsTable.getScanner(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES);){
                    for (Result result : scanner) {
                        byte[] val = CellUtil.cloneValue((Cell)result.getColumnLatestCell(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES));
                        NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])val));
                        this.zkNamespaceManager.update(ns);
                    }
                }
                this.initialized = true;
                return true;
            }
            catch (IOException ie) {
                LOG.warn((Object)"Caught exception in initializing namespace table manager", (Throwable)ie);
                if (this.nsTable != null) {
                    this.nsTable.close();
                }
                throw ie;
            }
        }
        return false;
    }

    private TableState.State getTableState() throws IOException {
        return this.masterServices.getTableStateManager().getTableState(TableName.NAMESPACE_TABLE_NAME);
    }

    private boolean isTableEnabled() throws IOException {
        return this.getTableState().equals((Object)TableState.State.ENABLED);
    }

    private boolean isTableAssigned() {
        return this.masterServices.getAssignmentManager().getRegionStates().hasTableRegionStates(TableName.NAMESPACE_TABLE_NAME);
    }

    public void validateTableAndRegionCount(NamespaceDescriptor desc) throws IOException {
        if (TableNamespaceManager.getMaxRegions(desc) <= 0L) {
            throw new ConstraintException("The max region quota for " + desc.getName() + " is less than or equal to zero.");
        }
        if (TableNamespaceManager.getMaxTables(desc) <= 0L) {
            throw new ConstraintException("The max tables quota for " + desc.getName() + " is less than or equal to zero.");
        }
    }

    public static long getMaxTables(NamespaceDescriptor ns) throws IOException {
        String value = ns.getConfigurationValue(KEY_MAX_TABLES);
        long maxTables = 0L;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                maxTables = Long.parseLong(value);
            }
            catch (NumberFormatException exp) {
                throw new DoNotRetryIOException("NumberFormatException while getting max tables.", (Throwable)exp);
            }
        } else {
            maxTables = Long.MAX_VALUE;
        }
        return maxTables;
    }

    public static long getMaxRegions(NamespaceDescriptor ns) throws IOException {
        String value = ns.getConfigurationValue(KEY_MAX_REGIONS);
        long maxRegions = 0L;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                maxRegions = Long.parseLong(value);
            }
            catch (NumberFormatException exp) {
                throw new DoNotRetryIOException("NumberFormatException while getting max regions.", (Throwable)exp);
            }
        } else {
            maxRegions = Long.MAX_VALUE;
        }
        return maxRegions;
    }
}

