/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;

public class ClusterLoadState {
    private final Map<ServerName, List<RegionInfo>> clusterState;
    private final NavigableMap<ServerAndLoad, List<RegionInfo>> serversByLoad;
    private boolean emptyRegionServerPresent = false;
    private int numRegions = 0;
    private int numServers = 0;

    public ClusterLoadState(Map<ServerName, List<RegionInfo>> clusterState) {
        this.numServers = clusterState.size();
        this.clusterState = clusterState;
        this.serversByLoad = new TreeMap<ServerAndLoad, List<RegionInfo>>();
        for (Map.Entry<ServerName, List<RegionInfo>> server : clusterState.entrySet()) {
            List<RegionInfo> regions = server.getValue();
            int sz = regions.size();
            if (sz == 0) {
                this.emptyRegionServerPresent = true;
            }
            this.numRegions += sz;
            this.serversByLoad.put(new ServerAndLoad(server.getKey(), sz), regions);
        }
    }

    Map<ServerName, List<RegionInfo>> getClusterState() {
        return this.clusterState;
    }

    NavigableMap<ServerAndLoad, List<RegionInfo>> getServersByLoad() {
        return this.serversByLoad;
    }

    boolean isEmptyRegionServerPresent() {
        return this.emptyRegionServerPresent;
    }

    int getNumRegions() {
        return this.numRegions;
    }

    int getNumServers() {
        return this.numServers;
    }

    float getLoadAverage() {
        return (float)this.numRegions / (float)this.numServers;
    }

    int getMaxLoad() {
        return ((ServerAndLoad)this.getServersByLoad().lastKey()).getLoad();
    }

    int getMinLoad() {
        return ((ServerAndLoad)this.getServersByLoad().firstKey()).getLoad();
    }
}

