/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ModifyNamespaceProcedure
extends AbstractStateMachineNamespaceProcedure<MasterProcedureProtos.ModifyNamespaceState> {
    private static final Log LOG = LogFactory.getLog(ModifyNamespaceProcedure.class);
    private NamespaceDescriptor oldNsDescriptor = null;
    private NamespaceDescriptor newNsDescriptor;
    private Boolean traceEnabled;

    public ModifyNamespaceProcedure() {
        this.traceEnabled = null;
    }

    public ModifyNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor newNsDescriptor) {
        super(env);
        this.newNsDescriptor = newNsDescriptor;
        this.traceEnabled = null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_NAMESPACE_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_UPDATE_NS_TABLE);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_NS_TABLE: {
                    this.insertIntoNSTable(env);
                    this.setNextState(MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_UPDATE_ZK);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_ZK: {
                    this.updateZKNamespaceManager(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-namespace", e);
            }
            LOG.warn((Object)("Retriable error trying to modify namespace=" + this.newNsDescriptor.getName() + " (in state=" + state + ")"), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws IOException {
        if (state == MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_PREPARE) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyNamespaceState state) {
        switch (state) {
            case MODIFY_NAMESPACE_PREPARE: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.ModifyNamespaceState getState(int stateId) {
        return MasterProcedureProtos.ModifyNamespaceState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyNamespaceState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyNamespaceState getInitialState() {
        return MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyNamespaceStateData.Builder modifyNamespaceMsg = MasterProcedureProtos.ModifyNamespaceStateData.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.newNsDescriptor));
        if (this.oldNsDescriptor != null) {
            modifyNamespaceMsg.setUnmodifiedNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.oldNsDescriptor));
        }
        serializer.serialize((Message)modifyNamespaceMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyNamespaceStateData modifyNamespaceMsg = (MasterProcedureProtos.ModifyNamespaceStateData)serializer.deserialize(MasterProcedureProtos.ModifyNamespaceStateData.class);
        this.newNsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)modifyNamespaceMsg.getNamespaceDescriptor());
        if (modifyNamespaceMsg.hasUnmodifiedNamespaceDescriptor()) {
            this.oldNsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)modifyNamespaceMsg.getUnmodifiedNamespaceDescriptor());
        }
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    protected String getNamespaceName() {
        return this.newNsDescriptor.getName();
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        if (!this.getTableNamespaceManager(env).doesNamespaceExist(this.newNsDescriptor.getName())) {
            throw new NamespaceNotFoundException(this.newNsDescriptor.getName());
        }
        this.getTableNamespaceManager(env).validateTableAndRegionCount(this.newNsDescriptor);
        this.oldNsDescriptor = this.getTableNamespaceManager(env).get(this.newNsDescriptor.getName());
    }

    private void insertIntoNSTable(MasterProcedureEnv env) throws IOException {
        this.getTableNamespaceManager(env).insertIntoNSTable(this.newNsDescriptor);
    }

    private void updateZKNamespaceManager(MasterProcedureEnv env) throws IOException {
        this.getTableNamespaceManager(env).updateZKNamespaceManager(this.newNsDescriptor);
    }

    private TableNamespaceManager getTableNamespaceManager(MasterProcedureEnv env) {
        return env.getMasterServices().getClusterSchema().getTableNamespaceManager();
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }
}

