/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AnnotationReadingPriorityFunction
implements PriorityFunction {
    private static final Log LOG = LogFactory.getLog((String)AnnotationReadingPriorityFunction.class.getName());
    public static final String SCAN_VTIME_WEIGHT_CONF_KEY = "hbase.ipc.server.scan.vtime.weight";
    protected final Map<String, Integer> annotatedQos;
    private RSRpcServices rpcServices;
    private final Class<? extends Message>[] knownArgumentClasses = new Class[]{AdminProtos.GetRegionInfoRequest.class, AdminProtos.GetStoreFileRequest.class, AdminProtos.CloseRegionRequest.class, AdminProtos.FlushRegionRequest.class, AdminProtos.CompactRegionRequest.class, ClientProtos.GetRequest.class, ClientProtos.MutateRequest.class, ClientProtos.ScanRequest.class};
    private final Map<String, Class<? extends Message>> argumentToClassMap = new HashMap<String, Class<? extends Message>>();
    private final Map<String, Map<Class<? extends Message>, Method>> methodMap = new HashMap<String, Map<Class<? extends Message>, Method>>();
    private final float scanVirtualTimeWeight;

    public AnnotationReadingPriorityFunction(RSRpcServices rpcServices) {
        this(rpcServices, rpcServices.getClass());
    }

    public AnnotationReadingPriorityFunction(RSRpcServices rpcServices, Class<? extends RSRpcServices> clz) {
        HashMap<String, Integer> qosMap = new HashMap<String, Integer>();
        for (Method method : clz.getMethods()) {
            QosPriority p = method.getAnnotation(QosPriority.class);
            if (p == null) continue;
            String capitalizedMethodName = this.capitalize(method.getName());
            qosMap.put(capitalizedMethodName, p.priority());
        }
        this.rpcServices = rpcServices;
        this.annotatedQos = qosMap;
        if (this.methodMap.get("getRegion") == null) {
            this.methodMap.put("hasRegion", new HashMap());
            this.methodMap.put("getRegion", new HashMap());
        }
        for (GenericDeclaration genericDeclaration : this.knownArgumentClasses) {
            this.argumentToClassMap.put(((Class)genericDeclaration).getName(), (Class<? extends Message>)genericDeclaration);
            try {
                this.methodMap.get("hasRegion").put((Class<? extends Message>)genericDeclaration, ((Class)genericDeclaration).getDeclaredMethod("hasRegion", new Class[0]));
                this.methodMap.get("getRegion").put((Class<? extends Message>)genericDeclaration, ((Class)genericDeclaration).getDeclaredMethod("getRegion", new Class[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Configuration conf = rpcServices.getConfiguration();
        this.scanVirtualTimeWeight = conf.getFloat(SCAN_VTIME_WEIGHT_CONF_KEY, 1.0f);
    }

    private String capitalize(String s) {
        StringBuilder strBuilder = new StringBuilder(s);
        strBuilder.setCharAt(0, Character.toUpperCase(strBuilder.charAt(0)));
        return strBuilder.toString();
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        int priorityByAnnotation = this.getAnnotatedPriority(header);
        if (priorityByAnnotation >= 0) {
            return priorityByAnnotation;
        }
        return this.getBasePriority(header, param);
    }

    protected int getAnnotatedPriority(RPCProtos.RequestHeader header) {
        String methodName = header.getMethodName();
        Integer priorityByAnnotation = this.annotatedQos.get(methodName);
        if (priorityByAnnotation != null) {
            return priorityByAnnotation;
        }
        return -1;
    }

    protected int getBasePriority(RPCProtos.RequestHeader header, Message param) {
        if (param == null) {
            return 0;
        }
        if (header.hasPriority()) {
            return header.getPriority();
        }
        String cls = param.getClass().getName();
        Class<? extends Message> rpcArgClass = this.argumentToClassMap.get(cls);
        HBaseProtos.RegionSpecifier regionSpecifier = null;
        try {
            Method getRegion;
            HRegion region;
            Method hasRegion = this.methodMap.get("hasRegion").get(rpcArgClass);
            if (hasRegion != null && ((Boolean)hasRegion.invoke((Object)param, (Object[])null)).booleanValue() && (region = this.rpcServices.getRegion(regionSpecifier = (HBaseProtos.RegionSpecifier)(getRegion = this.methodMap.get("getRegion").get(rpcArgClass)).invoke((Object)param, (Object[])null))).getRegionInfo().getTable().isSystemTable()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("High priority because region=" + region.getRegionInfo().getRegionNameAsString()));
                }
                return 200;
            }
        }
        catch (Exception ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Marking normal priority after getting exception=" + ex));
            }
            return 0;
        }
        if (param instanceof ClientProtos.ScanRequest) {
            ClientProtos.ScanRequest request = (ClientProtos.ScanRequest)param;
            if (!request.hasScannerId()) {
                return 0;
            }
            RegionScanner scanner = this.rpcServices.getScanner(request.getScannerId());
            if (scanner != null && scanner.getRegionInfo().getTable().isSystemTable()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("High priority scanner request " + TextFormat.shortDebugString((MessageOrBuilder)request)));
                }
                return 200;
            }
        }
        return 0;
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        if (param instanceof ClientProtos.ScanRequest) {
            ClientProtos.ScanRequest request = (ClientProtos.ScanRequest)param;
            if (!request.hasScannerId()) {
                return 0L;
            }
            long vtime = this.rpcServices.getScannerVirtualTime(request.getScannerId());
            return Math.round(Math.sqrt((float)vtime * this.scanVirtualTimeWeight));
        }
        return 0L;
    }

    @VisibleForTesting
    void setRegionServer(HRegionServer hrs) {
        this.rpcServices = hrs.getRSRpcServices();
    }
}

