/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CompactionPipeline;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CompactingMemStore
extends AbstractMemStore {
    public static final String COMPACTING_MEMSTORE_TYPE_KEY = "hbase.hregion.compacting.memstore.type";
    public static final String COMPACTING_MEMSTORE_TYPE_DEFAULT = String.valueOf(MemoryCompactionPolicy.BASIC);
    public static final String COMPACTING_MEMSTORE_INDEX_KEY = "hbase.hregion.compacting.memstore.index";
    public static final String COMPACTING_MEMSTORE_INDEX_DEFAULT = String.valueOf((Object)IndexType.ARRAY_MAP);
    public static final String IN_MEMORY_FLUSH_THRESHOLD_FACTOR_KEY = "hbase.memstore.inmemoryflush.threshold.factor";
    private static final double IN_MEMORY_FLUSH_THRESHOLD_FACTOR_DEFAULT = 0.25;
    private static final Log LOG = LogFactory.getLog(CompactingMemStore.class);
    private HStore store;
    private RegionServicesForStores regionServices;
    private CompactionPipeline pipeline;
    private MemStoreCompactor compactor;
    private long inmemoryFlushSize;
    private final AtomicBoolean inMemoryFlushInProgress = new AtomicBoolean(false);
    private boolean inWalReplay = false;
    @VisibleForTesting
    private final AtomicBoolean allowCompaction = new AtomicBoolean(true);
    private boolean compositeSnapshot = true;
    private IndexType indexType = IndexType.ARRAY_MAP;
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(AbstractMemStore.DEEP_OVERHEAD + (long)(7 * ClassSize.REFERENCE) + 8L + 2L + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + CompactionPipeline.DEEP_OVERHEAD + MemStoreCompactor.DEEP_OVERHEAD));

    public CompactingMemStore(Configuration conf, CellComparator c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
        super(conf, c);
        this.store = store;
        this.regionServices = regionServices;
        this.pipeline = new CompactionPipeline(this.getRegionServices());
        this.compactor = this.createMemStoreCompactor(compactionPolicy);
        this.initInmemoryFlushSize(conf);
        this.indexType = IndexType.valueOf(conf.get(COMPACTING_MEMSTORE_INDEX_KEY, COMPACTING_MEMSTORE_INDEX_DEFAULT));
    }

    @VisibleForTesting
    protected MemStoreCompactor createMemStoreCompactor(MemoryCompactionPolicy compactionPolicy) {
        return new MemStoreCompactor(this, compactionPolicy);
    }

    private void initInmemoryFlushSize(Configuration conf) {
        long memstoreFlushSize = this.getRegionServices().getMemStoreFlushSize();
        int numStores = this.getRegionServices().getNumStores();
        if (numStores <= 1) {
            numStores = 1;
        }
        this.inmemoryFlushSize = memstoreFlushSize / (long)numStores;
        double factor = conf.getDouble(IN_MEMORY_FLUSH_THRESHOLD_FACTOR_KEY, 0.25);
        this.inmemoryFlushSize = (long)((double)this.inmemoryFlushSize * factor);
        LOG.info((Object)("Setting in-memory flush size threshold to " + this.inmemoryFlushSize));
    }

    @Override
    public MemStoreSize size() {
        MemStoreSizing memstoreSizing = new MemStoreSizing();
        memstoreSizing.incMemStoreSize(this.active.keySize(), this.active.heapSize());
        for (Segment segment : this.pipeline.getSegments()) {
            memstoreSizing.incMemStoreSize(segment.keySize(), segment.heapSize());
        }
        return memstoreSizing;
    }

    @Override
    public long preFlushSeqIDEstimation() {
        if (this.compositeSnapshot) {
            return -1L;
        }
        Segment segment = this.getLastSegment();
        if (segment == null) {
            return -1L;
        }
        return segment.getMinSequenceId();
    }

    @Override
    public boolean isSloppy() {
        return true;
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("FLUSHING TO DISK: region " + this.getRegionServices().getRegionInfo().getRegionNameAsString() + "store: " + this.getFamilyName()));
            }
            this.stopCompaction();
            this.pushActiveToPipeline(this.active);
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (this.compositeSnapshot) {
                this.pushPipelineToSnapshot();
            } else {
                this.pushTailToSnapshot();
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot);
    }

    @Override
    public MemStoreSize getFlushableSize() {
        MemStoreSizing snapshotSizing = this.getSnapshotSizing();
        if (snapshotSizing.getDataSize() == 0L) {
            if (this.compositeSnapshot) {
                snapshotSizing = this.pipeline.getPipelineSizing();
                snapshotSizing.incMemStoreSize(this.active.keySize(), this.active.heapSize());
            } else {
                snapshotSizing = this.pipeline.getTailSizing();
            }
        }
        return snapshotSizing.getDataSize() > 0L ? snapshotSizing : new MemStoreSize(this.active.keySize(), this.active.heapSize());
    }

    @Override
    protected long keySize() {
        long k = this.active.keySize();
        for (Segment segment : this.pipeline.getSegments()) {
            k += segment.keySize();
        }
        return k;
    }

    @Override
    protected long heapSize() {
        long h = this.active.heapSize();
        for (Segment segment : this.pipeline.getSegments()) {
            h += segment.heapSize();
        }
        return h;
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWAL(boolean onlyIfGreater) {
        long minSequenceId = this.pipeline.getMinSequenceId();
        if (minSequenceId != Long.MAX_VALUE) {
            byte[] encodedRegionName = this.getRegionServices().getRegionInfo().getEncodedNameAsBytes();
            byte[] familyName = this.getFamilyNameInBytes();
            WAL WAL2 = this.getRegionServices().getWAL();
            if (WAL2 != null) {
                WAL2.updateStore(encodedRegionName, familyName, minSequenceId, onlyIfGreater);
            }
        }
    }

    @Override
    public void startReplayingFromWAL() {
        this.inWalReplay = true;
    }

    @Override
    public void stopReplayingFromWAL() {
        this.inWalReplay = false;
    }

    @Override
    @VisibleForTesting
    protected List<Segment> getSegments() {
        List<? extends Segment> pipelineList = this.pipeline.getSegments();
        ArrayList<Segment> list = new ArrayList<Segment>(pipelineList.size() + 2);
        list.add(this.active);
        list.addAll(pipelineList);
        list.addAll(this.snapshot.getAllSegments());
        return list;
    }

    public void setCompositeSnapshot(boolean useCompositeSnapshot) {
        this.compositeSnapshot = useCompositeSnapshot;
    }

    public boolean isCompositeSnapshot() {
        return this.compositeSnapshot;
    }

    public boolean swapCompactedSegments(VersionedSegmentsList versionedList, ImmutableSegment result, boolean merge) {
        return this.pipeline.swap(versionedList, result, !merge, true);
    }

    public void flattenOneSegment(long requesterVersion) {
        this.pipeline.flattenOneSegment(requesterVersion, this.indexType);
    }

    @VisibleForTesting
    public void setIndexType() {
        this.indexType = IndexType.valueOf(this.getConfiguration().get(COMPACTING_MEMSTORE_INDEX_KEY, COMPACTING_MEMSTORE_INDEX_DEFAULT));
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean hasImmutableSegments() {
        return !this.pipeline.isEmpty();
    }

    public VersionedSegmentsList getImmutableSegments() {
        return this.pipeline.getVersionedList();
    }

    public long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    public HStore getStore() {
        return this.store;
    }

    public String getFamilyName() {
        return Bytes.toString((byte[])this.getFamilyNameInBytes());
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        MutableSegment activeTmp = this.active;
        List<? extends Segment> pipelineList = this.pipeline.getSegments();
        List<Segment> snapshotList = this.snapshot.getAllSegments();
        long order = 1 + pipelineList.size() + snapshotList.size();
        List<KeyValueScanner> list = this.createList((int)order);
        order = CompactingMemStore.addToScanners(activeTmp, readPt, order, list);
        order = CompactingMemStore.addToScanners(pipelineList, readPt, order, list);
        CompactingMemStore.addToScanners(snapshotList, readPt, order, list);
        return list;
    }

    @VisibleForTesting
    protected List<KeyValueScanner> createList(int capacity) {
        return new ArrayList<KeyValueScanner>(capacity);
    }

    @Override
    protected void checkActiveSize() {
        if (this.shouldFlushInMemory()) {
            InMemoryFlushRunnable runnable = new InMemoryFlushRunnable();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Dispatching the MemStore in-memory flush for store " + this.store.getColumnFamilyName()));
            }
            this.getPool().execute(runnable);
        }
    }

    @VisibleForTesting
    void flushInMemory() throws IOException {
        this.inMemoryFlushInProgress.set(true);
        try {
            this.getRegionServices().blockUpdates();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IN-MEMORY FLUSH: Pushing active segment into compaction pipeline");
                }
                this.pushActiveToPipeline(this.active);
            }
            finally {
                this.getRegionServices().unblockUpdates();
            }
            if (!this.allowCompaction.get()) {
                return;
            }
            try {
                this.compactor.start();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to run memstore compaction. region " + this.getRegionServices().getRegionInfo().getRegionNameAsString() + "store: " + this.getFamilyName()), (Throwable)e);
            }
        }
        finally {
            this.inMemoryFlushInProgress.set(false);
        }
    }

    private Segment getLastSegment() {
        MutableSegment localActive = this.getActive();
        Segment tail = this.pipeline.getTail();
        return tail == null ? localActive : tail;
    }

    private byte[] getFamilyNameInBytes() {
        return this.store.getColumnFamilyDescriptor().getName();
    }

    private ThreadPoolExecutor getPool() {
        return this.getRegionServices().getInMemoryCompactionPool();
    }

    @VisibleForTesting
    protected boolean shouldFlushInMemory() {
        if (this.active.keySize() > this.inmemoryFlushSize) {
            if (this.inWalReplay) {
                return false;
            }
            return this.inMemoryFlushInProgress.compareAndSet(false, true);
        }
        return false;
    }

    private void stopCompaction() {
        if (this.inMemoryFlushInProgress.get()) {
            this.compactor.stop();
        }
    }

    protected void pushActiveToPipeline(MutableSegment active) {
        if (!active.isEmpty()) {
            this.pipeline.pushHead(active);
            this.resetActive();
        }
    }

    private void pushTailToSnapshot() {
        VersionedSegmentsList segments = this.pipeline.getVersionedTail();
        this.pushToSnapshot(segments.getStoreSegments());
        this.pipeline.swap(segments, null, false, false);
    }

    private void pushPipelineToSnapshot() {
        int iterationsCnt = 0;
        boolean done = false;
        while (!done) {
            VersionedSegmentsList segments = this.pipeline.getVersionedList();
            this.pushToSnapshot(segments.getStoreSegments());
            done = this.pipeline.swap(segments, null, false, false);
            if (++iterationsCnt <= 2) continue;
            LOG.warn((Object)"Multiple unsuccessful attempts to push the compaction pipeline to snapshot, while flushing to disk.");
            this.snapshot = SegmentFactory.instance().createImmutableSegment(this.getComparator());
            break;
        }
    }

    private void pushToSnapshot(List<ImmutableSegment> segments) {
        if (segments.isEmpty()) {
            return;
        }
        if (segments.size() == 1 && !segments.get(0).isEmpty()) {
            this.snapshot = segments.get(0);
            return;
        }
        this.snapshot = SegmentFactory.instance().createCompositeImmutableSegment(this.getComparator(), segments);
    }

    private RegionServicesForStores getRegionServices() {
        return this.regionServices;
    }

    @VisibleForTesting
    boolean isMemStoreFlushingInMemory() {
        return this.inMemoryFlushInProgress.get();
    }

    @VisibleForTesting
    void disableCompaction() {
        this.allowCompaction.set(false);
    }

    @VisibleForTesting
    void enableCompaction() {
        this.allowCompaction.set(true);
    }

    @VisibleForTesting
    void initiateType(MemoryCompactionPolicy compactionType) {
        this.compactor.initiateAction(compactionType);
    }

    Cell getNextRow(Cell cell) {
        Cell lowest = null;
        List<Segment> segments = this.getSegments();
        for (Segment segment : segments) {
            if (lowest == null) {
                lowest = this.getNextRow(cell, segment.getCellSet());
                continue;
            }
            lowest = this.getLowest(lowest, this.getNextRow(cell, segment.getCellSet()));
        }
        return lowest;
    }

    @VisibleForTesting
    long getInmemoryFlushSize() {
        return this.inmemoryFlushSize;
    }

    public void debug() {
        String msg = "active size=" + this.active.keySize();
        msg = msg + " threshold=" + 0.25 * (double)this.inmemoryFlushSize;
        msg = msg + " allow compaction is " + (this.allowCompaction.get() ? "true" : "false");
        msg = msg + " inMemoryFlushInProgress is " + (this.inMemoryFlushInProgress.get() ? "true" : "false");
        LOG.debug((Object)msg);
    }

    private class InMemoryFlushRunnable
    implements Runnable {
        private InMemoryFlushRunnable() {
        }

        @Override
        public void run() {
            try {
                CompactingMemStore.this.flushInMemory();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to run memstore compaction. region " + CompactingMemStore.this.getRegionServices().getRegionInfo().getRegionNameAsString() + "store: " + CompactingMemStore.this.getFamilyName()), (Throwable)e);
            }
        }
    }

    public static enum IndexType {
        CSLM_MAP,
        ARRAY_MAP,
        CHUNK_MAP;

    }
}

