/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Comparator;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Function;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Ordering;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class StoreFileComparators {
    public static final Comparator<HStoreFile> SEQ_ID = Ordering.compound((Iterable)ImmutableList.of((Object)Ordering.natural().onResultOf((Function)new GetSeqId()), (Object)Ordering.natural().onResultOf((Function)new GetFileSize()).reverse(), (Object)Ordering.natural().onResultOf((Function)new GetBulkTime()), (Object)Ordering.natural().onResultOf((Function)new GetPathName())));
    public static final Comparator<HStoreFile> SEQ_ID_MAX_TIMESTAMP = Ordering.compound((Iterable)ImmutableList.of((Object)Ordering.natural().onResultOf((Function)new GetSeqId()), (Object)Ordering.natural().onResultOf((Function)new GetMaxTimestamp()), (Object)Ordering.natural().onResultOf((Function)new GetFileSize()).reverse(), (Object)Ordering.natural().onResultOf((Function)new GetBulkTime()), (Object)Ordering.natural().onResultOf((Function)new GetPathName())));

    StoreFileComparators() {
    }

    private static class GetMaxTimestamp
    implements Function<HStoreFile, Long> {
        private GetMaxTimestamp() {
        }

        public Long apply(HStoreFile sf) {
            return sf.getMaximumTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetPathName
    implements Function<HStoreFile, String> {
        private GetPathName() {
        }

        public String apply(HStoreFile sf) {
            return sf.getPath().getName();
        }
    }

    private static class GetBulkTime
    implements Function<HStoreFile, Long> {
        private GetBulkTime() {
        }

        public Long apply(HStoreFile sf) {
            return sf.getBulkLoadTimestamp().orElse(Long.MAX_VALUE);
        }
    }

    private static class GetFileSize
    implements Function<HStoreFile, Long> {
        private GetFileSize() {
        }

        public Long apply(HStoreFile sf) {
            if (sf.getReader() != null) {
                return sf.getReader().length();
            }
            return -1L;
        }
    }

    private static class GetSeqId
    implements Function<HStoreFile, Long> {
        private GetSeqId() {
        }

        public Long apply(HStoreFile sf) {
            return sf.getMaxSequenceId();
        }
    }
}

