/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsWAL
extends WALActionsListener.Base {
    private static final Log LOG = LogFactory.getLog(MetricsWAL.class);
    private final MetricsWALSource source;

    public MetricsWAL() {
        this((MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class));
    }

    @VisibleForTesting
    MetricsWAL(MetricsWALSource s) {
        this.source = s;
    }

    @Override
    public void postSync(long timeInNanos, int handlerSyncs) {
        this.source.incrementSyncTime(timeInNanos / 1000000L);
    }

    @Override
    public void postAppend(long size, long time, WALKey logkey, WALEdit logEdit) throws IOException {
        this.source.incrementAppendCount();
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(size);
        this.source.incrementWrittenBytes(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn((Object)String.format("%s took %d ms appending an edit to wal; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }

    @Override
    public void logRollRequested(boolean underReplicated) {
        this.source.incrementLogRollRequested();
        if (underReplicated) {
            this.source.incrementLowReplicationLogRoll();
        }
    }
}

