/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.LeaseNotRecoveredException;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractFSWALProvider<T extends AbstractFSWAL<?>>
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(AbstractFSWALProvider.class);
    public static final String SEPARATE_OLDLOGDIR = "hbase.separate.oldlogdir.by.regionserver";
    public static final boolean DEFAULT_SEPARATE_OLDLOGDIR = false;
    protected volatile T wal;
    protected WALFactory factory = null;
    protected Configuration conf = null;
    protected List<WALActionsListener> listeners = null;
    protected String providerId = null;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected String logPrefix = null;
    private final Object walCreateLock = new Object();
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    @VisibleForTesting
    public static final String META_WAL_PROVIDER_ID = ".meta";
    static final String DEFAULT_PROVIDER_ID = "default";
    public static final String SPLITTING_EXT = "-splitting";
    private static final Pattern pattern = Pattern.compile(".*\\.\\d*(.meta)*");

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.listeners = listeners;
        this.providerId = providerId;
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(WAL_FILE_NAME_DELIMITER)) {
                sb.append(providerId);
            } else {
                sb.append(WAL_FILE_NAME_DELIMITER).append(providerId);
            }
        }
        this.logPrefix = sb.toString();
        this.doInit(conf);
    }

    @Override
    public List<WAL> getWALs() {
        if (this.wal == null) {
            return Collections.emptyList();
        }
        ArrayList<WAL> wals = new ArrayList<WAL>(1);
        wals.add((WAL)this.wal);
        return wals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getWAL(byte[] identifier, byte[] namespace) throws IOException {
        T walCopy = this.wal;
        if (walCopy == null) {
            Object object = this.walCreateLock;
            synchronized (object) {
                walCopy = this.wal;
                if (walCopy == null) {
                    this.wal = walCopy = this.createWAL();
                }
            }
        }
        return walCopy;
    }

    protected abstract T createWAL() throws IOException;

    protected abstract void doInit(Configuration var1) throws IOException;

    @Override
    public void shutdown() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).close();
        }
    }

    @Override
    public long getNumLogFiles() {
        T log = this.wal;
        return log == null ? 0L : (long)((AbstractFSWAL)log).getNumLogFiles();
    }

    @Override
    public long getLogFileSize() {
        T log = this.wal;
        return log == null ? 0L : ((AbstractFSWAL)log).getLogFileSize();
    }

    @VisibleForTesting
    public static int getNumRolledLogFiles(WAL wal) {
        return ((AbstractFSWAL)wal).getNumRolledLogFiles();
    }

    @VisibleForTesting
    public static long getLogFileSize(WAL wal) {
        return ((AbstractFSWAL)wal).getLogFileSize();
    }

    @VisibleForTesting
    public static Path getCurrentFileName(WAL wal) {
        return ((AbstractFSWAL)wal).getCurrentFileName();
    }

    @VisibleForTesting
    static void requestLogRoll(WAL wal) {
        ((AbstractFSWAL)wal).requestLogRoll();
    }

    @VisibleForTesting
    public static long extractFileNumFromWAL(WAL wal) {
        Path walName = ((AbstractFSWAL)wal).getCurrentFileName();
        if (walName == null) {
            throw new IllegalArgumentException("The WAL path couldn't be null");
        }
        String[] walPathStrs = walName.toString().split("\\.");
        return Long.parseLong(walPathStrs[walPathStrs.length - (AbstractFSWALProvider.isMetaFile(walName) ? 2 : 1)]);
    }

    public static boolean validateWALFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static String getWALDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static String getWALArchiveDirectoryName(Configuration conf, String serverName) {
        StringBuilder dirName = new StringBuilder("oldWALs");
        if (conf.getBoolean(SEPARATE_OLDLOGDIR, false)) {
            dirName.append("/");
            dirName.append(serverName);
        }
        return dirName.toString();
    }

    public static ServerName getServerNameFromWALDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String rootDir = conf.get("hbase.rootdir");
        if (rootDir == null || rootDir.isEmpty()) {
            throw new IllegalArgumentException("hbase.rootdir key not found in conf.");
        }
        StringBuilder startPathSB = new StringBuilder(rootDir);
        if (!rootDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Object)("Call to makeQualified failed on " + path + " " + e.getMessage()));
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return AbstractFSWALProvider.getServerNameFromWALDirectoryName(p);
    }

    public static ServerName getServerNameFromWALDirectoryName(Path logFile) {
        String logDirName = logFile.getParent().getName();
        if (logDirName.equals("WALs")) {
            logDirName = logFile.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith(SPLITTING_EXT)) {
            logDirName = logDirName.substring(0, logDirName.length() - SPLITTING_EXT.length());
        }
        try {
            serverName = ServerName.parseServerName((String)logDirName);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            serverName = null;
            LOG.warn((Object)("Cannot parse a server name from path=" + logFile + "; " + ex.getMessage()));
        }
        if (serverName != null && serverName.getStartcode() < 0L) {
            LOG.warn((Object)("Invalid log file path=" + logFile));
            serverName = null;
        }
        return serverName;
    }

    public static boolean isMetaFile(Path p) {
        return AbstractFSWALProvider.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(META_WAL_PROVIDER_ID);
    }

    public static boolean isArchivedLogFile(Path p) {
        String oldLog = "/oldWALs/";
        return p.toString().contains(oldLog);
    }

    public static Path getArchivedLogPath(Path path, Configuration conf) throws IOException {
        Path rootDir = FSUtils.getRootDir(conf);
        Path oldLogDir = new Path(rootDir, "oldWALs");
        if (conf.getBoolean(SEPARATE_OLDLOGDIR, false)) {
            ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(path);
            if (serverName == null) {
                LOG.error((Object)("Couldn't locate log: " + path));
                return path;
            }
            oldLogDir = new Path(oldLogDir, serverName.getServerName());
        }
        Path archivedLogLocation = new Path(oldLogDir, path.getName());
        FileSystem fs = FSUtils.getCurrentFileSystem(conf);
        if (fs.exists(archivedLogLocation)) {
            LOG.info((Object)("Log " + path + " was moved to " + archivedLogLocation));
            return archivedLogLocation;
        }
        LOG.error((Object)("Couldn't locate log: " + path));
        return path;
    }

    public static WAL.Reader openReader(Path path, Configuration conf) throws IOException {
        long retryInterval = 2000L;
        int maxAttempts = 30;
        int attempt = 0;
        Object ee = null;
        WAL.Reader reader = null;
        while (reader == null && attempt++ < maxAttempts) {
            try {
                reader = WALFactory.createReader(path.getFileSystem(conf), path, conf);
                return reader;
            }
            catch (FileNotFoundException fnfe) {
                Path archivedLog = AbstractFSWALProvider.getArchivedLogPath(path, conf);
                if (path != archivedLog) {
                    return AbstractFSWALProvider.openReader(archivedLog, conf);
                }
                throw fnfe;
            }
            catch (LeaseNotRecoveredException lnre) {
                LOG.warn((Object)("Try to recover the WAL lease " + path), (Throwable)((Object)lnre));
                AbstractFSWALProvider.recoverLease(conf, path);
                reader = null;
                ee = lnre;
            }
            catch (NullPointerException npe) {
                LOG.warn((Object)"Got NPE opening reader, will retry.");
                reader = null;
                ee = npe;
            }
            if (reader != null) continue;
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new IOException("Could not open reader", (Throwable)ee);
    }

    private static void recoverLease(Configuration conf, final Path path) {
        try {
            FileSystem dfs = FSUtils.getCurrentFileSystem(conf);
            FSUtils fsUtils = FSUtils.getInstance(dfs, conf);
            fsUtils.recoverFileLease(dfs, path, conf, new CancelableProgressable(){

                @Override
                public boolean progress() {
                    LOG.debug((Object)("Still trying to recover WAL lease: " + path));
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)("unable to recover lease for WAL: " + path), (Throwable)e);
        }
    }

    public static String getWALPrefixFromWALName(String name) {
        int endIndex = name.replaceAll(META_WAL_PROVIDER_ID, "").lastIndexOf(WAL_FILE_NAME_DELIMITER);
        return name.substring(0, endIndex);
    }

    public static interface Reader
    extends WAL.Reader {
        public void init(FileSystem var1, Path var2, Configuration var3, FSDataInputStream var4) throws IOException;
    }
}

