/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.SimpleScanResultConsumer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableScan
extends AbstractTestAsyncTableScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScan.class);
    @Parameterized.Parameter(value=0)
    public String scanType;
    @Parameterized.Parameter(value=1)
    public Supplier<Scan> scanCreater;

    @Parameterized.Parameters(name="{index}: scan={0}")
    public static List<Object[]> params() {
        return TestAsyncTableScan.getScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreater.get();
    }

    @Override
    protected List<Result> doScan(Scan scan) throws Exception {
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
        SimpleScanResultConsumer consumer = new SimpleScanResultConsumer();
        table.scan(scan, (ScanResultConsumerBase)consumer);
        List<Result> results = consumer.getAll();
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }
}

