/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.FromClientSideBase;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestFromClientSide4
extends FromClientSideBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide4.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSide4.class);
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TestFromClientSide4.initialize(MultiRowMutationEndpoint.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestFromClientSide4.afterClass();
    }

    @Test
    public void testBatchOperationsWithErrors() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table foo = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 10);){
            int i;
            Put put;
            int NUM_OPS = 100;
            ArrayList<Put> puts = new ArrayList<Put>(NUM_OPS);
            for (int i2 = 0; i2 != NUM_OPS; ++i2) {
                put = new Put(Bytes.toBytes((int)i2));
                puts.add(put);
            }
            try {
                foo.put(puts);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((long)NUM_OPS, (long)puts.size());
            }
            puts.clear();
            for (int i3 = 0; i3 < NUM_OPS; ++i3) {
                put = new Put(Bytes.toBytes((int)i3));
                put.addColumn(i3 % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY, Bytes.toBytes((int)i3));
                puts.add(put);
            }
            try {
                foo.put(puts);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    Assert.assertThat(((RetriesExhaustedWithDetailsException)((Object)e)).exceptions.get(0), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
                }
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
            }
            ArrayList<Get> gets = new ArrayList<Get>(NUM_OPS);
            for (int i4 = 0; i4 < NUM_OPS; ++i4) {
                Get get = new Get(Bytes.toBytes((int)i4));
                gets.add(get);
            }
            Result[] getsResult = foo.get(gets);
            Assert.assertNotNull((Object)getsResult);
            Assert.assertEquals((long)NUM_OPS, (long)getsResult.length);
            for (i = 0; i < NUM_OPS; ++i) {
                Result getResult = getsResult[i];
                if (i % 2 == 0) {
                    Assert.assertFalse((boolean)getResult.isEmpty());
                    continue;
                }
                Assert.assertTrue((boolean)getResult.isEmpty());
            }
            gets.clear();
            for (i = 0; i < NUM_OPS; ++i) {
                Get get = new Get(Bytes.toBytes((int)i));
                get.addColumn(i % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY);
                gets.add(get);
            }
            try {
                foo.get(gets);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    Assert.assertThat(((RetriesExhaustedWithDetailsException)((Object)e)).exceptions.get(0), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
                }
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
            }
            ArrayList<Delete> deletes = new ArrayList<Delete>(NUM_OPS);
            for (int i5 = 0; i5 < NUM_OPS; ++i5) {
                Delete delete = new Delete(Bytes.toBytes((int)i5));
                delete.addColumn(i5 % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY);
                deletes.add(delete);
            }
            try {
                foo.delete(deletes);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    Assert.assertThat(((RetriesExhaustedWithDetailsException)((Object)e)).exceptions.get(0), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
                }
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
            }
            gets.clear();
            for (int i6 = 0; i6 < NUM_OPS; ++i6) {
                Get get = new Get(Bytes.toBytes((int)i6));
                gets.add(get);
            }
            getsResult = foo.get(gets);
            Assert.assertNotNull((Object)getsResult);
            Assert.assertEquals((long)NUM_OPS, (long)getsResult.length);
            for (Result getResult : getsResult) {
                Assert.assertTrue((boolean)getResult.isEmpty());
            }
            deletes.clear();
            for (int i7 = 0; i7 < NUM_OPS; ++i7) {
                Delete delete = new Delete(Bytes.toBytes((int)i7));
                deletes.add(delete);
            }
            foo.delete(deletes);
        }
    }

    @Test
    public void testJiraTest867() throws Exception {
        int numRows = 10;
        int numColsPerRow = 2000;
        TableName tableName = this.name.getTableName();
        byte[][] ROWS = this.makeN(ROW, numRows);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, numColsPerRow);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            int i;
            Cell[] kvs;
            int rowCount;
            for (int i2 = 0; i2 < numRows; ++i2) {
                Put put = new Put(ROWS[i2]);
                put.setDurability(Durability.SKIP_WAL);
                for (int j = 0; j < numColsPerRow; ++j) {
                    put.addColumn(FAMILY, QUALIFIERS[j], QUALIFIERS[j]);
                }
                Assert.assertEquals((String)("Put expected to contain " + numColsPerRow + " columns but only contains " + put.size()), (long)put.size(), (long)numColsPerRow);
                ht.put(put);
            }
            Get get = new Get(ROWS[numRows - 1]);
            Result result = ht.get(get);
            this.assertNumKeys(result, numColsPerRow);
            Cell[] keys = result.rawCells();
            for (int i3 = 0; i3 < result.size(); ++i3) {
                this.assertKey(keys[i3], ROWS[numRows - 1], FAMILY, QUALIFIERS[i3], QUALIFIERS[i3]);
            }
            Scan scan = new Scan();
            try (ResultScanner scanner = ht.getScanner(scan);){
                rowCount = 0;
                while ((result = scanner.next()) != null) {
                    this.assertNumKeys(result, numColsPerRow);
                    kvs = result.rawCells();
                    for (i = 0; i < numColsPerRow; ++i) {
                        this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
                    }
                    ++rowCount;
                }
                Assert.assertEquals((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (long)rowCount, (long)numRows);
            }
            TEST_UTIL.flush();
            get = new Get(ROWS[numRows - 1]);
            result = ht.get(get);
            this.assertNumKeys(result, numColsPerRow);
            keys = result.rawCells();
            for (int i4 = 0; i4 < result.size(); ++i4) {
                this.assertKey(keys[i4], ROWS[numRows - 1], FAMILY, QUALIFIERS[i4], QUALIFIERS[i4]);
            }
            scan = new Scan();
            scanner = ht.getScanner(scan);
            var13_20 = null;
            try {
                rowCount = 0;
                while ((result = scanner.next()) != null) {
                    this.assertNumKeys(result, numColsPerRow);
                    kvs = result.rawCells();
                    for (i = 0; i < numColsPerRow; ++i) {
                        this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
                    }
                    ++rowCount;
                }
                Assert.assertEquals((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (long)rowCount, (long)numRows);
            }
            catch (Throwable throwable) {
                var13_20 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var13_20 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var13_20.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    @Test
    public void testJiraTest861() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            ht.put(put);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
            TEST_UTIL.flush();
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
            ht.put(put);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
            TEST_UTIL.flush();
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        }
    }

    @Test
    public void testJiraTest33() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            ht.put(put);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
            TEST_UTIL.flush();
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        }
    }

    @Test
    public void testJiraTest1014() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            long manualStamp = 12345L;
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, manualStamp, VALUE);
            ht.put(put);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, manualStamp, VALUE);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp - 1L);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp + 1L);
        }
    }

    @Test
    public void testJiraTest1182() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            ht.put(put);
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            TEST_UTIL.flush();
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
            this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
            this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        }
    }

    @Test
    public void testJiraTest52() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            ht.put(put);
            this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            TEST_UTIL.flush();
            this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
            this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        }
    }

    @Test
    public void testDuplicateVersions() throws Exception {
        TableName tableName = this.name.getTableName();
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            ht.put(put);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(2);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            Scan scan = new Scan(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setMaxVersions(2);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            TEST_UTIL.flush();
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(2);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            scan = new Scan(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setMaxVersions(2);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(7);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
            scan = new Scan(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setMaxVersions(7);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
            get = new Get(ROW);
            get.readVersions(7);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
            scan = new Scan(ROW);
            scan.setMaxVersions(7);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
            this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
            this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
            this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
            TEST_UTIL.flush();
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
            put.addColumn(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
            scan = new Scan(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
            Delete delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER, STAMPS[11]);
            delete.addColumn(FAMILY, QUALIFIER, STAMPS[7]);
            ht.delete(delete);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
            scan = new Scan(ROW);
            scan.addColumn(FAMILY, QUALIFIER);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        }
    }

    @Test
    public void testUpdates() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);){
            byte[] row = Bytes.toBytes((String)"row1");
            byte[] qualifier = Bytes.toBytes((String)"myCol");
            Put put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
            hTable.put(put);
            Get get = new Get(row);
            get.addColumn(FAMILY, qualifier);
            get.readAllVersions();
            Result result = hTable.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
            hTable.put(put);
            result = hTable.get(get);
            navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        }
    }

    @Test
    public void testUpdatesWithMajorCompaction() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
             Admin admin = TEST_UTIL.getAdmin();){
            byte[] row = Bytes.toBytes((String)"row2");
            byte[] qualifier = Bytes.toBytes((String)"myCol");
            Put put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
            hTable.put(put);
            Get get = new Get(row);
            get.addColumn(FAMILY, qualifier);
            get.readAllVersions();
            Result result = hTable.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
            admin.flush(tableName);
            admin.majorCompact(tableName);
            Thread.sleep(6000L);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
            hTable.put(put);
            admin.flush(tableName);
            admin.majorCompact(tableName);
            Thread.sleep(6000L);
            result = hTable.get(get);
            navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        }
    }

    @Test
    public void testMajorCompactionBetweenTwoUpdates() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
             Admin admin = TEST_UTIL.getAdmin();){
            byte[] row = Bytes.toBytes((String)"row3");
            byte[] qualifier = Bytes.toBytes((String)"myCol");
            Put put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
            hTable.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
            hTable.put(put);
            Get get = new Get(row);
            get.addColumn(FAMILY, qualifier);
            get.readAllVersions();
            Result result = hTable.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
            admin.flush(tableName);
            admin.majorCompact(tableName);
            Thread.sleep(6000L);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
            hTable.put(put);
            admin.flush(tableName);
            admin.majorCompact(tableName);
            Thread.sleep(6000L);
            put = new Put(row);
            put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
            hTable.put(put);
            admin.flush(tableName);
            admin.majorCompact(tableName);
            Thread.sleep(6000L);
            result = hTable.get(get);
            navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
            Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
            Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        }
    }

    @Test
    public void testGet_EmptyTable() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Get get = new Get(ROW);
            get.addFamily(FAMILY);
            Result r = table.get(get);
            Assert.assertTrue((boolean)r.isEmpty());
        }
    }

    @Test
    public void testGet_NullQualifier() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            put = new Put(ROW);
            put.addColumn(FAMILY, null, VALUE);
            table.put(put);
            LOG.info("Row put");
            Get get = new Get(ROW);
            get.addColumn(FAMILY, null);
            Result r = table.get(get);
            Assert.assertEquals((long)1L, (long)r.size());
            get = new Get(ROW);
            get.addFamily(FAMILY);
            r = table.get(get);
            Assert.assertEquals((long)2L, (long)r.size());
        }
    }

    @Test
    public void testGet_NonExistentRow() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            LOG.info("Row put");
            Get get = new Get(ROW);
            get.addFamily(FAMILY);
            Result r = table.get(get);
            Assert.assertFalse((boolean)r.isEmpty());
            System.out.println("Row retrieved successfully");
            byte[] missingrow = Bytes.toBytes((String)"missingrow");
            get = new Get(missingrow);
            get.addFamily(FAMILY);
            r = table.get(get);
            Assert.assertTrue((boolean)r.isEmpty());
            LOG.info("Row missing as it should be");
        }
    }

    @Test
    public void testPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] value = Bytes.toBytes((String)"abcd");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});){
            Put put = new Put(row1);
            put.addColumn(CONTENTS_FAMILY, null, value);
            table.put(put);
            put = new Put(row2);
            put.addColumn(CONTENTS_FAMILY, null, value);
            Assert.assertEquals((long)1L, (long)put.size());
            Assert.assertEquals((long)1L, (long)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).size());
            KeyValue kv = (KeyValue)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])CONTENTS_FAMILY));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)kv), (byte[])new byte[0]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)kv), (byte[])value));
            table.put(put);
            Scan scan = new Scan();
            scan.addColumn(CONTENTS_FAMILY, null);
            try (ResultScanner scanner = table.getScanner(scan);){
                for (Result r : scanner) {
                    for (Cell key : r.rawCells()) {
                        System.out.println(Bytes.toString((byte[])r.getRow()) + ": " + key.toString());
                    }
                }
            }
        }
    }

    @Test
    public void testPutNoCF() throws IOException {
        byte[] BAD_FAM = Bytes.toBytes((String)"BAD_CF");
        byte[] VAL = Bytes.toBytes((int)100);
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            boolean caughtNSCFE = false;
            try {
                Put p = new Put(ROW);
                p.addColumn(BAD_FAM, QUALIFIER, VAL);
                table.put(p);
            }
            catch (Exception e) {
                caughtNSCFE = e instanceof NoSuchColumnFamilyException;
            }
            Assert.assertTrue((String)"Should throw NoSuchColumnFamilyException", (boolean)caughtNSCFE);
        }
    }

    @Test
    public void testRowsPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        int NB_BATCH_ROWS = 10;
        byte[] value = Bytes.toBytes((String)"abcd");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});){
            ArrayList<Put> rowsUpdate = new ArrayList<Put>();
            for (int i = 0; i < 10; ++i) {
                byte[] row = Bytes.toBytes((String)("row" + i));
                Put put = new Put(row);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(CONTENTS_FAMILY, null, value);
                rowsUpdate.add(put);
            }
            table.put(rowsUpdate);
            Scan scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            try (ResultScanner scanner = table.getScanner(scan);){
                int nbRows = 0;
                for (Result row : scanner) {
                    ++nbRows;
                }
                Assert.assertEquals((long)10L, (long)nbRows);
            }
        }
    }

    @Test
    public void testRowsPutBufferedManyManyFlushes() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});){
            ArrayList<Put> rowsUpdate = new ArrayList<Put>();
            for (int i = 0; i < 100; ++i) {
                byte[] row = Bytes.toBytes((String)("row" + i));
                Put put = new Put(row);
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(CONTENTS_FAMILY, null, value);
                rowsUpdate.add(put);
            }
            table.put(rowsUpdate);
            Scan scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            try (ResultScanner scanner = table.getScanner(scan);){
                int nbRows = 0;
                for (Result row : scanner) {
                    ++nbRows;
                }
                Assert.assertEquals((long)100L, (long)nbRows);
            }
        }
    }

    @Test
    public void testAddKeyValue() {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"qf1");
        Put put = new Put(row1);
        KeyValue kv = new KeyValue(row1, CONTENTS_FAMILY, qualifier, value);
        boolean ok = true;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        kv = new KeyValue(row2, CONTENTS_FAMILY, qualifier, value);
        ok = false;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testHBase737() throws IOException {
        byte[] FAM1 = Bytes.toBytes((String)"fam1");
        byte[] FAM2 = Bytes.toBytes((String)"fam2");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), (byte[][])new byte[][]{FAM1, FAM2});){
            Result r;
            int index;
            Put put = new Put(ROW);
            put.addColumn(FAM1, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"abcdefg"));
            table.put(put);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            put = new Put(ROW);
            put.addColumn(FAM1, Bytes.toBytes((String)"numbers"), Bytes.toBytes((String)"123456"));
            table.put(put);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            put = new Put(ROW);
            put.addColumn(FAM2, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"hijklmnop"));
            table.put(put);
            long[] times = new long[3];
            Scan scan = new Scan();
            scan.addFamily(FAM1);
            scan.addFamily(FAM2);
            try (ResultScanner s = table.getScanner(scan);){
                index = 0;
                while ((r = s.next()) != null) {
                    for (Cell key : r.rawCells()) {
                        times[index++] = key.getTimestamp();
                    }
                }
            }
            for (int i = 0; i < times.length - 1; ++i) {
                for (int j = i + 1; j < times.length; ++j) {
                    Assert.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
                }
            }
            TEST_UTIL.flush();
            Arrays.fill(times, 0L);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            scan = new Scan();
            scan.addFamily(FAM1);
            scan.addFamily(FAM2);
            s = table.getScanner(scan);
            Throwable throwable = null;
            try {
                index = 0;
                r = null;
                while ((r = s.next()) != null) {
                    for (Cell key : r.rawCells()) {
                        times[index++] = key.getTimestamp();
                    }
                }
                for (int i = 0; i < times.length - 1; ++i) {
                    for (int j = i + 1; j < times.length; ++j) {
                        Assert.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
    }

    @Test
    public void testListTables() throws IOException {
        TableName[] tables;
        String testTableName = this.name.getTableName().toString();
        TableName tableName1 = TableName.valueOf((String)(testTableName + "1"));
        TableName tableName2 = TableName.valueOf((String)(testTableName + "2"));
        TableName tableName3 = TableName.valueOf((String)(testTableName + "3"));
        for (TableName table : tables = new TableName[]{tableName1, tableName2, tableName3}) {
            TEST_UTIL.createTable(table, FAMILY);
        }
        try (Admin admin = TEST_UTIL.getAdmin();){
            List ts = admin.listTableDescriptors();
            HashSet result = new HashSet(ts);
            int size = result.size();
            Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
            for (TableName table : tables) {
                boolean found = false;
                for (TableDescriptor t : ts) {
                    if (!t.getTableName().equals((Object)table)) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((String)("Not found: " + table), (boolean)found);
            }
        }
    }

    @Test
    public void testUnmanagedHConnection() throws IOException {
        TableName tableName = this.name.getTableName();
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table t = conn.getTable(tableName);
             Admin admin = conn.getAdmin();){
            Assert.assertTrue((boolean)admin.tableExists(tableName));
            Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
        }
    }

    @Test
    public void testUnmanagedHConnectionReconnect() throws Exception {
        TableName tableName = this.name.getTableName();
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Throwable throwable;
            Admin admin;
            try (Table t = conn.getTable(tableName);){
                admin = conn.getAdmin();
                throwable = null;
                try {
                    Assert.assertTrue((boolean)admin.tableExists(tableName));
                    Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            cluster.stopMaster(0, false);
            cluster.waitOnMaster(0);
            cluster.startMaster();
            Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
            boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
            admin = conn.getAdmin();
            throwable = null;
            try {
                Assert.assertTrue((boolean)admin.tableExists(tableName));
                Assert.assertEquals((long)admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size(), (long)(SLAVES + (tablesOnMaster ? 1 : 0)));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    @Test
    public void testMiscHTableStuff() throws IOException {
        String testTableName = this.name.getTableName().toString();
        TableName tableAname = TableName.valueOf((String)(testTableName + "A"));
        TableName tableBname = TableName.valueOf((String)(testTableName + "B"));
        byte[] attrName = Bytes.toBytes((String)"TESTATTR");
        byte[] attrValue = Bytes.toBytes((String)"somevalue");
        byte[] value = Bytes.toBytes((String)"value");
        try (Table a = TEST_UTIL.createTable(tableAname, HConstants.CATALOG_FAMILY);
             Table b = TEST_UTIL.createTable(tableBname, HConstants.CATALOG_FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(HConstants.CATALOG_FAMILY, null, value);
            a.put(put);
            try (Table newA = TEST_UTIL.getConnection().getTable(tableAname);){
                Scan scan = new Scan();
                scan.addFamily(HConstants.CATALOG_FAMILY);
                try (ResultScanner s = newA.getScanner(scan);){
                    for (Result r : s) {
                        put = new Put(r.getRow());
                        put.setDurability(Durability.SKIP_WAL);
                        for (Cell kv : r.rawCells()) {
                            put.add(kv);
                        }
                        b.put(put);
                    }
                }
            }
            var13_17 = null;
            try (Table anotherA = TEST_UTIL.getConnection().getTable(tableAname);){
                Get get = new Get(ROW);
                get.addFamily(HConstants.CATALOG_FAMILY);
                anotherA.get(get);
            }
            catch (Throwable throwable) {
                var13_17 = throwable;
                throw throwable;
            }
            Admin admin = TEST_UTIL.getAdmin();
            HTableDescriptor desc = new HTableDescriptor(a.getDescriptor());
            admin.disableTable(tableAname);
            desc.setValue(attrName, attrValue);
            for (HColumnDescriptor c : desc.getFamilies()) {
                c.setValue(attrName, attrValue);
            }
            admin.modifyTable((TableDescriptor)desc);
            admin.enableTable(tableAname);
            desc = new HTableDescriptor(a.getDescriptor());
            Assert.assertEquals((String)"wrong table descriptor returned", (Object)desc.getTableName(), (Object)tableAname);
            value = desc.getValue(attrName);
            Assert.assertNotNull((String)"missing HTD attribute value", (Object)value);
            Assert.assertFalse((String)"HTD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
            for (HColumnDescriptor c : desc.getFamilies()) {
                value = c.getValue(attrName);
                Assert.assertNotNull((String)"missing HCD attribute value", (Object)value);
                Assert.assertFalse((String)"HCD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
            }
        }
    }
}

