/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestShortCircuitConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShortCircuitConnection.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testShortCircuitConnection() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = UTIL.createTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"cf"));
        htd.addFamily(hcd);
        UTIL.createTable((TableDescriptor)htd, (byte[][])null);
        HRegionServer regionServer = UTIL.getRSForFirstRegionInTable(tableName);
        ClusterConnection connection = regionServer.getClusterConnection();
        Table tableIf = connection.getTable(tableName);
        Assert.assertTrue((boolean)(tableIf instanceof HTable));
        HTable table = (HTable)tableIf;
        Assert.assertTrue((table.getConnection() == connection ? 1 : 0) != 0);
        AdminProtos.AdminService.BlockingInterface admin = connection.getAdmin(regionServer.getServerName());
        ClientProtos.ClientService.BlockingInterface client = connection.getClient(regionServer.getServerName());
        Assert.assertTrue((boolean)(admin instanceof RSRpcServices));
        Assert.assertTrue((boolean)(client instanceof RSRpcServices));
        ServerName anotherSn = ServerName.valueOf((Address)regionServer.getServerName().getAddress(), (long)EnvironmentEdgeManager.currentTime());
        admin = connection.getAdmin(anotherSn);
        client = connection.getClient(anotherSn);
        Assert.assertFalse((boolean)(admin instanceof RSRpcServices));
        Assert.assertFalse((boolean)(client instanceof RSRpcServices));
        Assert.assertTrue((connection.getAdmin().getConnection() == connection ? 1 : 0) != 0);
    }
}

