/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.TestFanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLocalAsyncOutput {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLocalAsyncOutput.class);
    private static EventLoopGroup GROUP = new NioEventLoopGroup();
    private static Class<? extends Channel> CHANNEL_CLASS = NioSocketChannel.class;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
        GROUP.shutdownGracefully();
    }

    @Test
    public void test() throws IOException, InterruptedException, ExecutionException, CommonFSUtils.StreamLacksCapabilityException {
        Path f = new Path(TEST_UTIL.getDataTestDir(), "test");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)TEST_UTIL.getConfiguration());
        AsyncFSOutput out = AsyncFSOutputHelper.createOutput((FileSystem)fs, (Path)f, (boolean)false, (boolean)true, (short)fs.getDefaultReplication(f), (long)fs.getDefaultBlockSize(f), (EventLoopGroup)GROUP, CHANNEL_CLASS);
        TestFanOutOneBlockAsyncDFSOutput.writeAndVerify((FileSystem)fs, f, out);
    }
}

