/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSpaceQuotaOnBulkLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaOnBulkLoad.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotaOnBulkLoad.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testNoBulkLoadsWithNoWrites() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tableName = this.helper.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)p);
        ClientServiceCallable<Void> callable = this.helper.generateFileToLoad(tableName, 1, 50);
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TEST_UTIL.getConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        try {
            caller.callWithRetries(callable, Integer.MAX_VALUE);
            Assert.fail((String)"Expected the bulk load call to fail!");
        }
        catch (SpaceLimitingException e) {
            LOG.trace("Caught expected exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicBulkLoadUnderQuota() throws Exception {
        FileStatus[] files;
        SpaceQuotaSnapshot snapshot;
        TableName tn = this.helper.createTableWithRegions(10);
        long sizeLimit = 51200L;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)51200L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(settings);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        RegionServerSpaceQuotaManager spaceQuotaManager = rs.getRegionServerSpaceQuotaManager();
        Map snapshots = spaceQuotaManager.copyQuotaSnapshots();
        Map<RegionInfo, Long> regionSizes = this.getReportedSizesForTable(tn);
        while ((snapshot = (SpaceQuotaSnapshot)snapshots.get(tn)) == null || snapshot.getLimit() <= 0L) {
            LOG.debug("Snapshot does not yet realize quota limit: " + snapshots + ", regionsizes: " + regionSizes);
            Thread.sleep(3000L);
            snapshots = spaceQuotaManager.copyQuotaSnapshots();
            regionSizes = this.getReportedSizesForTable(tn);
        }
        snapshot = (SpaceQuotaSnapshot)snapshots.get(tn);
        Assert.assertEquals((long)0L, (long)snapshot.getUsage());
        Assert.assertEquals((long)51200L, (long)snapshot.getLimit());
        ActivePolicyEnforcement activePolicies = spaceQuotaManager.getActiveEnforcements();
        SpaceViolationPolicyEnforcement enforcement = activePolicies.getPolicyEnforcement(tn);
        Assert.assertTrue((String)("Expected to find Noop policy, but got " + enforcement.getClass().getSimpleName()), (boolean)(enforcement instanceof DefaultViolationPolicyEnforcement));
        ClientServiceCallable<Void> callable = this.helper.generateFileToLoad(tn, 2, 500);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        for (FileStatus file : files = fs.listStatus(new Path(fs.getHomeDirectory(), this.testName.getMethodName() + "_files"))) {
            Assert.assertTrue((String)("Expected the file, " + file.getPath() + ",  length to be larger than 25KB, but was " + file.getLen()), (file.getLen() > 25600L ? 1 : 0) != 0);
            LOG.debug(file.getPath() + " -> " + file.getLen() + "B");
        }
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TEST_UTIL.getConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        try {
            caller.callWithRetries(callable, Integer.MAX_VALUE);
            Assert.fail((String)"Expected the bulk load call to fail!");
        }
        catch (SpaceLimitingException e) {
            LOG.trace("Caught expected exception", (Throwable)e);
        }
        Table table = TEST_UTIL.getConnection().getTable(tn);
        try (ResultScanner scanner = table.getScanner(new Scan());){
            Assert.assertNull((String)"Expected no results", (Object)scanner.next());
        }
    }

    private Map<RegionInfo, Long> getReportedSizesForTable(TableName tn) {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        HashMap<RegionInfo, Long> filteredRegionSizes = new HashMap<RegionInfo, Long>();
        for (Map.Entry entry : quotaManager.snapshotRegionSizes().entrySet()) {
            if (!((RegionInfo)entry.getKey()).getTable().equals((Object)tn)) continue;
            filteredRegionSizes.put((RegionInfo)entry.getKey(), (Long)entry.getValue());
        }
        return filteredRegionSizes;
    }
}

