/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRecoveredEdits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoveredEdits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestRecoveredEdits.class);
    private static BlockCache blockCache;
    @Rule
    public TestName testName = new TestName();
    public static final Path RECOVEREDEDITS_PATH;
    public static final String RECOVEREDEDITS_TABLENAME = "IntegrationTestBigLinkedList";
    public static final byte[] RECOVEREDEDITS_COLUMNFAMILY;
    public static final byte[][] RECOVEREDITS_COLUMNFAMILY_ARRAY;
    public static final ColumnFamilyDescriptor RECOVEREDEDITS_CFD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        blockCache = BlockCacheFactory.createBlockCache((Configuration)TEST_UTIL.getConfiguration());
    }

    @Test
    public void testReplayWorksThoughLotsOfFlushing() throws IOException {
        for (MemoryCompactionPolicy policy : MemoryCompactionPolicy.values()) {
            this.testReplayWorksWithMemoryCompactionPolicy(policy);
        }
    }

    private void testReplayWorksWithMemoryCompactionPolicy(MemoryCompactionPolicy policy) throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(policy).toLowerCase());
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.testName.getMethodName())).setColumnFamily(RECOVEREDEDITS_CFD).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDescriptor.getTableName()).build();
        String encodedRegionName = hri.getEncodedName();
        Path hbaseRootDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path tableDir = FSUtils.getTableDir((Path)hbaseRootDir, (TableName)tableDescriptor.getTableName());
        HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tableDir, hri);
        if (fs.exists(hrfs.getRegionDir())) {
            LOG.info("Region directory already exists. Deleting.");
            fs.delete(hrfs.getRegionDir(), true);
        }
        HRegion region = HBaseTestingUtility.createRegionAndWAL(hri, hbaseRootDir, conf, tableDescriptor, blockCache);
        Assert.assertEquals((Object)encodedRegionName, (Object)region.getRegionInfo().getEncodedName());
        List storeFiles = region.getStoreFileList(RECOVEREDITS_COLUMNFAMILY_ARRAY);
        Assert.assertTrue((boolean)storeFiles.isEmpty());
        region.close();
        Path regionDir = FSUtils.getRegionDirFromRootDir((Path)hbaseRootDir, (RegionInfo)hri);
        Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regionDir);
        Path destination = new Path(recoveredEditsDir, RECOVEREDEDITS_PATH.getName());
        fs.copyToLocalFile(RECOVEREDEDITS_PATH, destination);
        Assert.assertTrue((boolean)fs.exists(destination));
        region = HRegion.openHRegion((HRegion)region, null);
        Assert.assertEquals((Object)encodedRegionName, (Object)region.getRegionInfo().getEncodedName());
        storeFiles = region.getStoreFileList(RECOVEREDITS_COLUMNFAMILY_ARRAY);
        if (policy == MemoryCompactionPolicy.EAGER || policy == MemoryCompactionPolicy.ADAPTIVE) {
            Assert.assertTrue((String)("Files count=" + storeFiles.size()), (storeFiles.size() >= 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Files count=" + storeFiles.size()), (storeFiles.size() > 10 ? 1 : 0) != 0);
        }
        int count = TestRecoveredEdits.verifyAllEditsMadeItIn(fs, conf, RECOVEREDEDITS_PATH, region);
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        LOG.info("Checked " + count + " edits made it in");
    }

    public static int verifyAllEditsMadeItIn(FileSystem fs, Configuration conf, Path edits, HRegion region) throws IOException {
        Object entry;
        int count = 0;
        ArrayList<Cell> walCells = new ArrayList<Cell>();
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)fs, (Path)edits, (Configuration)conf);){
            while ((entry = reader.next()) != null) {
                WALKeyImpl key = entry.getKey();
                WALEdit val = entry.getEdit();
                ++count;
                if (!Bytes.equals((byte[])key.getEncodedRegionName(), (byte[])region.getRegionInfo().getEncodedNameAsBytes())) continue;
                Cell previous = null;
                for (Cell cell : val.getCells()) {
                    if (WALEdit.isMetaEditFamily((Cell)cell) || previous != null && CellComparatorImpl.COMPARATOR.compareRows(previous, cell) == 0) continue;
                    previous = cell;
                    walCells.add(cell);
                }
            }
        }
        ArrayList regionCells = new ArrayList();
        HRegion.RegionScannerImpl scanner = region.getScanner(new Scan());
        entry = null;
        try {
            ArrayList tmpCells;
            do {
                tmpCells = new ArrayList();
                scanner.nextRaw(tmpCells);
                regionCells.addAll(tmpCells);
            } while (!tmpCells.isEmpty());
        }
        catch (Throwable tmpCells) {
            entry = tmpCells;
            throw tmpCells;
        }
        finally {
            if (scanner != null) {
                if (entry != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable tmpCells) {
                        ((Throwable)entry).addSuppressed(tmpCells);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        Collections.sort(walCells, CellComparatorImpl.COMPARATOR);
        int found = 0;
        int i = 0;
        int j = 0;
        while (i < walCells.size() && j < regionCells.size()) {
            int compareResult = PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)((Cell)walCells.get(i)), (Cell)((Cell)regionCells.get(j)));
            if (compareResult == 0) {
                ++i;
                ++j;
                ++found;
                continue;
            }
            if (compareResult > 0) {
                ++j;
                continue;
            }
            ++i;
        }
        Assert.assertEquals((String)("Only found " + found + " cells in region, but there are " + walCells.size() + " cells in recover edits"), (long)found, (long)walCells.size());
        return count;
    }

    static {
        RECOVEREDEDITS_PATH = new Path(System.getProperty("test.build.classes", "target/test-classes"), "0000000000000016310");
        RECOVEREDEDITS_COLUMNFAMILY = Bytes.toBytes((String)"meta");
        RECOVEREDITS_COLUMNFAMILY_ARRAY = new byte[][]{RECOVEREDEDITS_COLUMNFAMILY};
        RECOVEREDEDITS_CFD = ColumnFamilyDescriptorBuilder.newBuilder((byte[])RECOVEREDEDITS_COLUMNFAMILY).build();
    }
}

