/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hbase.thirdparty.com.google.common.primitives.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestRegionMove {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMove.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    public static Configuration CONF;
    protected static final String F1 = "f1";
    protected TableName tableName;
    protected String method;

    @BeforeClass
    public static void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        CONF = TEST_UTIL.getConfiguration();
        this.method = this.name.getMethodName();
        this.tableName = TableName.valueOf((String)this.method);
    }

    @Test
    public void testDisableAndMove() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        Table t = TEST_UTIL.createMultiRegionTable(this.tableName, org.apache.hadoop.hbase.util.Bytes.toBytes((String)F1), 10);
        TEST_UTIL.waitUntilAllRegionsAssigned(this.tableName);
        for (RegionInfo regionInfo2 : admin.getRegions(this.tableName)) {
            byte[] startKey = regionInfo2.getStartKey();
            byte[] rowKey = Bytes.concat((byte[][])new byte[][]{startKey, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"1")});
            Put p = new Put(rowKey);
            p.addColumn(org.apache.hadoop.hbase.util.Bytes.toBytes((String)F1), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"q1"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"value"));
            t.put(p);
        }
        HRegionServer rs1 = TEST_UTIL.getRSForFirstRegionInTable(this.tableName);
        HRegionServer rs2 = TEST_UTIL.getOtherRegionServer(rs1);
        List regionsOnRS1ForTable = admin.getRegions(rs1.getServerName()).stream().filter(regionInfo -> regionInfo.getTable().equals((Object)this.tableName)).collect(Collectors.toList());
        Assert.assertTrue((String)("Expected to find at least one region for " + this.tableName + " on " + rs1.getServerName() + ", but found none"), (!regionsOnRS1ForTable.isEmpty() ? 1 : 0) != 0);
        RegionInfo regionToMove = (RegionInfo)regionsOnRS1ForTable.get(0);
        admin.unassign(regionToMove.getRegionName(), true);
        try {
            admin.move(regionToMove.getEncodedNameAsBytes(), rs2.getServerName());
            TestCase.fail();
        }
        catch (DoNotRetryRegionException doNotRetryRegionException) {
            // empty catch block
        }
        admin.assign(regionToMove.getRegionName());
        admin.disableTable(this.tableName);
        try {
            admin.move(regionToMove.getEncodedNameAsBytes(), rs2.getServerName());
            TestCase.fail();
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }
}

