/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestFSWALEntry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSWALEntry.class);

    @Test
    public void testCollectFamilies() {
        byte[] family0 = Bytes.toBytes((String)"family0");
        byte[] family1 = Bytes.toBytes((String)"family1");
        byte[] family2 = Bytes.toBytes((String)"family2");
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Assert.assertEquals((long)0L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(CellUtil.createCell((byte[])family0, (byte[])family0, (byte[])family0));
        Assert.assertEquals((long)1L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(CellUtil.createCell((byte[])family1, (byte[])family1, (byte[])family1));
        Assert.assertEquals((long)2L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(CellUtil.createCell((byte[])family0, (byte[])family0, (byte[])family0));
        cells.add(CellUtil.createCell((byte[])family1, (byte[])family1, (byte[])family1));
        Assert.assertEquals((long)2L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(CellUtil.createCell((byte[])family2, (byte[])family2, (byte[])family2));
        Assert.assertEquals((long)3L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(CellUtil.createCell((byte[])WALEdit.METAFAMILY, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.METAFAMILY));
        Assert.assertEquals((long)3L, (long)FSWALEntry.collectFamilies(cells).size());
    }
}

