/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.tool.CanaryTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={MediumTests.class})
public class TestCanaryTool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCanaryTool.class);
    private HBaseTestingUtility testingUtility;
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] COLUMN = Bytes.toBytes((String)"col");
    @Rule
    public TestName name = new TestName();
    @Mock
    Appender mockAppender;

    @Before
    public void setUp() throws Exception {
        this.testingUtility = new HBaseTestingUtility();
        this.testingUtility.startMiniCluster();
        LogManager.getRootLogger().addAppender(this.mockAppender);
    }

    @After
    public void tearDown() throws Exception {
        this.testingUtility.shutdownMiniCluster();
        LogManager.getRootLogger().removeAppender(this.mockAppender);
    }

    @Test
    public void testBasicZookeeperCanaryWorks() throws Exception {
        String[] args = new String[]{"-t", "10000", "-zookeeper"};
        this.testZookeeperCanaryWithArgs(args);
    }

    @Test
    public void testZookeeperCanaryPermittedFailuresArgumentWorks() throws Exception {
        String[] args = new String[]{"-t", "10000", "-zookeeper", "-treatFailureAsError", "-permittedZookeeperFailures", "1"};
        this.testZookeeperCanaryWithArgs(args);
    }

    @Test
    public void testBasicCanaryWorks() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        for (int i = 0; i < 1000; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.addColumn(FAMILY, COLUMN, iBytes);
            table.put(p);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        String[] args = new String[]{"-writeSniffing", "-t", "10000", tableName.getNameAsString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        Assert.assertEquals((String)"verify no read error count", (long)0L, (long)canary.getReadFailures().size());
        Assert.assertEquals((String)"verify no write error count", (long)0L, (long)canary.getWriteFailures().size());
        ((CanaryTool.RegionStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishReadTiming((ServerName)Matchers.isA(ServerName.class), (RegionInfo)Matchers.isA(RegionInfo.class), (ColumnFamilyDescriptor)Matchers.isA(ColumnFamilyDescriptor.class), Matchers.anyLong());
    }

    @Test
    public void testCanaryRegionTaskReadAllCF() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = this.testingUtility.createTable(tableName, (byte[][])new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2")});
        for (int i = 0; i < 1000; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.addColumn(Bytes.toBytes((String)"f1"), COLUMN, iBytes);
            p.addColumn(Bytes.toBytes((String)"f2"), COLUMN, iBytes);
            table.put(p);
        }
        Configuration configuration = HBaseConfiguration.create((Configuration)this.testingUtility.getConfiguration());
        String[] args = new String[]{"-t", "10000", "testCanaryRegionTaskReadAllCF"};
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        for (boolean readAllCF : new boolean[]{true, false}) {
            CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
            CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
            configuration.setBoolean("hbase.canary.read.all.column.famliy", readAllCF);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)configuration, (Tool)canary, (String[])args));
            int expectedReadCount = readAllCF ? 2 * sink.getTotalExpectedRegions() : sink.getTotalExpectedRegions();
            Assert.assertEquals((String)"canary region success count should equal total expected read count", (long)expectedReadCount, (long)sink.getReadSuccessCount());
            Map regionMap = sink.getRegionMap();
            Assert.assertFalse((String)"verify region map has size > 0", (boolean)regionMap.isEmpty());
            for (String regionName : regionMap.keySet()) {
                for (CanaryTool.RegionTaskResult res : (List)regionMap.get(regionName)) {
                    Assert.assertNotNull((String)"verify getRegionNameAsString()", (Object)regionName);
                    Assert.assertNotNull((String)"verify getRegionInfo()", (Object)res.getRegionInfo());
                    Assert.assertNotNull((String)"verify getTableName()", (Object)res.getTableName());
                    Assert.assertNotNull((String)"verify getTableNameAsString()", (Object)res.getTableNameAsString());
                    Assert.assertNotNull((String)"verify getServerName()", (Object)res.getServerName());
                    Assert.assertNotNull((String)"verify getServerNameAsString()", (Object)res.getServerNameAsString());
                    Assert.assertNotNull((String)"verify getColumnFamily()", (Object)res.getColumnFamily());
                    Assert.assertNotNull((String)"verify getColumnFamilyNameAsString()", (Object)res.getColumnFamilyNameAsString());
                    Assert.assertTrue((String)("read from region " + regionName + " succeeded"), (boolean)res.isReadSuccess());
                    Assert.assertTrue((String)"read took some time", (res.getReadLatency() > -1L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testCanaryRegionTaskResult() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCanaryRegionTaskResult");
        Table table = this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        for (int i = 0; i < 1000; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.addColumn(FAMILY, COLUMN, iBytes);
            table.put(p);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        String[] args = new String[]{"-writeSniffing", "-t", "10000", "testCanaryRegionTaskResult"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        Assert.assertTrue((String)"canary should expect to scan at least 1 region", (sink.getTotalExpectedRegions() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"there should be no read failures", (sink.getReadFailureCount() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"there should be no write failures", (sink.getWriteFailureCount() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"verify read success count > 0", (sink.getReadSuccessCount() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"verify write success count > 0", (sink.getWriteSuccessCount() > 0L ? 1 : 0) != 0);
        ((CanaryTool.RegionStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishReadTiming((ServerName)Matchers.isA(ServerName.class), (RegionInfo)Matchers.isA(RegionInfo.class), (ColumnFamilyDescriptor)Matchers.isA(ColumnFamilyDescriptor.class), Matchers.anyLong());
        ((CanaryTool.RegionStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishWriteTiming((ServerName)Matchers.isA(ServerName.class), (RegionInfo)Matchers.isA(RegionInfo.class), (ColumnFamilyDescriptor)Matchers.isA(ColumnFamilyDescriptor.class), Matchers.anyLong());
        Assert.assertEquals((String)"canary region success count should equal total expected regions", (long)(sink.getReadSuccessCount() + sink.getWriteSuccessCount()), (long)sink.getTotalExpectedRegions());
        Map regionMap = sink.getRegionMap();
        Assert.assertFalse((String)"verify region map has size > 0", (boolean)regionMap.isEmpty());
        for (String regionName : regionMap.keySet()) {
            for (CanaryTool.RegionTaskResult res : (List)regionMap.get(regionName)) {
                Assert.assertNotNull((String)"verify getRegionNameAsString()", (Object)regionName);
                Assert.assertNotNull((String)"verify getRegionInfo()", (Object)res.getRegionInfo());
                Assert.assertNotNull((String)"verify getTableName()", (Object)res.getTableName());
                Assert.assertNotNull((String)"verify getTableNameAsString()", (Object)res.getTableNameAsString());
                Assert.assertNotNull((String)"verify getServerName()", (Object)res.getServerName());
                Assert.assertNotNull((String)"verify getServerNameAsString()", (Object)res.getServerNameAsString());
                Assert.assertNotNull((String)"verify getColumnFamily()", (Object)res.getColumnFamily());
                Assert.assertNotNull((String)"verify getColumnFamilyNameAsString()", (Object)res.getColumnFamilyNameAsString());
                if (regionName.contains(CanaryTool.DEFAULT_WRITE_TABLE_NAME.getNameAsString())) {
                    Assert.assertTrue((String)("write to region " + regionName + " succeeded"), (boolean)res.isWriteSuccess());
                    Assert.assertTrue((String)"write took some time", (res.getWriteLatency() > -1L ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)("read from region " + regionName + " succeeded"), (boolean)res.isReadSuccess());
                Assert.assertTrue((String)"read took some time", (res.getReadLatency() > -1L ? 1 : 0) != 0);
            }
        }
    }

    @Ignore
    @Test
    public void testReadTableTimeouts() throws Exception {
        TableName[] tableNames = new TableName[]{TableName.valueOf((String)(this.name.getMethodName() + "1")), TableName.valueOf((String)(this.name.getMethodName() + "2"))};
        for (int j = 0; j < 2; ++j) {
            Table table = this.testingUtility.createTable(tableNames[j], (byte[][])new byte[][]{FAMILY});
            for (int i = 0; i < 10; ++i) {
                byte[] iBytes = Bytes.toBytes((int)(i + j));
                Put p = new Put(iBytes);
                p.addColumn(FAMILY, COLUMN, iBytes);
                table.put(p);
            }
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        String configuredTimeoutStr = tableNames[0].getNameAsString() + "=" + Long.MAX_VALUE + "," + tableNames[1].getNameAsString() + "=0";
        String[] args = new String[]{"-readTableTimeouts", configuredTimeoutStr, this.name.getMethodName() + "1", this.name.getMethodName() + "2"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        ((CanaryTool.RegionStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.times((int)tableNames.length))).initializeAndGetReadLatencyForTable((String)Matchers.isA(String.class));
        for (int i = 0; i < 2; ++i) {
            Assert.assertNotEquals((String)"verify non-null read latency", null, sink.getReadLatencyMap().get(tableNames[i].getNameAsString()));
            Assert.assertNotEquals((String)"verify non-zero read latency", (Object)0L, sink.getReadLatencyMap().get(tableNames[i].getNameAsString()));
        }
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).doAppend((LoggingEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(LoggingEvent argument) {
                return argument.getRenderedMessage().contains("exceeded the configured read timeout.");
            }
        }));
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)2))).doAppend((LoggingEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(LoggingEvent argument) {
                return argument.getRenderedMessage().contains("Configured read timeout");
            }
        }));
    }

    @Test
    public void testWriteTableTimeout() throws Exception {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        String[] args = new String[]{"-writeSniffing", "-writeTableTimeout", String.valueOf(Long.MAX_VALUE)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        Assert.assertNotEquals((String)"verify non-null write latency", null, (Object)sink.getWriteLatency());
        Assert.assertNotEquals((String)"verify non-zero write latency", (Object)0L, (Object)sink.getWriteLatency());
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).doAppend((LoggingEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(LoggingEvent argument) {
                return argument.getRenderedMessage().contains("Configured write timeout");
            }
        }));
    }

    @Test
    public void testRegionserverNoRegions() throws Exception {
        this.runRegionserverCanary();
        ((Appender)Mockito.verify((Object)this.mockAppender)).doAppend((LoggingEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(LoggingEvent argument) {
                return argument.getRenderedMessage().contains("Regionserver not serving any regions");
            }
        }));
    }

    @Test
    public void testRegionserverWithRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        this.runRegionserverCanary();
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.never())).doAppend((LoggingEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(LoggingEvent argument) {
                return argument.getRenderedMessage().contains("Regionserver not serving any regions");
            }
        }));
    }

    @Test
    public void testRawScanConfig() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        for (int i = 0; i < 1000; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.addColumn(FAMILY, COLUMN, iBytes);
            table.put(p);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool.RegionStdOutSink sink = (CanaryTool.RegionStdOutSink)Mockito.spy((Object)new CanaryTool.RegionStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        String[] args = new String[]{"-t", "10000", this.name.getMethodName()};
        Configuration conf = new Configuration(this.testingUtility.getConfiguration());
        conf.setBoolean("hbase.canary.read.raw.enabled", true);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)canary, (String[])args));
        ((CanaryTool.RegionStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishReadTiming((ServerName)Matchers.isA(ServerName.class), (RegionInfo)Matchers.isA(RegionInfo.class), (ColumnFamilyDescriptor)Matchers.isA(ColumnFamilyDescriptor.class), Matchers.anyLong());
        Assert.assertEquals((String)"verify no read error count", (long)0L, (long)canary.getReadFailures().size());
    }

    private void runRegionserverCanary() throws Exception {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)new CanaryTool.RegionServerStdOutSink());
        String[] args = new String[]{"-t", "10000", "-regionserver"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        Assert.assertEquals((String)"verify no read error count", (long)0L, (long)canary.getReadFailures().size());
    }

    private void testZookeeperCanaryWithArgs(String[] args) throws Exception {
        Integer port = (Integer)Iterables.getOnlyElement((Iterable)this.testingUtility.getZkCluster().getClientPortList(), null);
        this.testingUtility.getConfiguration().set("hbase.zookeeper.quorum", "localhost:" + port + "/hbase");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2);
        CanaryTool.ZookeeperStdOutSink sink = (CanaryTool.ZookeeperStdOutSink)Mockito.spy((Object)new CanaryTool.ZookeeperStdOutSink());
        CanaryTool canary = new CanaryTool((ExecutorService)executor, (CanaryTool.Sink)sink);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args));
        String baseZnode = this.testingUtility.getConfiguration().get("zookeeper.znode.parent", "/hbase");
        ((CanaryTool.ZookeeperStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishReadTiming((String)Matchers.eq((Object)baseZnode), (String)Matchers.eq((Object)("localhost:" + port)), Matchers.anyLong());
    }
}

