/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class LogRoller
extends HasThread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LogRoller.class);
    private final ConcurrentMap<WAL, RollController> wals = new ConcurrentHashMap<WAL, RollController>();
    protected final RegionServerServices services;
    private final long rollPeriod;
    private final int threadWakeFrequency;
    private final long checkLowReplicationInterval;
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWAL(final WAL wal) {
        if (this.wals.containsKey(wal)) {
            return;
        }
        LogRoller logRoller = this;
        synchronized (logRoller) {
            if (this.wals.putIfAbsent(wal, new RollController(wal)) == null) {
                wal.registerWALActionsListener(new WALActionsListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void logRollRequested(boolean lowReplicas) {
                        LogRoller logRoller = LogRoller.this;
                        synchronized (logRoller) {
                            RollController controller = LogRoller.this.wals.computeIfAbsent(wal, rc -> new RollController(wal));
                            controller.requestRoll();
                            LogRoller.this.notifyAll();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRollAll() {
        LogRoller logRoller = this;
        synchronized (logRoller) {
            for (RollController controller : this.wals.values()) {
                controller.requestRoll();
            }
            this.notifyAll();
        }
    }

    public LogRoller(RegionServerServices services) {
        super("LogRoller");
        this.services = services;
        this.rollPeriod = this.services.getConfiguration().getLong("hbase.regionserver.logroll.period", 3600000L);
        this.threadWakeFrequency = this.services.getConfiguration().getInt("hbase.server.thread.wakefrequency", 10000);
        this.checkLowReplicationInterval = this.services.getConfiguration().getLong("hbase.regionserver.hlog.check.lowreplication.interval", 30000L);
    }

    private void checkLowReplication(long now) {
        try {
            for (Map.Entry entry : this.wals.entrySet()) {
                WAL wal = (WAL)entry.getKey();
                boolean needRollAlready = ((RollController)entry.getValue()).needsRoll(now);
                if (needRollAlready || !(wal instanceof AbstractFSWAL)) continue;
                ((AbstractFSWAL)wal).checkLogLowReplication(this.checkLowReplicationInterval);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed checking low replication", e);
        }
    }

    private void abort(String reason, Throwable cause) {
        for (WAL wal : this.wals.keySet()) {
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.warn("Failed to shutdown wal", (Throwable)e);
            }
        }
        this.services.abort(reason, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            long now = System.currentTimeMillis();
            this.checkLowReplication(now);
            LogRoller logRoller = this;
            synchronized (logRoller) {
                if (this.wals.values().stream().noneMatch(rc -> rc.needsRoll(now))) {
                    try {
                        this.wait(this.threadWakeFrequency);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            try {
                for (Map.Entry entry : this.wals.entrySet()) {
                    byte[][] regionsToFlush;
                    WAL wal = (WAL)entry.getKey();
                    RollController controller = (RollController)entry.getValue();
                    if (controller.isRollRequested()) {
                        LOG.debug("WAL {} roll requested", (Object)wal);
                    } else {
                        if (!controller.needsPeriodicRoll(now)) continue;
                        LOG.debug("WAL {} roll period {} ms elapsed", (Object)wal, (Object)this.rollPeriod);
                    }
                    if ((regionsToFlush = controller.rollWal(now)) == null) continue;
                    for (byte[] r : regionsToFlush) {
                        this.scheduleFlush(Bytes.toString((byte[])r));
                    }
                }
            }
            catch (ConnectException | FailedLogCloseException e) {
                this.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                this.abort("IOE in log roller", ex instanceof RemoteException ? ((RemoteException)((Object)ex)).unwrapRemoteException() : ex);
            }
            catch (Exception ex) {
                LOG.error("Log rolling failed", (Throwable)ex);
                this.abort("Log rolling failed", ex);
            }
        }
        LOG.info("LogRoller exiting.");
    }

    private void scheduleFlush(String encodedRegionName) {
        HRegion r = (HRegion)this.services.getRegion(encodedRegionName);
        if (r == null) {
            LOG.warn("Failed to schedule flush of {}, because it is not online on us", (Object)encodedRegionName);
            return;
        }
        FlushRequester requester = this.services.getFlushRequester();
        if (requester == null) {
            LOG.warn("Failed to schedule flush of {}, region={}, because FlushRequester is null", (Object)encodedRegionName, (Object)r);
            return;
        }
        requester.requestFlush(r, true, FlushLifeCycleTracker.DUMMY);
    }

    @VisibleForTesting
    public boolean walRollFinished() {
        return this.wals.values().stream().noneMatch(rc -> rc.needsRoll(System.currentTimeMillis()));
    }

    @Override
    public void close() {
        this.running = false;
        this.interrupt();
    }

    protected class RollController {
        private final WAL wal;
        private final AtomicBoolean rollRequest;
        private long lastRollTime;

        RollController(WAL wal) {
            this.wal = wal;
            this.rollRequest = new AtomicBoolean(false);
            this.lastRollTime = System.currentTimeMillis();
        }

        public void requestRoll() {
            this.rollRequest.set(true);
        }

        public byte[][] rollWal(long now) throws IOException {
            this.lastRollTime = now;
            this.rollRequest.set(false);
            return this.wal.rollWriter(true);
        }

        public boolean isRollRequested() {
            return this.rollRequest.get();
        }

        public boolean needsPeriodicRoll(long now) {
            return now - this.lastRollTime > LogRoller.this.rollPeriod;
        }

        public boolean needsRoll(long now) {
            return this.isRollRequested() || this.needsPeriodicRoll(now);
        }
    }
}

