/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslServer;
import javax.servlet.Servlet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.jetty.SslSelectChannelConnectorSecure;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.HThreadedSelectorServerArgs;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.IncrementCoalescer;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.ThriftHttpServlet;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TAppend;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRegionInfo;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.thrift.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConnectionCache;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

@InterfaceAudience.Private
public class ThriftServerRunner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(ThriftServerRunner.class);
    static final String SERVER_TYPE_CONF_KEY = "hbase.regionserver.thrift.server.type";
    static final String BIND_CONF_KEY = "hbase.regionserver.thrift.ipaddress";
    static final String COMPACT_CONF_KEY = "hbase.regionserver.thrift.compact";
    static final String FRAMED_CONF_KEY = "hbase.regionserver.thrift.framed";
    static final String MAX_FRAME_SIZE_CONF_KEY = "hbase.regionserver.thrift.framed.max_frame_size_in_mb";
    static final String PORT_CONF_KEY = "hbase.regionserver.thrift.port";
    static final String COALESCE_INC_KEY = "hbase.regionserver.thrift.coalesceIncrement";
    static final String USE_HTTP_CONF_KEY = "hbase.regionserver.thrift.http";
    static final String HTTP_MIN_THREADS = "hbase.thrift.http_threads.min";
    static final String HTTP_MAX_THREADS = "hbase.thrift.http_threads.max";
    static final String THRIFT_SSL_ENABLED = "hbase.thrift.ssl.enabled";
    static final String THRIFT_SSL_KEYSTORE_STORE = "hbase.thrift.ssl.keystore.store";
    static final String THRIFT_SSL_KEYSTORE_PASSWORD = "hbase.thrift.ssl.keystore.password";
    static final String THRIFT_SSL_KEYSTORE_KEYPASSWORD = "hbase.thrift.ssl.keystore.keypassword";
    static final String THRIFT_QOP_KEY = "hbase.thrift.security.qop";
    private static final String DEFAULT_BIND_ADDR = "0.0.0.0";
    public static final int DEFAULT_LISTEN_PORT = 9090;
    public static final int HREGION_VERSION = 1;
    static final String THRIFT_SUPPORT_PROXYUSER = "hbase.thrift.support.proxyuser";
    private final int listenPort;
    private Configuration conf;
    volatile TServer tserver;
    volatile Server httpServer;
    private final Hbase.Iface handler;
    private final ThriftMetrics metrics;
    private final HBaseHandler hbaseHandler;
    private final UserGroupInformation realUser;
    private final String qop;
    private String host;
    private final boolean securityEnabled;
    private final boolean doAsEnabled;

    public ThriftServerRunner(Configuration conf) throws IOException {
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        boolean bl = this.securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (this.securityEnabled) {
            this.host = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.thrift.dns.interface", "default"), (String)conf.get("hbase.thrift.dns.nameserver", "default")));
            userProvider.login("hbase.thrift.keytab.file", "hbase.thrift.kerberos.principal", this.host);
        }
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.listenPort = conf.getInt(PORT_CONF_KEY, 9090);
        this.metrics = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.ONE);
        this.hbaseHandler = new HBaseHandler(conf, userProvider);
        this.hbaseHandler.initMetrics(this.metrics);
        this.handler = HbaseHandlerMetricsProxy.newInstance(this.hbaseHandler, this.metrics, conf);
        this.realUser = userProvider.getCurrent().getUGI();
        this.qop = conf.get(THRIFT_QOP_KEY);
        this.doAsEnabled = conf.getBoolean(THRIFT_SUPPORT_PROXYUSER, false);
        if (this.doAsEnabled && !conf.getBoolean(USE_HTTP_CONF_KEY, false)) {
            LOG.warn((Object)"Fail to enable the doAs feature. hbase.regionserver.thrift.http is not configured ");
        }
        if (this.qop != null) {
            if (!(this.qop.equals("auth") || this.qop.equals("auth-int") || this.qop.equals("auth-conf"))) {
                throw new IOException("Invalid hbase.thrift.security.qop: " + this.qop + ", it must be 'auth', 'auth-int', or 'auth-conf'");
            }
            if (!this.securityEnabled) {
                throw new IOException("Thrift server must run in secure mode to support authentication");
            }
        }
    }

    @Override
    public void run() {
        this.realUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (ThriftServerRunner.this.conf.getBoolean(ThriftServerRunner.USE_HTTP_CONF_KEY, false)) {
                        ThriftServerRunner.this.setupHTTPServer();
                        ThriftServerRunner.this.httpServer.start();
                        ThriftServerRunner.this.httpServer.join();
                    } else {
                        ThriftServerRunner.this.setupServer();
                        ThriftServerRunner.this.tserver.serve();
                    }
                }
                catch (Exception e) {
                    LOG.fatal((Object)"Cannot run ThriftServer", (Throwable)e);
                    System.exit(-1);
                }
                return null;
            }
        });
    }

    public void shutdown() {
        if (this.tserver != null) {
            this.tserver.stop();
            this.tserver = null;
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
                this.httpServer = null;
            }
            catch (Exception e) {
                LOG.error((Object)("Problem encountered in shutting down HTTP server " + e.getCause()));
            }
            this.httpServer = null;
        }
    }

    private void setupHTTPServer() throws IOException {
        TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
        Hbase.Processor<Hbase.Iface> processor = new Hbase.Processor<Hbase.Iface>(this.handler);
        ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet(processor, (TProtocolFactory)protocolFactory, this.realUser, this.conf, this.hbaseHandler, this.securityEnabled, this.doAsEnabled);
        this.httpServer = new Server();
        Context context = new Context((HandlerContainer)this.httpServer, "/", 1);
        context.setContextPath("/");
        String httpPath = "/*";
        this.httpServer.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
        SelectChannelConnector connector = new SelectChannelConnector();
        if (this.conf.getBoolean(THRIFT_SSL_ENABLED, false)) {
            SslSelectChannelConnectorSecure sslConnector = new SslSelectChannelConnectorSecure();
            String keystore = this.conf.get(THRIFT_SSL_KEYSTORE_STORE);
            String password = HBaseConfiguration.getPassword((Configuration)this.conf, (String)THRIFT_SSL_KEYSTORE_PASSWORD, null);
            String keyPassword = HBaseConfiguration.getPassword((Configuration)this.conf, (String)THRIFT_SSL_KEYSTORE_KEYPASSWORD, (String)password);
            sslConnector.setKeystore(keystore);
            sslConnector.setPassword(password);
            sslConnector.setKeyPassword(keyPassword);
            connector = sslConnector;
        }
        String host = this.getBindAddress(this.conf).getHostAddress();
        connector.setPort(this.listenPort);
        connector.setHost(host);
        connector.setHeaderBufferSize(65536);
        this.httpServer.addConnector((Connector)connector);
        if (this.doAsEnabled) {
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        }
        int minThreads = this.conf.getInt(HTTP_MIN_THREADS, 2);
        int maxThreads = this.conf.getInt(HTTP_MAX_THREADS, 100);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads);
        threadPool.setMinThreads(minThreads);
        this.httpServer.setThreadPool((ThreadPool)threadPool);
        this.httpServer.setSendServerVersion(false);
        this.httpServer.setSendDateHeader(false);
        this.httpServer.setStopAtShutdown(true);
        LOG.info((Object)("Starting Thrift HTTP Server on " + Integer.toString(this.listenPort)));
    }

    private void setupServer() throws Exception {
        Object serverArgs;
        TNonblockingServerSocket serverTransport;
        InetAddress listenAddress;
        TTransportFactory transportFactory;
        TCompactProtocol.Factory protocolFactory;
        if (this.conf.getBoolean(COMPACT_CONF_KEY, false)) {
            LOG.debug((Object)"Using compact protocol");
            protocolFactory = new TCompactProtocol.Factory();
        } else {
            LOG.debug((Object)"Using binary protocol");
            protocolFactory = new TBinaryProtocol.Factory();
        }
        final Hbase.Processor<Hbase.Iface> p = new Hbase.Processor<Hbase.Iface>(this.handler);
        ImplType implType = ImplType.getServerImpl(this.conf);
        TProcessor processor = p;
        if (this.conf.getBoolean(FRAMED_CONF_KEY, false) || implType.isAlwaysFramed) {
            if (this.qop != null) {
                throw new RuntimeException("Thrift server authentication doesn't work with framed transport yet");
            }
            transportFactory = new TFramedTransport.Factory(this.conf.getInt(MAX_FRAME_SIZE_CONF_KEY, 2) * 1024 * 1024);
            LOG.debug((Object)"Using framed transport");
        } else if (this.qop == null) {
            transportFactory = new TTransportFactory();
        } else {
            String name = SecurityUtil.getUserFromPrincipal((String)this.conf.get("hbase.thrift.kerberos.principal"));
            HashMap<String, String> saslProperties = new HashMap<String, String>();
            saslProperties.put("javax.security.sasl.qop", this.qop);
            TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
            saslFactory.addServerDefinition("GSSAPI", name, this.host, saslProperties, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler(){

                public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                    AuthorizeCallback ac = null;
                    for (Callback callback : callbacks) {
                        if (!(callback instanceof AuthorizeCallback)) {
                            throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                        }
                        ac = (AuthorizeCallback)callback;
                    }
                    if (ac != null) {
                        String authzid;
                        String authid = ac.getAuthenticationID();
                        if (!authid.equals(authzid = ac.getAuthorizationID())) {
                            ac.setAuthorized(false);
                        } else {
                            ac.setAuthorized(true);
                            String userName = SecurityUtil.getUserFromPrincipal((String)authzid);
                            LOG.info((Object)("Effective user: " + userName));
                            ac.setAuthorizedID(userName);
                        }
                    }
                }
            });
            transportFactory = saslFactory;
            processor = new TProcessor(){

                public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
                    TSaslServerTransport saslServerTransport = (TSaslServerTransport)inProt.getTransport();
                    SaslServer saslServer = saslServerTransport.getSaslServer();
                    String principal = saslServer.getAuthorizationID();
                    ThriftServerRunner.this.hbaseHandler.setEffectiveUser(principal);
                    return p.process(inProt, outProt);
                }
            };
        }
        if (this.conf.get(BIND_CONF_KEY) != null && !implType.canSpecifyBindIP) {
            LOG.error((Object)("Server types " + Joiner.on((String)", ").join(ImplType.serversThatCannotSpecifyBindIP()) + " don't support IP " + "address binding at the moment. See " + "https://issues.apache.org/jira/browse/HBASE-2155 for details."));
            throw new RuntimeException("-hbase.regionserver.thrift.ipaddress not supported with " + (Object)((Object)implType));
        }
        if (implType == ImplType.HS_HA || implType == ImplType.NONBLOCKING || implType == ImplType.THREADED_SELECTOR) {
            listenAddress = this.getBindAddress(this.conf);
            serverTransport = new TNonblockingServerSocket(new InetSocketAddress(listenAddress, this.listenPort));
            if (implType == ImplType.NONBLOCKING) {
                serverArgs = new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport);
                ((TNonblockingServer.Args)((TNonblockingServer.Args)serverArgs.processor(processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
            } else if (implType == ImplType.HS_HA) {
                serverArgs = new THsHaServer.Args((TNonblockingServerTransport)serverTransport);
                CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), this.metrics);
                ExecutorService executorService = this.createExecutor(callQueue, serverArgs.getWorkerThreads());
                ((THsHaServer.Args)((THsHaServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new THsHaServer((THsHaServer.Args)serverArgs);
            } else {
                serverArgs = new HThreadedSelectorServerArgs((TNonblockingServerTransport)serverTransport, this.conf);
                CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), this.metrics);
                ExecutorService executorService = this.createExecutor(callQueue, serverArgs.getWorkerThreads());
                ((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new TThreadedSelectorServer((TThreadedSelectorServer.Args)serverArgs);
            }
            LOG.info((Object)("starting HBase " + implType.simpleClassName() + " server on " + Integer.toString(this.listenPort)));
        } else if (implType == ImplType.THREAD_POOL) {
            listenAddress = this.getBindAddress(this.conf);
            serverTransport = new TServerSocket(new InetSocketAddress(listenAddress, this.listenPort));
            serverArgs = new TBoundedThreadPoolServer.Args((TServerTransport)serverTransport, this.conf);
            ((TThreadPoolServer.Args)((TThreadPoolServer.Args)serverArgs.processor(processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
            LOG.info((Object)("starting " + ImplType.THREAD_POOL.simpleClassName() + " on " + listenAddress + ":" + Integer.toString(this.listenPort) + "; " + serverArgs));
            TBoundedThreadPoolServer tserver = new TBoundedThreadPoolServer((TBoundedThreadPoolServer.Args)((Object)serverArgs), this.metrics);
            this.tserver = tserver;
        } else {
            throw new AssertionError((Object)("Unsupported Thrift server implementation: " + implType.simpleClassName()));
        }
        if (this.tserver.getClass() != implType.serverClass) {
            throw new AssertionError((Object)("Expected to create Thrift server class " + implType.serverClass.getName() + " but got " + this.tserver.getClass().getName()));
        }
        ThriftServerRunner.registerFilters(this.conf);
    }

    ExecutorService createExecutor(BlockingQueue<Runnable> callQueue, int workerThreads) {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift-worker-%d");
        return new ThreadPoolExecutor(workerThreads, workerThreads, Long.MAX_VALUE, TimeUnit.SECONDS, callQueue, tfb.build());
    }

    private InetAddress getBindAddress(Configuration conf) throws UnknownHostException {
        String bindAddressStr = conf.get(BIND_CONF_KEY, DEFAULT_BIND_ADDR);
        return InetAddress.getByName(bindAddressStr);
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary((byte[])Bytes.getBytes((ByteBuffer)entry.getKey()));
            byte[] value = Bytes.getBytes((ByteBuffer)entry.getValue());
            op.setAttribute(name, value);
        }
    }

    public static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        if (filters != null) {
            for (String filterClass : filters) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    LOG.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter((String)filterPart[0], (String)filterPart[1]);
            }
        }
    }

    public static class HBaseHandler
    implements Hbase.Iface {
        protected Configuration conf;
        protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
        protected int nextScannerId = 0;
        protected HashMap<Integer, ResultScannerWrapper> scannerMap = null;
        private ThriftMetrics metrics = null;
        private final ConnectionCache connectionCache;
        IncrementCoalescer coalescer = null;
        static final String CLEANUP_INTERVAL = "hbase.thrift.connection.cleanup-interval";
        static final String MAX_IDLETIME = "hbase.thrift.connection.max-idletime";

        byte[][] getAllColumns(Table table) throws IOException {
            HColumnDescriptor[] cds = table.getTableDescriptor().getColumnFamilies();
            byte[][] columns = new byte[cds.length][];
            for (int i = 0; i < cds.length; ++i) {
                columns[i] = Bytes.add((byte[])cds[i].getName(), (byte[])KeyValue.COLUMN_FAMILY_DELIM_ARRAY);
            }
            return columns;
        }

        public Table getTable(byte[] tableName) throws IOException {
            String table = Bytes.toString((byte[])tableName);
            return this.connectionCache.getTable(table);
        }

        public Table getTable(ByteBuffer tableName) throws IOException {
            return this.getTable(Bytes.getBytes((ByteBuffer)tableName));
        }

        protected synchronized int addScanner(ResultScanner scanner, boolean sortColumns) {
            int id = this.nextScannerId++;
            ResultScannerWrapper resultScannerWrapper = new ResultScannerWrapper(scanner, sortColumns);
            this.scannerMap.put(id, resultScannerWrapper);
            return id;
        }

        protected synchronized ResultScannerWrapper getScanner(int id) {
            return this.scannerMap.get(id);
        }

        protected synchronized ResultScannerWrapper removeScanner(int id) {
            return this.scannerMap.remove(id);
        }

        protected HBaseHandler(Configuration c, UserProvider userProvider) throws IOException {
            this.conf = c;
            this.scannerMap = new HashMap();
            this.coalescer = new IncrementCoalescer(this);
            int cleanInterval = this.conf.getInt(CLEANUP_INTERVAL, 10000);
            int maxIdleTime = this.conf.getInt(MAX_IDLETIME, 600000);
            this.connectionCache = new ConnectionCache(this.conf, userProvider, cleanInterval, maxIdleTime);
        }

        private Admin getAdmin() throws IOException {
            return this.connectionCache.getAdmin();
        }

        void setEffectiveUser(String effectiveUser) {
            this.connectionCache.setEffectiveUser(effectiveUser);
        }

        @Override
        public void enableTable(ByteBuffer tableName) throws IOError {
            try {
                this.getAdmin().enableTable(HBaseHandler.getTableName(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public void disableTable(ByteBuffer tableName) throws IOError {
            try {
                this.getAdmin().disableTable(HBaseHandler.getTableName(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public boolean isTableEnabled(ByteBuffer tableName) throws IOError {
            try {
                return this.connectionCache.getAdmin().isTableEnabled(HBaseHandler.getTableName(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public void compact(ByteBuffer tableNameOrRegionName) throws IOError {
            try {
                ((HBaseAdmin)this.getAdmin()).compact(Bytes.getBytes((ByteBuffer)tableNameOrRegionName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public void majorCompact(ByteBuffer tableNameOrRegionName) throws IOError {
            try {
                ((HBaseAdmin)this.getAdmin()).majorCompact(Bytes.getBytes((ByteBuffer)tableNameOrRegionName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public List<ByteBuffer> getTableNames() throws IOError {
            try {
                TableName[] tableNames = this.getAdmin().listTableNames();
                ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(tableNames.length);
                for (int i = 0; i < tableNames.length; ++i) {
                    list.add(ByteBuffer.wrap(tableNames[i].getName()));
                }
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<TRegionInfo> getTableRegions(ByteBuffer tableName) throws IOError {
            try (RegionLocator locator = this.connectionCache.getRegionLocator(Bytes.getBytes((ByteBuffer)tableName));){
                List regionLocations = locator.getAllRegionLocations();
                ArrayList<TRegionInfo> results = new ArrayList<TRegionInfo>();
                for (HRegionLocation regionLocation : regionLocations) {
                    HRegionInfo info = regionLocation.getRegionInfo();
                    ServerName serverName = regionLocation.getServerName();
                    TRegionInfo region = new TRegionInfo();
                    region.serverName = ByteBuffer.wrap(Bytes.toBytes((String)serverName.getHostname()));
                    region.port = serverName.getPort();
                    region.startKey = ByteBuffer.wrap(info.getStartKey());
                    region.endKey = ByteBuffer.wrap(info.getEndKey());
                    region.id = info.getRegionId();
                    region.name = ByteBuffer.wrap(info.getRegionName());
                    region.version = info.getVersion();
                    results.add(region);
                }
                ArrayList<TRegionInfo> arrayList = results;
                return arrayList;
            }
            catch (TableNotFoundException e) {
                return Collections.emptyList();
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        @Deprecated
        public List<TCell> get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            if (famAndQf.length == 1) {
                return this.get(tableName, row, famAndQf[0], null, attributes);
            }
            if (famAndQf.length == 2) {
                return this.get(tableName, row, famAndQf[0], famAndQf[1], attributes);
            }
            throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
        }

        protected List<TCell> get(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)get2, attributes);
                if (qualifier == null) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                Result result = table.get(get2);
                List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            if (famAndQf.length == 1) {
                return this.getVer(tableName, row, famAndQf[0], null, numVersions, attributes);
            }
            if (famAndQf.length == 2) {
                return this.getVer(tableName, row, famAndQf[0], famAndQf[1], numVersions, attributes);
            }
            throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
        }

        public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)get2, attributes);
                if (null == qualifier) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            if (famAndQf.length == 1) {
                return this.getVerTs(tableName, row, famAndQf[0], null, timestamp, numVersions, attributes);
            }
            if (famAndQf.length == 2) {
                return this.getVerTs(tableName, row, famAndQf[0], famAndQf[1], timestamp, numVersions, attributes);
            }
            throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
        }

        protected List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)get2, attributes);
                if (null == qualifier) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                get2.setTimeRange(0L, timestamp);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public List<TRowResult> getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, columns, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, timestamp, attributes);
        }

        @Override
        public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                if (columns == null) {
                    Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                    ThriftServerRunner.addAttributes((OperationWithAttributes)get2, attributes);
                    get2.setTimeRange(0L, timestamp);
                    Result result = table.get(get2);
                    List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
                    return list;
                }
                Get get3 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)get3, attributes);
                for (ByteBuffer column : columns) {
                    byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famAndQf.length == 1) {
                        get3.addFamily(famAndQf[0]);
                        continue;
                    }
                    get3.addColumn(famAndQf[0], famAndQf[1]);
                }
                get3.setTimeRange(0L, timestamp);
                Result result = table.get(get3);
                List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public List<TRowResult> getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, columns, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, timestamp, attributes);
        }

        @Override
        public List<TRowResult> getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                ArrayList<Get> gets = new ArrayList<Get>(rows.size());
                table = this.getTable(tableName);
                if (this.metrics != null) {
                    this.metrics.incNumRowKeysInBatchGet(rows.size());
                }
                for (ByteBuffer row : rows) {
                    Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                    ThriftServerRunner.addAttributes((OperationWithAttributes)get2, attributes);
                    if (columns != null) {
                        for (ByteBuffer column : columns) {
                            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                            if (famAndQf.length == 1) {
                                get2.addFamily(famAndQf[0]);
                                continue;
                            }
                            get2.addColumn(famAndQf[0], famAndQf[1]);
                        }
                    }
                    get2.setTimeRange(0L, timestamp);
                    gets.add(get2);
                }
                Result[] result = table.get(gets);
                List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
                this.closeTable(table);
                return list;
            }
            catch (IOException e) {
                try {
                    this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                    throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeTable(table);
                    throw throwable;
                }
            }
        }

        @Override
        public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            this.deleteAllTs(tableName, row, column, Long.MAX_VALUE, attributes);
        }

        @Override
        public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)delete, attributes);
                byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                if (famAndQf.length == 1) {
                    delete.deleteFamily(famAndQf[0], timestamp);
                } else {
                    delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                }
                table.delete(delete);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            this.deleteAllRowTs(tableName, row, Long.MAX_VALUE, attributes);
        }

        @Override
        public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row), timestamp);
                ThriftServerRunner.addAttributes((OperationWithAttributes)delete, attributes);
                table.delete(delete);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public void createTable(ByteBuffer in_tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists {
            TableName tableName = HBaseHandler.getTableName(in_tableName);
            try {
                if (this.getAdmin().tableExists(tableName)) {
                    throw new AlreadyExists("table name already in use");
                }
                HTableDescriptor desc = new HTableDescriptor(tableName);
                for (ColumnDescriptor col : columnFamilies) {
                    HColumnDescriptor colDesc = ThriftUtilities.colDescFromThrift(col);
                    desc.addFamily(colDesc);
                }
                this.getAdmin().createTable(desc);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        private static TableName getTableName(ByteBuffer buffer) {
            return TableName.valueOf((byte[])Bytes.getBytes((ByteBuffer)buffer));
        }

        @Override
        public void deleteTable(ByteBuffer in_tableName) throws IOError {
            TableName tableName = HBaseHandler.getTableName(in_tableName);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("deleteTable: table=" + tableName));
            }
            try {
                if (!this.getAdmin().tableExists(tableName)) {
                    throw new IOException("table does not exist");
                }
                this.getAdmin().deleteTable(tableName);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
            this.mutateRowTs(tableName, row, mutations, Long.MAX_VALUE, attributes);
        }

        @Override
        public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Put put2 = new Put(Bytes.getBytes((ByteBuffer)row), timestamp);
                ThriftServerRunner.addAttributes((OperationWithAttributes)put2, attributes);
                Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row));
                ThriftServerRunner.addAttributes((OperationWithAttributes)delete, attributes);
                if (this.metrics != null) {
                    this.metrics.incNumRowKeysInBatchMutate(mutations.size());
                }
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)m.column));
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                        } else {
                            delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        }
                        delete.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        this.LOG.warn((Object)"No column qualifier specified. Delete is the only mutation supported over the whole column family.");
                    } else {
                        put2.addImmutable(famAndQf[0], famAndQf[1], m.value != null ? Bytes.getBytes((ByteBuffer)m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    }
                    put2.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                }
                if (!delete.isEmpty()) {
                    table.delete(delete);
                }
                if (!put2.isEmpty()) {
                    table.put(put2);
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
            this.mutateRowsTs(tableName, rowBatches, Long.MAX_VALUE, attributes);
        }

        @Override
        public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
            ArrayList<Put> puts = new ArrayList<Put>();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (BatchMutation batch : rowBatches) {
                byte[] row = Bytes.getBytes((ByteBuffer)batch.row);
                List<Mutation> mutations = batch.mutations;
                Delete delete = new Delete(row);
                ThriftServerRunner.addAttributes((OperationWithAttributes)delete, attributes);
                Put put2 = new Put(row, timestamp);
                ThriftServerRunner.addAttributes((OperationWithAttributes)put2, attributes);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)m.column));
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                        } else {
                            delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        }
                        delete.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        this.LOG.warn((Object)"No column qualifier specified. Delete is the only mutation supported over the whole column family.");
                    }
                    if (famAndQf.length != 2) {
                        throw new IllegalArgumentException("Invalid famAndQf provided.");
                    }
                    put2.addImmutable(famAndQf[0], famAndQf[1], m.value != null ? Bytes.getBytes((ByteBuffer)m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    put2.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                }
                if (!delete.isEmpty()) {
                    deletes.add(delete);
                }
                if (put2.isEmpty()) continue;
                puts.add(put2);
            }
            Table table = null;
            try {
                table = this.getTable(tableName);
                if (!puts.isEmpty()) {
                    table.put(puts);
                }
                if (!deletes.isEmpty()) {
                    table.delete(deletes);
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        @Deprecated
        public long atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long amount) throws IOError, IllegalArgument, TException {
            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            if (famAndQf.length == 1) {
                return this.atomicIncrement(tableName, row, famAndQf[0], HConstants.EMPTY_BYTE_ARRAY, amount);
            }
            return this.atomicIncrement(tableName, row, famAndQf[0], famAndQf[1], amount);
        }

        protected long atomicIncrement(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long amount) throws IOError, IllegalArgument, TException {
            Table table = null;
            try {
                table = this.getTable(tableName);
                long l = table.incrementColumnValue(Bytes.getBytes((ByteBuffer)row), family, qualifier, amount);
                return l;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public void scannerClose(int id) throws IOError, IllegalArgument {
            this.LOG.debug((Object)("scannerClose: id=" + id));
            ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
            if (resultScannerWrapper == null) {
                String message = "scanner ID is invalid";
                this.LOG.warn((Object)message);
                throw new IllegalArgument("scanner ID is invalid");
            }
            resultScannerWrapper.getScanner().close();
            this.removeScanner(id);
        }

        @Override
        public List<TRowResult> scannerGetList(int id, int nbRows) throws IllegalArgument, IOError {
            this.LOG.debug((Object)("scannerGetList: id=" + id));
            ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
            if (null == resultScannerWrapper) {
                String message = "scanner ID is invalid";
                this.LOG.warn((Object)message);
                throw new IllegalArgument("scanner ID is invalid");
            }
            Result[] results = null;
            try {
                results = resultScannerWrapper.getScanner().next(nbRows);
                if (null == results) {
                    return new ArrayList<TRowResult>();
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            return ThriftUtilities.rowResultFromHBase(results, resultScannerWrapper.isColumnSorted());
        }

        @Override
        public List<TRowResult> scannerGet(int id) throws IllegalArgument, IOError {
            return this.scannerGetList(id, 1);
        }

        @Override
        public int scannerOpenWithScan(ByteBuffer tableName, TScan tScan, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan();
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                if (tScan.isSetStartRow()) {
                    scan.setStartRow(tScan.getStartRow());
                }
                if (tScan.isSetStopRow()) {
                    scan.setStopRow(tScan.getStopRow());
                }
                if (tScan.isSetTimestamp()) {
                    scan.setTimeRange(0L, tScan.getTimestamp());
                }
                if (tScan.isSetCaching()) {
                    scan.setCaching(tScan.getCaching());
                }
                if (tScan.isSetBatchSize()) {
                    scan.setBatch(tScan.getBatchSize());
                }
                if (tScan.isSetColumns() && tScan.getColumns().size() != 0) {
                    for (ByteBuffer column : tScan.getColumns()) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                if (tScan.isSetFilterString()) {
                    ParseFilter parseFilter = new ParseFilter();
                    scan.setFilter(parseFilter.parseFilterString(tScan.getFilterString()));
                }
                if (tScan.isSetReversed()) {
                    scan.setReversed(tScan.isReversed());
                }
                int n = this.addScanner(table.getScanner(scan), tScan.sortColumns);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public int scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow));
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                int n = this.addScanner(table.getScanner(scan), false);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public int scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow), Bytes.getBytes((ByteBuffer)stopRow));
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                int n = this.addScanner(table.getScanner(scan), false);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public int scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startAndPrefix));
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                WhileMatchFilter f = new WhileMatchFilter((Filter)new PrefixFilter(Bytes.getBytes((ByteBuffer)startAndPrefix)));
                scan.setFilter((Filter)f);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                int n = this.addScanner(table.getScanner(scan), false);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public int scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow));
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                scan.setTimeRange(0L, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                int n = this.addScanner(table.getScanner(scan), false);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public int scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            Table table = null;
            try {
                table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow), Bytes.getBytes((ByteBuffer)stopRow));
                ThriftServerRunner.addAttributes((OperationWithAttributes)scan, attributes);
                scan.setTimeRange(0L, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                scan.setTimeRange(0L, timestamp);
                int n = this.addScanner(table.getScanner(scan), false);
                return n;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public Map<ByteBuffer, ColumnDescriptor> getColumnDescriptors(ByteBuffer tableName) throws IOError, TException {
            Table table = null;
            try {
                TreeMap<ByteBuffer, ColumnDescriptor> columns = new TreeMap<ByteBuffer, ColumnDescriptor>();
                table = this.getTable(tableName);
                HTableDescriptor desc = table.getTableDescriptor();
                for (HColumnDescriptor e : desc.getFamilies()) {
                    ColumnDescriptor col = ThriftUtilities.colDescFromHbase(e);
                    columns.put(col.name, col);
                }
                TreeMap<ByteBuffer, ColumnDescriptor> treeMap = columns;
                this.closeTable(table);
                return treeMap;
            }
            catch (IOException e) {
                try {
                    this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                    throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeTable(table);
                    throw throwable;
                }
            }
        }

        @Override
        @Deprecated
        public List<TCell> getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family) throws IOError {
            try {
                Result result = this.getRowOrBefore(Bytes.getBytes((ByteBuffer)tableName), Bytes.getBytes((ByteBuffer)row), Bytes.getBytes((ByteBuffer)family));
                return ThriftUtilities.cellFromHBase(result.rawCells());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        @Override
        public TRegionInfo getRegionInfo(ByteBuffer searchRow) throws IOError {
            try {
                byte[] row = Bytes.getBytes((ByteBuffer)searchRow);
                Result startRowResult = this.getRowOrBefore(TableName.META_TABLE_NAME.getName(), row, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new IOException("Cannot find row in " + TableName.META_TABLE_NAME + ", row=" + Bytes.toStringBinary((byte[])row));
                }
                HRegionInfo regionInfo = HRegionInfo.getHRegionInfo((Result)startRowResult);
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo REGIONINFO was null or  empty in Meta for row=" + Bytes.toStringBinary((byte[])row));
                }
                TRegionInfo region = new TRegionInfo();
                region.setStartKey(regionInfo.getStartKey());
                region.setEndKey(regionInfo.getEndKey());
                region.id = regionInfo.getRegionId();
                region.setName(regionInfo.getRegionName());
                region.version = regionInfo.getVersion();
                ServerName serverName = HRegionInfo.getServerName((Result)startRowResult);
                if (serverName != null) {
                    region.setServerName(Bytes.toBytes((String)serverName.getHostname()));
                    region.port = serverName.getPort();
                }
                return region;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        private void closeTable(Table table) throws IOError {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (IOException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
        }

        /*
         * Loose catch block
         */
        private Result getRowOrBefore(byte[] tableName, byte[] row, byte[] family) throws IOException {
            Scan scan = new Scan(row);
            scan.setReversed(true);
            scan.addFamily(family);
            scan.setStartRow(row);
            try (Table table = this.getTable(tableName);){
                try (ResultScanner scanner = table.getScanner(scan);){
                    Result result = scanner.next();
                    return result;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }

        private void initMetrics(ThriftMetrics metrics) {
            this.metrics = metrics;
        }

        @Override
        public void increment(TIncrement tincrement) throws IOError, TException {
            if (tincrement.getRow().length == 0 || tincrement.getTable().length == 0) {
                throw new TException("Must supply a table and a row key; can't increment");
            }
            if (this.conf.getBoolean(ThriftServerRunner.COALESCE_INC_KEY, false)) {
                this.coalescer.queueIncrement(tincrement);
                return;
            }
            Table table = null;
            try {
                table = this.getTable(tincrement.getTable());
                Increment inc = ThriftUtilities.incrementFromThrift(tincrement);
                table.increment(inc);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public void incrementRows(List<TIncrement> tincrements) throws IOError, TException {
            if (this.conf.getBoolean(ThriftServerRunner.COALESCE_INC_KEY, false)) {
                this.coalescer.queueIncrements(tincrements);
                return;
            }
            for (TIncrement tinc : tincrements) {
                this.increment(tinc);
            }
        }

        @Override
        public List<TCell> append(TAppend tappend) throws IOError, TException {
            if (tappend.getRow().length == 0 || tappend.getTable().length == 0) {
                throw new TException("Must supply a table and a row key; can't append");
            }
            Table table = null;
            try {
                table = this.getTable(tappend.getTable());
                Append append2 = ThriftUtilities.appendFromThrift(tappend);
                Result result = table.append(append2);
                List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }

        @Override
        public boolean checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
            Put put2;
            try {
                put2 = new Put(Bytes.getBytes((ByteBuffer)row), Long.MAX_VALUE);
                ThriftServerRunner.addAttributes((OperationWithAttributes)put2, attributes);
                byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)mput.column));
                put2.addImmutable(famAndQf[0], famAndQf[1], mput.value != null ? Bytes.getBytes((ByteBuffer)mput.value) : HConstants.EMPTY_BYTE_ARRAY);
                put2.setDurability(mput.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
            }
            Table table = null;
            try {
                table = this.getTable(tableName);
                byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                boolean bl = table.checkAndPut(Bytes.getBytes((ByteBuffer)row), famAndQf[0], famAndQf[1], value != null ? Bytes.getBytes((ByteBuffer)value) : HConstants.EMPTY_BYTE_ARRAY, put2);
                return bl;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.closeTable(table);
            }
        }
    }

    protected static class ResultScannerWrapper {
        private final ResultScanner scanner;
        private final boolean sortColumns;

        public ResultScannerWrapper(ResultScanner resultScanner, boolean sortResultColumns) {
            this.scanner = resultScanner;
            this.sortColumns = sortResultColumns;
        }

        public ResultScanner getScanner() {
            return this.scanner;
        }

        public boolean isColumnSorted() {
            return this.sortColumns;
        }
    }

    static enum ImplType {
        HS_HA("hsha", true, THsHaServer.class, true),
        NONBLOCKING("nonblocking", true, TNonblockingServer.class, true),
        THREAD_POOL("threadpool", false, TBoundedThreadPoolServer.class, true),
        THREADED_SELECTOR("threadedselector", true, TThreadedSelectorServer.class, true);

        public static final ImplType DEFAULT;
        final String option;
        final boolean isAlwaysFramed;
        final Class<? extends TServer> serverClass;
        final boolean canSpecifyBindIP;

        private ImplType(String option, boolean isAlwaysFramed, Class<? extends TServer> serverClass, boolean canSpecifyBindIP) {
            this.option = option;
            this.isAlwaysFramed = isAlwaysFramed;
            this.serverClass = serverClass;
            this.canSpecifyBindIP = canSpecifyBindIP;
        }

        public String toString() {
            return "-" + this.option;
        }

        String getDescription() {
            StringBuilder sb = new StringBuilder("Use the " + this.serverClass.getSimpleName());
            if (this.isAlwaysFramed) {
                sb.append(" This implies the framed transport.");
            }
            if (this == DEFAULT) {
                sb.append("This is the default.");
            }
            return sb.toString();
        }

        static OptionGroup createOptionGroup() {
            OptionGroup group = new OptionGroup();
            for (ImplType t : ImplType.values()) {
                group.addOption(new Option(t.option, t.getDescription()));
            }
            return group;
        }

        static ImplType getServerImpl(Configuration conf) {
            String confType = conf.get(ThriftServerRunner.SERVER_TYPE_CONF_KEY, ImplType.THREAD_POOL.option);
            for (ImplType t : ImplType.values()) {
                if (!confType.equals(t.option)) continue;
                return t;
            }
            throw new AssertionError((Object)("Unknown server ImplType.option:" + confType));
        }

        static void setServerImpl(CommandLine cmd, Configuration conf) {
            ImplType chosenType = null;
            int numChosen = 0;
            for (ImplType t : ImplType.values()) {
                if (!cmd.hasOption(t.option)) continue;
                chosenType = t;
                ++numChosen;
            }
            if (numChosen < 1) {
                LOG.info((Object)"Using default thrift server type");
                chosenType = DEFAULT;
            } else if (numChosen > 1) {
                throw new AssertionError((Object)("Exactly one option out of " + Arrays.toString((Object[])ImplType.values()) + " has to be specified"));
            }
            LOG.info((Object)("Using thrift server type " + chosenType.option));
            conf.set(ThriftServerRunner.SERVER_TYPE_CONF_KEY, chosenType.option);
        }

        public String simpleClassName() {
            return this.serverClass.getSimpleName();
        }

        public static List<String> serversThatCannotSpecifyBindIP() {
            ArrayList<String> l = new ArrayList<String>();
            for (ImplType t : ImplType.values()) {
                if (t.canSpecifyBindIP) continue;
                l.add(t.simpleClassName());
            }
            return l;
        }

        static {
            DEFAULT = THREAD_POOL;
        }
    }
}

