/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSourceFactory;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;

@InterfaceAudience.Private
public class ThriftMetrics {
    private MetricsThriftServerSource source;
    private final long slowResponseTime;
    public static final String SLOW_RESPONSE_NANO_SEC = "hbase.thrift.slow.response.nano.second";
    public static final long DEFAULT_SLOW_RESPONSE_NANO_SEC = 10000000L;

    public MetricsThriftServerSource getSource() {
        return this.source;
    }

    public void setSource(MetricsThriftServerSource source) {
        this.source = source;
    }

    public ThriftMetrics(Configuration conf, ThriftServerType t) {
        this.slowResponseTime = conf.getLong(SLOW_RESPONSE_NANO_SEC, 10000000L);
        if (t == ThriftServerType.ONE) {
            this.source = ((MetricsThriftServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsThriftServerSourceFactory.class)).createThriftOneSource();
        } else if (t == ThriftServerType.TWO) {
            this.source = ((MetricsThriftServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsThriftServerSourceFactory.class)).createThriftTwoSource();
        }
    }

    public void incTimeInQueue(long time) {
        this.source.incTimeInQueue(time);
    }

    public void setCallQueueLen(int len) {
        this.source.setCallQueueLen(len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.source.incNumRowKeysInBatchGet(diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.source.incNumRowKeysInBatchMutate(diff);
    }

    public void incMethodTime(String name, long time) {
        this.source.incMethodTime(name, time);
        this.source.incCall(time);
        if (time > this.slowResponseTime) {
            this.source.incSlowCall(time);
        }
    }

    public void incActiveWorkerCount() {
        this.source.incActiveWorkerCount();
    }

    public void decActiveWorkerCount() {
        this.source.decActiveWorkerCount();
    }

    public void exception(Throwable rawThrowable) {
        this.source.exception();
        Throwable throwable = ThriftMetrics.unwrap(rawThrowable);
        if (throwable != null) {
            if (throwable instanceof OutOfOrderScannerNextException) {
                this.source.outOfOrderException();
            } else if (throwable instanceof RegionTooBusyException) {
                this.source.tooBusyException();
            } else if (throwable instanceof UnknownScannerException) {
                this.source.unknownScannerException();
            } else if (throwable instanceof ScannerResetException) {
                this.source.scannerResetException();
            } else if (throwable instanceof RegionMovedException) {
                this.source.movedRegionException();
            } else if (throwable instanceof NotServingRegionException) {
                this.source.notServingRegionException();
            } else if (throwable instanceof FailedSanityCheckException) {
                this.source.failedSanityException();
            } else if (throwable instanceof MultiActionResultTooLarge) {
                this.source.multiActionTooLargeException();
            } else if (throwable instanceof CallQueueTooBigException) {
                this.source.callQueueTooBigException();
            }
        }
    }

    private static Throwable unwrap(Throwable t) {
        if (t == null) {
            return t;
        }
        if (t instanceof TIOError || t instanceof IOError) {
            t = t.getCause();
        }
        return ClientExceptionsUtil.findException((Object)t);
    }

    public static enum ThriftServerType {
        ONE,
        TWO;

    }
}

