/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TCell
implements TBase<TCell, _Fields>,
Serializable,
Cloneable,
Comparable<TCell> {
    private static final TStruct STRUCT_DESC = new TStruct("TCell");
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 1);
    private static final TField TIMESTAMP_FIELD_DESC = new TField("timestamp", 10, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer value;
    public long timestamp;
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TCell() {
    }

    public TCell(ByteBuffer value, long timestamp) {
        this();
        this.value = TBaseHelper.copyBinary((ByteBuffer)value);
        this.timestamp = timestamp;
        this.setTimestampIsSet(true);
    }

    public TCell(TCell other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetValue()) {
            this.value = other.value;
        }
        this.timestamp = other.timestamp;
    }

    public TCell deepCopy() {
        return new TCell(this);
    }

    public void clear() {
        this.value = null;
        this.setTimestampIsSet(false);
        this.timestamp = 0L;
    }

    public byte[] getValue() {
        this.setValue(TBaseHelper.rightSize((ByteBuffer)this.value));
        return this.value == null ? null : this.value.array();
    }

    public ByteBuffer bufferForValue() {
        return TBaseHelper.copyBinary((ByteBuffer)this.value);
    }

    public TCell setValue(byte[] value) {
        this.value = value == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(value, value.length));
        return this;
    }

    public TCell setValue(ByteBuffer value) {
        this.value = TBaseHelper.copyBinary((ByteBuffer)value);
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TCell setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setTimestampIsSet(true);
        return this;
    }

    public void unsetTimestamp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTimestamp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTimestampIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VALUE: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((ByteBuffer)value);
                break;
            }
            case TIMESTAMP: {
                if (value == null) {
                    this.unsetTimestamp();
                    break;
                }
                this.setTimestamp((Long)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUE: {
                return this.getValue();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUE: {
                return this.isSetValue();
            }
            case TIMESTAMP: {
                return this.isSetTimestamp();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TCell) {
            return this.equals((TCell)that);
        }
        return false;
    }

    public boolean equals(TCell that) {
        if (that == null) {
            return false;
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!this.value.equals(that.value)) {
                return false;
            }
        }
        boolean this_present_timestamp = true;
        boolean that_present_timestamp = true;
        if (this_present_timestamp || that_present_timestamp) {
            if (!this_present_timestamp || !that_present_timestamp) {
                return false;
            }
            if (this.timestamp != that.timestamp) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_value = this.isSetValue();
        list.add(Boolean.valueOf(present_value));
        if (present_value) {
            list.add(this.value);
        }
        boolean present_timestamp = true;
        list.add(Boolean.valueOf(present_timestamp));
        if (present_timestamp) {
            list.add(Long.valueOf(this.timestamp));
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TCell other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((Comparable)this.value, (Comparable)other.value)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTimestamp()).compareTo(other.isSetTimestamp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimestamp() && (lastComparison = TBaseHelper.compareTo((long)this.timestamp, (long)other.timestamp)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TCell(");
        boolean first = true;
        sb.append("value:");
        if (this.value == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.value, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("timestamp:");
        sb.append(this.timestamp);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TCellStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TCellTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11, "Bytes")));
        tmpMap.put(_Fields.TIMESTAMP, new FieldMetaData("timestamp", 3, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TCell.class, metaDataMap);
    }

    private static class TCellTupleScheme
    extends TupleScheme<TCell> {
        private TCellTupleScheme() {
        }

        public void write(TProtocol prot, TCell struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetValue()) {
                optionals.set(0);
            }
            if (struct.isSetTimestamp()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetValue()) {
                oprot.writeBinary(struct.value);
            }
            if (struct.isSetTimestamp()) {
                oprot.writeI64(struct.timestamp);
            }
        }

        public void read(TProtocol prot, TCell struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.value = iprot.readBinary();
                struct.setValueIsSet(true);
            }
            if (incoming.get(1)) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
            }
        }
    }

    private static class TCellTupleSchemeFactory
    implements SchemeFactory {
        private TCellTupleSchemeFactory() {
        }

        public TCellTupleScheme getScheme() {
            return new TCellTupleScheme();
        }
    }

    private static class TCellStandardScheme
    extends StandardScheme<TCell> {
        private TCellStandardScheme() {
        }

        public void read(TProtocol iprot, TCell struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.value = iprot.readBinary();
                            struct.setValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.timestamp = iprot.readI64();
                            struct.setTimestampIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TCell struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeBinary(struct.value);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
            oprot.writeI64(struct.timestamp);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TCellStandardSchemeFactory
    implements SchemeFactory {
        private TCellStandardSchemeFactory() {
        }

        public TCellStandardScheme getScheme() {
            return new TCellStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUE(1, "value"),
        TIMESTAMP(2, "timestamp");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUE;
                }
                case 2: {
                    return TIMESTAMP;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

