/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.THBaseThreadPoolExecutor;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ThriftServer
extends Configured
implements Tool {
    private static final Log log = LogFactory.getLog(ThriftServer.class);
    static final String THRIFT_QOP_KEY = "hbase.thrift.security.qop";
    static final String BACKLOG_CONF_KEY = "hbase.regionserver.thrift.backlog";
    public static final int DEFAULT_LISTEN_PORT = 9090;
    private static final String READ_TIMEOUT_OPTION = "readTimeout";
    public static final String THRIFT_SERVER_SOCKET_READ_TIMEOUT_KEY = "hbase.thrift.server.socket.read.timeout";
    public static final int THRIFT_SERVER_SOCKET_READ_TIMEOUT_DEFAULT = 60000;

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, ThriftServer.getOptions(), "To start the Thrift server run 'hbase-daemon.sh start thrift2'\nTo shutdown the thrift server run 'hbase-daemon.sh stop thrift2' or send a kill signal to the thrift server pid", true);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("b", "bind", true, "Address to bind the Thrift server to. [default: 0.0.0.0]");
        options.addOption("p", "port", true, "Port to bind to [default: 9090]");
        options.addOption("f", "framed", false, "Use framed transport");
        options.addOption("c", "compact", false, "Use the compact protocol");
        options.addOption("w", "workers", true, "How many worker threads to use.");
        options.addOption("s", "selectors", true, "How many selector threads to use.");
        options.addOption("q", "callQueueSize", true, "Max size of request queue (unbounded by default)");
        options.addOption("h", "help", false, "Print help information");
        options.addOption(null, "infoport", true, "Port for web UI");
        options.addOption("t", READ_TIMEOUT_OPTION, true, "Amount of time in milliseconds before a server thread will timeout waiting for client to send data on a connected socket. Currently, only applies to TBoundedThreadPoolServer");
        options.addOption("ro", "readonly", false, "Respond only to read method requests [default: false]");
        OptionGroup servers = new OptionGroup();
        servers.addOption(new Option("nonblocking", false, "Use the TNonblockingServer. This implies the framed transport."));
        servers.addOption(new Option("hsha", false, "Use the THsHaServer. This implies the framed transport."));
        servers.addOption(new Option("selector", false, "Use the TThreadedSelectorServer. This implies the framed transport."));
        servers.addOption(new Option("threadpool", false, "Use the TThreadPoolServer. This is the default."));
        options.addOptionGroup(servers);
        return options;
    }

    private static CommandLine parseArguments(Configuration conf, Options options, String[] args) throws ParseException, IOException {
        PosixParser parser = new PosixParser();
        return parser.parse(options, args);
    }

    private static TProtocolFactory getTProtocolFactory(boolean isCompact) {
        if (isCompact) {
            log.debug((Object)"Using compact protocol");
            return new TCompactProtocol.Factory();
        }
        log.debug((Object)"Using binary protocol");
        return new TBinaryProtocol.Factory();
    }

    private static TTransportFactory getTTransportFactory(SaslUtil.QualityOfProtection qop, String name, String host, boolean framed, int frameSize) {
        if (framed) {
            if (qop != null) {
                throw new RuntimeException("Thrift server authentication doesn't work with framed transport yet");
            }
            log.debug((Object)"Using framed transport");
            return new TFramedTransport.Factory(frameSize);
        }
        if (qop == null) {
            return new TTransportFactory();
        }
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", qop.getSaslQop());
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        saslFactory.addServerDefinition("GSSAPI", name, host, saslProperties, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (!(callback instanceof AuthorizeCallback)) {
                        throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                    }
                    ac = (AuthorizeCallback)callback;
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (!authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(false);
                    } else {
                        ac.setAuthorized(true);
                        String userName = SecurityUtil.getUserFromPrincipal((String)authzid);
                        log.info((Object)("Effective user: " + userName));
                        ac.setAuthorizedID(userName);
                    }
                }
            }
        });
        return saslFactory;
    }

    private static InetSocketAddress bindToPort(String bindValue, int listenPort) throws UnknownHostException {
        try {
            if (bindValue == null) {
                return new InetSocketAddress(listenPort);
            }
            return new InetSocketAddress(InetAddress.getByName(bindValue), listenPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not bind to provided ip address", e);
        }
    }

    private static TServer getTNonBlockingServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase Nonblocking Thrift server on " + inetSocketAddress.toString()));
        TNonblockingServer.Args serverArgs = new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
    }

    private static TServer getTHsHaServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, int workerThreads, int maxCallQueueSize, InetSocketAddress inetSocketAddress, ThriftMetrics metrics) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase HsHA Thrift server on " + inetSocketAddress.toString()));
        THsHaServer.Args serverArgs = new THsHaServer.Args((TNonblockingServerTransport)serverTransport);
        if (workerThreads > 0) {
            serverArgs.minWorkerThreads(workerThreads).maxWorkerThreads(workerThreads);
        }
        ExecutorService executorService = ThriftServer.createExecutor(workerThreads, maxCallQueueSize, metrics);
        serverArgs.executorService(executorService);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new THsHaServer(serverArgs);
    }

    private static TServer getTThreadedSelectorServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, int workerThreads, int selectorThreads, int maxCallQueueSize, InetSocketAddress inetSocketAddress, ThriftMetrics metrics) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase ThreadedSelector Thrift server on " + inetSocketAddress.toString()));
        TThreadedSelectorServer.Args serverArgs = new TThreadedSelectorServer.Args((TNonblockingServerTransport)serverTransport);
        if (workerThreads > 0) {
            serverArgs.workerThreads(workerThreads);
        }
        if (selectorThreads > 0) {
            serverArgs.selectorThreads(selectorThreads);
        }
        ExecutorService executorService = ThriftServer.createExecutor(workerThreads, maxCallQueueSize, metrics);
        serverArgs.executorService(executorService);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TThreadedSelectorServer(serverArgs);
    }

    private static ExecutorService createExecutor(int workerThreads, int maxCallQueueSize, ThriftMetrics metrics) {
        CallQueue callQueue = maxCallQueueSize > 0 ? new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(maxCallQueueSize), metrics) : new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), metrics);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift2-worker-%d");
        THBaseThreadPoolExecutor pool = new THBaseThreadPoolExecutor(workerThreads, workerThreads, Long.MAX_VALUE, TimeUnit.SECONDS, (BlockingQueue<Runnable>)callQueue, tfb.build(), metrics);
        pool.prestartAllCoreThreads();
        return pool;
    }

    private static TServer getTThreadPoolServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, int workerThreads, InetSocketAddress inetSocketAddress, int backlog, int clientTimeout, ThriftMetrics metrics) throws TTransportException {
        TServerSocket serverTransport = new TServerSocket((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().bindAddr(inetSocketAddress)).backlog(backlog)).clientTimeout(clientTimeout));
        log.info((Object)("starting HBase ThreadPool Thrift server on " + inetSocketAddress.toString()));
        TThreadPoolServer.Args serverArgs = new TThreadPoolServer.Args((TServerTransport)serverTransport);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        if (workerThreads > 0) {
            serverArgs.maxWorkerThreads(workerThreads);
        }
        THBaseThreadPoolExecutor executor = new THBaseThreadPoolExecutor(serverArgs.minWorkerThreads, serverArgs.maxWorkerThreads, (long)serverArgs.stopTimeoutVal, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), metrics);
        serverArgs.executorService((ExecutorService)executor);
        return new TThreadPoolServer(serverArgs);
    }

    protected static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        if (filters != null) {
            for (String filterClass : filters) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    log.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter((String)filterPart[0], (String)filterPart[1]);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int status = ToolRunner.run((Configuration)conf, (Tool)new ThriftServer(), (String[])args);
        System.exit(status);
    }

    public int run(String[] args) throws Exception {
        boolean securityEnabled;
        String bindAddress;
        Configuration conf = this.getConf();
        TServer server = null;
        Options options = ThriftServer.getOptions();
        CommandLine cmd = ThriftServer.parseArguments(conf, options, args);
        int workerThreads = 0;
        int selectorThreads = 0;
        int maxCallQueueSize = -1;
        List argList = cmd.getArgList();
        if (cmd.hasOption("help") || !argList.contains("start") || argList.contains("stop")) {
            ThriftServer.printUsage();
            return 1;
        }
        if (cmd.hasOption("bind")) {
            bindAddress = cmd.getOptionValue("bind");
            conf.set("hbase.thrift.info.bindAddress", bindAddress);
        } else {
            bindAddress = conf.get("hbase.thrift.info.bindAddress");
        }
        if (cmd.hasOption("readonly")) {
            conf.setBoolean("hbase.thrift.readonly", true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"readonly set to true");
            }
        }
        int readTimeout = 60000;
        if (cmd.hasOption(READ_TIMEOUT_OPTION)) {
            try {
                readTimeout = Integer.parseInt(cmd.getOptionValue(READ_TIMEOUT_OPTION));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse the value provided for the timeout option", e);
            }
        } else {
            readTimeout = conf.getInt(THRIFT_SERVER_SOCKET_READ_TIMEOUT_KEY, 60000);
        }
        int listenPort = 0;
        try {
            listenPort = cmd.hasOption("port") ? Integer.parseInt(cmd.getOptionValue("port")) : conf.getInt("hbase.regionserver.thrift.port", 9090);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse the value provided for the port option", e);
        }
        int backlog = conf.getInt(BACKLOG_CONF_KEY, 0);
        String host = null;
        String name = null;
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        boolean bl = securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (securityEnabled) {
            host = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.thrift.dns.interface", "default"), (String)conf.get("hbase.thrift.dns.nameserver", "default")));
            userProvider.login("hbase.thrift.keytab.file", "hbase.thrift.kerberos.principal", host);
        }
        UserGroupInformation realUser = userProvider.getCurrent().getUGI();
        String stringQop = conf.get(THRIFT_QOP_KEY);
        SaslUtil.QualityOfProtection qop = null;
        if (stringQop != null) {
            qop = SaslUtil.getQop((String)stringQop);
            if (!securityEnabled) {
                throw new IOException("Thrift server must run in secure mode to support authentication");
            }
            name = SecurityUtil.getUserFromPrincipal((String)conf.get("hbase.thrift.kerberos.principal"));
        }
        boolean nonblocking = cmd.hasOption("nonblocking");
        boolean hsha = cmd.hasOption("hsha");
        boolean selector = cmd.hasOption("selector");
        ThriftMetrics metrics = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.TWO);
        final JvmPauseMonitor pauseMonitor = new JvmPauseMonitor(conf, (JvmPauseMonitorSource)metrics.getSource());
        String implType = "threadpool";
        if (nonblocking) {
            implType = "nonblocking";
        } else if (hsha) {
            implType = "hsha";
        } else if (selector) {
            implType = "selector";
        }
        conf.set("hbase.regionserver.thrift.server.type", implType);
        conf.setInt("hbase.regionserver.thrift.port", listenPort);
        ThriftServer.registerFilters(conf);
        boolean compact2 = cmd.hasOption("compact") || conf.getBoolean("hbase.regionserver.thrift.compact", false);
        TProtocolFactory protocolFactory = ThriftServer.getTProtocolFactory(compact2);
        final ThriftHBaseServiceHandler hbaseHandler = new ThriftHBaseServiceHandler(conf, userProvider);
        THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance(hbaseHandler, metrics);
        final THBaseService.Processor<THBaseService.Iface> p = new THBaseService.Processor<THBaseService.Iface>(handler);
        conf.setBoolean("hbase.regionserver.thrift.compact", compact2);
        TProcessor processor = p;
        boolean framed = cmd.hasOption("framed") || conf.getBoolean("hbase.regionserver.thrift.framed", false) || nonblocking || hsha;
        TTransportFactory transportFactory = ThriftServer.getTTransportFactory(qop, name, host, framed, conf.getInt("hbase.regionserver.thrift.framed.max_frame_size_in_mb", 2) * 1024 * 1024);
        InetSocketAddress inetSocketAddress = ThriftServer.bindToPort(bindAddress, listenPort);
        conf.setBoolean("hbase.regionserver.thrift.framed", framed);
        if (qop != null) {
            processor = new TProcessor(){

                public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
                    TSaslServerTransport saslServerTransport = (TSaslServerTransport)inProt.getTransport();
                    SaslServer saslServer = saslServerTransport.getSaslServer();
                    String principal = saslServer.getAuthorizationID();
                    hbaseHandler.setEffectiveUser(principal);
                    return p.process(inProt, outProt);
                }
            };
        }
        if (cmd.hasOption("w")) {
            workerThreads = Integer.parseInt(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("s")) {
            selectorThreads = Integer.parseInt(cmd.getOptionValue("s"));
        }
        if (cmd.hasOption("q")) {
            maxCallQueueSize = Integer.parseInt(cmd.getOptionValue("q"));
        }
        try {
            if (cmd.hasOption("infoport")) {
                String val = cmd.getOptionValue("infoport");
                conf.setInt("hbase.thrift.info.port", Integer.parseInt(val));
                log.debug((Object)("Web UI port set to " + val));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Could not parse the value provided for the infoport option", (Throwable)e);
            ThriftServer.printUsage();
            System.exit(1);
        }
        int port = conf.getInt("hbase.thrift.info.port", 9095);
        if (port >= 0) {
            conf.setLong("startcode", System.currentTimeMillis());
            String a = conf.get("hbase.thrift.info.bindAddress", "0.0.0.0");
            InfoServer infoServer = new InfoServer("thrift", a, port, false, conf);
            infoServer.setAttribute("hbase.conf", (Object)conf);
            infoServer.start();
        }
        server = nonblocking ? ThriftServer.getTNonBlockingServer(protocolFactory, processor, transportFactory, inetSocketAddress) : (hsha ? ThriftServer.getTHsHaServer(protocolFactory, processor, transportFactory, workerThreads, maxCallQueueSize, inetSocketAddress, metrics) : (selector ? ThriftServer.getTThreadedSelectorServer(protocolFactory, processor, transportFactory, workerThreads, selectorThreads, maxCallQueueSize, inetSocketAddress, metrics) : ThriftServer.getTThreadPoolServer(protocolFactory, processor, transportFactory, workerThreads, inetSocketAddress, backlog, readTimeout, metrics)));
        final TServer tserver = server;
        realUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                pauseMonitor.start();
                try {
                    tserver.serve();
                    Object var1_1 = null;
                    return var1_1;
                }
                finally {
                    pauseMonitor.stop();
                }
            }
        });
        return 0;
    }
}

