/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOp;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THRegionInfo;
import org.apache.hadoop.hbase.thrift2.generated.THRegionLocation;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TMutation;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TReadType;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TServerName;
import org.apache.hadoop.hbase.thrift2.generated.TTimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ThriftUtilities {
    private ThriftUtilities() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static Get getFromThrift(TGet in) throws IOException {
        Get out = new Get(in.getRow());
        if (in.isSetTimestamp()) {
            out.setTimeStamp(in.getTimestamp());
        } else if (in.isSetTimeRange()) {
            out.setTimeRange(in.getTimeRange().getMinStamp(), in.getTimeRange().getMaxStamp());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetFilterString()) {
            ParseFilter parseFilter = new ParseFilter();
            out.setFilter(parseFilter.parseFilterString(in.getFilterString()));
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetAuthorizations()) {
            out.setAuthorizations(new Authorizations(in.getAuthorizations().getLabels()));
        }
        if (!in.isSetColumns()) {
            return out;
        }
        for (TColumn column : in.getColumns()) {
            if (column.isSetQualifier()) {
                out.addColumn(column.getFamily(), column.getQualifier());
                continue;
            }
            out.addFamily(column.getFamily());
        }
        return out;
    }

    public static List<Get> getsFromThrift(List<TGet> in) throws IOException {
        ArrayList<Get> out = new ArrayList<Get>(in.size());
        for (TGet get2 : in) {
            out.add(ThriftUtilities.getFromThrift(get2));
        }
        return out;
    }

    public static TResult resultFromHBase(Result in) {
        Cell[] raw = in.rawCells();
        TResult out = new TResult();
        byte[] row = in.getRow();
        if (row != null) {
            out.setRow(in.getRow());
        }
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(raw.length);
        for (Cell kv : raw) {
            TColumnValue col = new TColumnValue();
            col.setFamily(CellUtil.cloneFamily((Cell)kv));
            col.setQualifier(CellUtil.cloneQualifier((Cell)kv));
            col.setTimestamp(kv.getTimestamp());
            col.setValue(CellUtil.cloneValue((Cell)kv));
            if (kv.getTagsLength() > 0) {
                col.setTags(PrivateCellUtil.getTagsArray((Cell)kv));
            }
            columnValues.add(col);
        }
        out.setColumnValues(columnValues);
        return out;
    }

    public static List<TResult> resultsFromHBase(Result[] in) {
        ArrayList<TResult> out = new ArrayList<TResult>(in.length);
        for (Result result : in) {
            out.add(ThriftUtilities.resultFromHBase(result));
        }
        return out;
    }

    public static Put putFromThrift(TPut in) {
        Put out = in.isSetTimestamp() ? new Put(in.getRow(), in.getTimestamp()) : new Put(in.getRow());
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        for (TColumnValue columnValue : in.getColumnValues()) {
            if (columnValue.isSetTimestamp()) {
                out.addImmutable(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getTimestamp(), columnValue.getValue());
                continue;
            }
            out.addImmutable(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getValue());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.getCellVisibility() != null) {
            out.setCellVisibility(new CellVisibility(in.getCellVisibility().getExpression()));
        }
        return out;
    }

    public static List<Put> putsFromThrift(List<TPut> in) {
        ArrayList<Put> out = new ArrayList<Put>(in.size());
        for (TPut put2 : in) {
            out.add(ThriftUtilities.putFromThrift(put2));
        }
        return out;
    }

    public static Delete deleteFromThrift(TDelete in) {
        Delete out;
        if (in.isSetColumns()) {
            out = new Delete(in.getRow());
            for (TColumn column : in.getColumns()) {
                if (in.isSetDeleteType()) {
                    switch (in.getDeleteType()) {
                        case DELETE_COLUMN: {
                            if (column.isSetTimestamp()) {
                                out.addColumn(column.getFamily(), column.getQualifier(), column.getTimestamp());
                                break;
                            }
                            out.addColumn(column.getFamily(), column.getQualifier());
                            break;
                        }
                        case DELETE_COLUMNS: {
                            if (column.isSetTimestamp()) {
                                out.addColumns(column.getFamily(), column.getQualifier(), column.getTimestamp());
                                break;
                            }
                            out.addColumns(column.getFamily(), column.getQualifier());
                            break;
                        }
                        case DELETE_FAMILY: {
                            if (column.isSetTimestamp()) {
                                out.addFamily(column.getFamily(), column.getTimestamp());
                                break;
                            }
                            out.addFamily(column.getFamily());
                            break;
                        }
                        case DELETE_FAMILY_VERSION: {
                            if (column.isSetTimestamp()) {
                                out.addFamilyVersion(column.getFamily(), column.getTimestamp());
                                break;
                            }
                            throw new IllegalArgumentException("Timestamp is required for TDelete with DeleteFamilyVersion type");
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("DeleteType is required for TDelete");
            }
        } else {
            out = in.isSetTimestamp() ? new Delete(in.getRow(), in.getTimestamp()) : new Delete(in.getRow());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        return out;
    }

    public static List<Delete> deletesFromThrift(List<TDelete> in) {
        ArrayList<Delete> out = new ArrayList<Delete>(in.size());
        for (TDelete delete : in) {
            out.add(ThriftUtilities.deleteFromThrift(delete));
        }
        return out;
    }

    public static TDelete deleteFromHBase(Delete in) {
        TDelete out = new TDelete(ByteBuffer.wrap(in.getRow()));
        ArrayList<TColumn> columns = new ArrayList<TColumn>(in.getFamilyCellMap().entrySet().size());
        long rowTimestamp = in.getTimeStamp();
        if (rowTimestamp != Long.MAX_VALUE) {
            out.setTimestamp(rowTimestamp);
        }
        for (Map.Entry familyEntry : in.getFamilyCellMap().entrySet()) {
            TColumn column = new TColumn(ByteBuffer.wrap((byte[])familyEntry.getKey()));
            for (Cell cell : (List)familyEntry.getValue()) {
                byte[] family = CellUtil.cloneFamily((Cell)cell);
                byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                long timestamp = cell.getTimestamp();
                if (family != null) {
                    column.setFamily(family);
                }
                if (qualifier != null) {
                    column.setQualifier(qualifier);
                }
                if (timestamp == Long.MAX_VALUE) continue;
                column.setTimestamp(timestamp);
            }
            columns.add(column);
        }
        out.setColumns(columns);
        return out;
    }

    public static RowMutations rowMutationsFromThrift(TRowMutations in) throws IOException {
        List<TMutation> mutations = in.getMutations();
        RowMutations out = new RowMutations(in.getRow(), mutations.size());
        for (TMutation mutation : mutations) {
            if (mutation.isSetPut()) {
                out.add(ThriftUtilities.putFromThrift(mutation.getPut()));
            }
            if (!mutation.isSetDeleteSingle()) continue;
            out.add(ThriftUtilities.deleteFromThrift(mutation.getDeleteSingle()));
        }
        return out;
    }

    public static Scan scanFromThrift(TScan in) throws IOException {
        Map<ByteBuffer, TTimeRange> colFamTimeRangeMap;
        TTimeRange timeRange;
        Scan out = new Scan();
        if (in.isSetStartRow()) {
            out.setStartRow(in.getStartRow());
        }
        if (in.isSetStopRow()) {
            out.setStopRow(in.getStopRow());
        }
        if (in.isSetCaching()) {
            out.setCaching(in.getCaching());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetColumns()) {
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    out.addColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                out.addFamily(column.getFamily());
            }
        }
        if ((timeRange = in.getTimeRange()) != null && timeRange.isSetMinStamp() && timeRange.isSetMaxStamp()) {
            out.setTimeRange(timeRange.getMinStamp(), timeRange.getMaxStamp());
        }
        if (in.isSetBatchSize()) {
            out.setBatch(in.getBatchSize());
        }
        if (in.isSetFilterString()) {
            ParseFilter parseFilter = new ParseFilter();
            out.setFilter(parseFilter.parseFilterString(in.getFilterString()));
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetAuthorizations()) {
            out.setAuthorizations(new Authorizations(in.getAuthorizations().getLabels()));
        }
        if (in.isSetReversed()) {
            out.setReversed(in.isReversed());
        }
        if (in.isSetCacheBlocks()) {
            out.setCacheBlocks(in.isCacheBlocks());
        }
        if (in.isSetColFamTimeRangeMap() && MapUtils.isNotEmpty(colFamTimeRangeMap = in.getColFamTimeRangeMap())) {
            for (Map.Entry<ByteBuffer, TTimeRange> entry : colFamTimeRangeMap.entrySet()) {
                out.setColumnFamilyTimeRange(Bytes.toBytes((ByteBuffer)entry.getKey()), entry.getValue().getMinStamp(), entry.getValue().getMaxStamp());
            }
        }
        if (in.isSetReadType()) {
            out.setReadType(ThriftUtilities.readTypeFromThrift(in.getReadType()));
        }
        if (in.isSetLimit()) {
            out.setLimit(in.getLimit());
        }
        return out;
    }

    public static Increment incrementFromThrift(TIncrement in) throws IOException {
        Increment out = new Increment(in.getRow());
        for (TColumnIncrement column : in.getColumns()) {
            out.addColumn(column.getFamily(), column.getQualifier(), column.getAmount());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        if (in.getCellVisibility() != null) {
            out.setCellVisibility(new CellVisibility(in.getCellVisibility().getExpression()));
        }
        return out;
    }

    public static Append appendFromThrift(TAppend append2) throws IOException {
        Append out = new Append(append2.getRow());
        for (TColumnValue column : append2.getColumns()) {
            out.addColumn(column.getFamily(), column.getQualifier(), column.getValue());
        }
        if (append2.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, append2.getAttributes());
        }
        if (append2.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(append2.getDurability()));
        }
        if (append2.getCellVisibility() != null) {
            out.setCellVisibility(new CellVisibility(append2.getCellVisibility().getExpression()));
        }
        return out;
    }

    public static THRegionLocation regionLocationFromHBase(HRegionLocation hrl) {
        HRegionInfo hri = hrl.getRegionInfo();
        ServerName serverName = hrl.getServerName();
        THRegionInfo thRegionInfo = new THRegionInfo();
        THRegionLocation thRegionLocation = new THRegionLocation();
        TServerName tServerName = new TServerName();
        tServerName.setHostName(serverName.getHostname());
        tServerName.setPort(serverName.getPort());
        tServerName.setStartCode(serverName.getStartcode());
        thRegionInfo.setTableName(hri.getTable().getName());
        thRegionInfo.setEndKey(hri.getEndKey());
        thRegionInfo.setStartKey(hri.getStartKey());
        thRegionInfo.setOffline(hri.isOffline());
        thRegionInfo.setSplit(hri.isSplit());
        thRegionInfo.setReplicaId(hri.getReplicaId());
        thRegionLocation.setRegionInfo(thRegionInfo);
        thRegionLocation.setServerName(tServerName);
        return thRegionLocation;
    }

    public static List<THRegionLocation> regionLocationsFromHBase(List<HRegionLocation> locations) {
        ArrayList<THRegionLocation> tlocations = new ArrayList<THRegionLocation>(locations.size());
        for (HRegionLocation hrl : locations) {
            tlocations.add(ThriftUtilities.regionLocationFromHBase(hrl));
        }
        return tlocations;
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary((byte[])Bytes.getBytes((ByteBuffer)entry.getKey()));
            byte[] value = Bytes.getBytes((ByteBuffer)entry.getValue());
            op.setAttribute(name, value);
        }
    }

    private static Durability durabilityFromThrift(TDurability tDurability) {
        switch (tDurability.getValue()) {
            case 1: {
                return Durability.SKIP_WAL;
            }
            case 2: {
                return Durability.ASYNC_WAL;
            }
            case 3: {
                return Durability.SYNC_WAL;
            }
            case 4: {
                return Durability.FSYNC_WAL;
            }
        }
        return null;
    }

    public static CompareOperator compareOpFromThrift(TCompareOp tCompareOp) {
        switch (tCompareOp.getValue()) {
            case 0: {
                return CompareOperator.LESS;
            }
            case 1: {
                return CompareOperator.LESS_OR_EQUAL;
            }
            case 2: {
                return CompareOperator.EQUAL;
            }
            case 3: {
                return CompareOperator.NOT_EQUAL;
            }
            case 4: {
                return CompareOperator.GREATER_OR_EQUAL;
            }
            case 5: {
                return CompareOperator.GREATER;
            }
            case 6: {
                return CompareOperator.NO_OP;
            }
        }
        return null;
    }

    private static Scan.ReadType readTypeFromThrift(TReadType tReadType) {
        switch (tReadType.getValue()) {
            case 1: {
                return Scan.ReadType.DEFAULT;
            }
            case 2: {
                return Scan.ReadType.STREAM;
            }
            case 3: {
                return Scan.ReadType.PREAD;
            }
        }
        return null;
    }
}

