/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.thrift.HttpAuthenticationException;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.apache.yetus.audience.InterfaceAudience;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftHttpServlet
extends TServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)ThriftHttpServlet.class.getName());
    private final transient UserGroupInformation realUser;
    private final transient Configuration conf;
    private final boolean securityEnabled;
    private final boolean doAsEnabled;
    private transient ThriftServerRunner.HBaseHandler hbaseHandler;
    private String outToken;
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, UserGroupInformation realUser, Configuration conf, ThriftServerRunner.HBaseHandler hbaseHandler, boolean securityEnabled, boolean doAsEnabled) {
        super(processor, protocolFactory);
        this.realUser = realUser;
        this.conf = conf;
        this.hbaseHandler = hbaseHandler;
        this.securityEnabled = securityEnabled;
        this.doAsEnabled = doAsEnabled;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String effectiveUser = request.getRemoteUser();
        if (this.securityEnabled) {
            try {
                effectiveUser = this.doKerberosAuth(request);
                response.addHeader(WWW_AUTHENTICATE, "Negotiate " + this.outToken);
            }
            catch (HttpAuthenticationException e) {
                LOG.error("Kerberos Authentication failed", (Throwable)e);
                response.setStatus(401);
                response.addHeader(WWW_AUTHENTICATE, NEGOTIATE);
                response.getWriter().println("Authentication Error: " + e.getMessage());
                return;
            }
        }
        String doAsUserFromQuery = request.getHeader("doAs");
        if (effectiveUser == null) {
            effectiveUser = this.realUser.getShortUserName();
        }
        if (doAsUserFromQuery != null) {
            if (!this.doAsEnabled) {
                throw new ServletException("Support for proxyuser is not configured");
            }
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)effectiveUser);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)doAsUserFromQuery, (UserGroupInformation)remoteUser);
            try {
                ProxyUsers.authorize((UserGroupInformation)ugi, (String)request.getRemoteAddr(), (Configuration)this.conf);
            }
            catch (AuthorizationException e) {
                throw new ServletException(e.getMessage());
            }
            effectiveUser = doAsUserFromQuery;
        }
        this.hbaseHandler.setEffectiveUser(effectiveUser);
        super.doPost(request, response);
    }

    private String doKerberosAuth(HttpServletRequest request) throws HttpAuthenticationException {
        HttpKerberosServerAction action = new HttpKerberosServerAction(request, this.realUser);
        try {
            String principal = (String)this.realUser.doAs((PrivilegedExceptionAction)action);
            this.outToken = action.outToken;
            return principal;
        }
        catch (Exception e) {
            LOG.error("Failed to perform authentication");
            throw new HttpAuthenticationException(e);
        }
    }

    private static class HttpKerberosServerAction
    implements PrivilegedExceptionAction<String> {
        HttpServletRequest request;
        UserGroupInformation serviceUGI;
        String outToken = null;

        HttpKerberosServerAction(HttpServletRequest request, UserGroupInformation serviceUGI) {
            this.request = request;
            this.serviceUGI = serviceUGI;
        }

        @Override
        public String run() throws HttpAuthenticationException {
            GSSManager manager = GSSManager.getInstance();
            GSSContext gssContext = null;
            String serverPrincipal = SecurityUtil.getPrincipalWithoutRealm((String)this.serviceUGI.getUserName());
            try {
                Oid kerberosMechOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoMechOid = new Oid("1.3.6.1.5.5.2");
                Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName(serverPrincipal, krb5PrincipalOid);
                GSSCredential serverCreds = manager.createCredential(serverName, 0, new Oid[]{kerberosMechOid, spnegoMechOid}, 2);
                gssContext = manager.createContext(serverCreds);
                String serviceTicketBase64 = this.getAuthHeader(this.request);
                byte[] inToken = Base64.decode((String)serviceTicketBase64);
                byte[] res = gssContext.acceptSecContext(inToken, 0, inToken.length);
                if (res != null) {
                    this.outToken = Base64.encodeBytes((byte[])res).replace("\n", "");
                }
                if (!gssContext.isEstablished()) {
                    throw new HttpAuthenticationException("Kerberos authentication failed: unable to establish context with the service ticket provided by the client.");
                }
                String string = SecurityUtil.getUserFromPrincipal((String)gssContext.getSrcName().toString());
                return string;
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException("Kerberos authentication failed: ", e);
            }
            finally {
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException e) {
                        LOG.warn("Error while disposing GSS Context", (Throwable)e);
                    }
                }
            }
        }

        private String getAuthHeader(HttpServletRequest request) throws HttpAuthenticationException {
            String authHeader = request.getHeader(ThriftHttpServlet.AUTHORIZATION);
            if (authHeader == null || authHeader.isEmpty()) {
                throw new HttpAuthenticationException("Authorization header received from the client is empty.");
            }
            int beginIndex = "Negotiate ".length();
            String authHeaderBase64String = authHeader.substring(beginIndex);
            if (authHeaderBase64String == null || authHeaderBase64String.isEmpty()) {
                throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
            }
            return authHeaderBase64String;
        }
    }
}

