/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.HostConfiguration;
import org.apache.http.util.CharArrayBuffer;

public final class HttpRoute
implements Cloneable {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private final HttpHost[] proxyChain;
    private final boolean tunnelled;
    private final boolean layered;
    private final boolean secure;

    private HttpRoute(InetAddress local, HttpHost target, HttpHost[] proxies, boolean secure, boolean tunnelled, boolean layered) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (tunnelled && proxies == null) {
            throw new IllegalArgumentException("Proxy required if tunnelled.");
        }
        this.targetHost = target;
        this.localAddress = local;
        this.proxyChain = proxies;
        this.secure = secure;
        this.tunnelled = tunnelled;
        this.layered = layered;
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost[] proxies, boolean secure, boolean tunnelled, boolean layered) {
        this(local, target, HttpRoute.toChain(proxies), secure, tunnelled, layered);
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure, boolean tunnelled, boolean layered) {
        this(local, target, HttpRoute.toChain(proxy), secure, tunnelled, layered);
    }

    public HttpRoute(HttpHost target, InetAddress local, boolean secure) {
        this(local, target, null, secure, false, false);
    }

    public HttpRoute(HttpHost target) {
        this(null, target, null, false, false, false);
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure) {
        this(local, target, HttpRoute.toChain(proxy), secure, secure, secure);
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
    }

    private static HttpHost[] toChain(HttpHost proxy) {
        if (proxy == null) {
            return null;
        }
        return new HttpHost[]{proxy};
    }

    private static HttpHost[] toChain(HttpHost[] proxies) {
        if (proxies == null || proxies.length < 1) {
            return null;
        }
        for (int i = 0; i < proxies.length; ++i) {
            if (proxies[i] != null) continue;
            throw new IllegalArgumentException("Proxy chain may not contain null elements.");
        }
        HttpHost[] result = new HttpHost[proxies.length];
        System.arraycopy(proxies, 0, result, 0, proxies.length);
        return result;
    }

    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public final int getHopCount() {
        return this.proxyChain == null ? 1 : this.proxyChain.length + 1;
    }

    public final HttpHost getHopTarget(int hop) {
        if (hop < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + hop);
        }
        int hopcount = this.getHopCount();
        if (hop >= hopcount) {
            throw new IllegalArgumentException("Hop index " + hop + " exceeds route length " + hopcount + ".");
        }
        HttpHost result = null;
        result = hop < hopcount - 1 ? this.proxyChain[hop] : this.targetHost;
        return result;
    }

    public final HttpHost getProxyHost() {
        return this.proxyChain == null ? null : this.proxyChain[0];
    }

    public final boolean isTunnelled() {
        return this.tunnelled;
    }

    public final boolean isLayered() {
        return this.layered;
    }

    public final boolean isSecure() {
        return this.secure;
    }

    public final HostConfiguration toHostConfig() {
        if (this.proxyChain != null && this.proxyChain.length > 1) {
            throw new IllegalStateException("Cannot convert proxy chain.");
        }
        return new HostConfiguration(this.targetHost, this.getProxyHost(), this.localAddress);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRoute)) {
            return false;
        }
        HttpRoute that = (HttpRoute)o;
        boolean equal = this.targetHost.equals((Object)that.targetHost);
        equal &= this.localAddress == that.localAddress || this.localAddress != null && this.localAddress.equals(that.localAddress);
        equal &= this.proxyChain == that.proxyChain || this.proxyChain != null && that.proxyChain != null && this.proxyChain.length == that.proxyChain.length;
        if ((equal &= this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered) && this.proxyChain != null) {
            for (int i = 0; equal && i < this.proxyChain.length; ++i) {
                equal = this.proxyChain[i].equals((Object)that.proxyChain[i]);
            }
        }
        return equal;
    }

    public final int hashCode() {
        int hc = this.targetHost.hashCode();
        if (this.localAddress != null) {
            hc ^= this.localAddress.hashCode();
        }
        if (this.proxyChain != null) {
            hc ^= this.proxyChain.length;
            for (int i = 0; i < this.proxyChain.length; ++i) {
                hc ^= this.proxyChain[i].hashCode();
            }
        }
        if (this.secure) {
            hc ^= 0x11111111;
        }
        if (this.tunnelled) {
            hc ^= 0x22222222;
        }
        if (this.layered) {
            hc ^= 0x44444444;
        }
        return hc;
    }

    public final String toString() {
        CharArrayBuffer cab = new CharArrayBuffer(50 + this.getHopCount() * 30);
        cab.append("HttpRoute[");
        if (this.localAddress != null) {
            cab.append((Object)this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.tunnelled) {
            cab.append('t');
        }
        if (this.layered) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            for (int i = 0; i < this.proxyChain.length; ++i) {
                cab.append((Object)this.proxyChain[i]);
                cab.append("->");
            }
        }
        cab.append((Object)this.targetHost);
        cab.append(']');
        return cab.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

