/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthState;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.ClientRequestDirector;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpState;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RoutedRequest;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.RouteDirector;
import org.apache.http.conn.Scheme;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpParamsLinker;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.CharArrayBuffer;

public class DefaultClientRequestDirector
implements ClientRequestDirector {
    private static final Log LOG = LogFactory.getLog((Class)DefaultClientRequestDirector.class);
    protected final ClientConnectionManager connManager;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    protected final RedirectHandler redirectHandler;
    private final AuthenticationHandler authHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    private int redirectCount;
    private int maxRedirects;
    private final AuthState targetAuthState;
    private final AuthState proxyAuthState;

    public DefaultClientRequestDirector(ClientConnectionManager conman, ConnectionReuseStrategy reustrat, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler authHandler, HttpParams params) {
        if (conman == null) {
            throw new IllegalArgumentException("Client connection manager may not be null");
        }
        if (reustrat == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null");
        }
        if (retryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null");
        }
        if (redirectHandler == null) {
            throw new IllegalArgumentException("Redirect handler may not be null");
        }
        if (authHandler == null) {
            throw new IllegalArgumentException("Authentication handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.connManager = conman;
        this.reuseStrategy = reustrat;
        this.httpProcessor = httpProcessor;
        this.retryHandler = retryHandler;
        this.redirectHandler = redirectHandler;
        this.authHandler = authHandler;
        this.params = params;
        this.requestExec = new HttpRequestExecutor();
        this.managedConn = null;
        this.redirectCount = 0;
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
    }

    public ManagedClientConnection getConnection() {
        return this.managedConn;
    }

    private RequestWrapper wrapRequest(HttpRequest request) throws ProtocolException {
        try {
            if (request instanceof HttpEntityEnclosingRequest) {
                return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
            }
            return new RequestWrapper(request);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
        }
    }

    private void rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (route.getProxyHost() != null && !route.isTunnelled()) {
                if (!uri.isAbsolute()) {
                    HttpHost target = route.getTargetHost();
                    uri = new URI(target.getSchemeName(), null, target.getHostName(), target.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                    request.setURI(uri);
                }
            } else if (uri.isAbsolute()) {
                uri = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
        }
    }

    public HttpResponse execute(RoutedRequest roureq, HttpContext context) throws HttpException, IOException {
        HttpRequest orig = roureq.getRequest();
        HttpParamsLinker.link((HttpMessage)orig, (HttpParams)this.params);
        Collection defHeaders = (Collection)orig.getParams().getParameter("http.default-headers");
        if (defHeaders != null) {
            Iterator it = defHeaders.iterator();
            while (it.hasNext()) {
                orig.addHeader((Header)it.next());
            }
        }
        long timeout = HttpClientParams.getConnectionManagerTimeout(this.params);
        int execCount = 0;
        HttpResponse response = null;
        boolean done = false;
        try {
            while (!done) {
                HttpRoute route = roureq.getRoute();
                if (this.managedConn == null) {
                    this.managedConn = this.allocateConnection(route, timeout);
                }
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(route, context, this.params);
                }
                try {
                    this.establishRoute(route, context);
                }
                catch (TunnelRefusedException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)ex.getMessage());
                    }
                    response = ex.getResponse();
                    break;
                }
                if (HttpConnectionParams.isStaleCheckingEnabled((HttpParams)this.params)) {
                    LOG.debug((Object)"Stale connection check");
                    if (this.managedConn.isStale()) {
                        LOG.debug((Object)"Stale connection detected");
                        this.managedConn.close();
                        continue;
                    }
                }
                RequestWrapper request = this.wrapRequest(roureq.getRequest());
                this.rewriteRequestURI(request, route);
                HttpHost target = (HttpHost)request.getParams().getParameter("http.virtual-host");
                if (target == null) {
                    target = route.getTargetHost();
                }
                HttpHost proxy = route.getProxyHost();
                context.setAttribute("http.target_host", (Object)target);
                context.setAttribute("http.proxy_host", (Object)proxy);
                context.setAttribute("http.connection", (Object)this.managedConn);
                context.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
                context.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
                this.requestExec.preProcess((HttpRequest)request, this.httpProcessor, context);
                if (orig instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)orig).setReleaseTrigger(this.managedConn);
                }
                context.setAttribute("http.request", (Object)request);
                ++execCount;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Attempt " + execCount + " to execute request"));
                    }
                    response = this.requestExec.execute((HttpRequest)request, (HttpClientConnection)this.managedConn, context);
                }
                catch (IOException ex) {
                    LOG.debug((Object)"Closing the connection.");
                    this.managedConn.close();
                    if (this.retryHandler.retryRequest(ex, execCount, context)) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                        }
                        LOG.info((Object)"Retrying request");
                        continue;
                    }
                    throw ex;
                }
                HttpParamsLinker.link((HttpMessage)request, (HttpParams)this.params);
                this.requestExec.postProcess(response, this.httpProcessor, context);
                RoutedRequest followup = this.handleResponse(roureq, request, response, context);
                if (followup == null) {
                    done = true;
                    continue;
                }
                if (this.reuseStrategy.keepAlive(response, context)) {
                    LOG.debug((Object)"Connection kept alive");
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        entity.consumeContent();
                    }
                } else {
                    this.managedConn.close();
                }
                if (this.managedConn != null && !followup.getRoute().equals(roureq.getRoute())) {
                    this.connManager.releaseConnection(this.managedConn);
                    this.managedConn = null;
                }
                roureq = followup;
            }
            boolean reuse = this.reuseStrategy.keepAlive(response, context);
            if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) {
                if (reuse) {
                    this.managedConn.markReusable();
                }
                this.connManager.releaseConnection(this.managedConn);
                this.managedConn = null;
            } else {
                HttpEntity entity = response.getEntity();
                entity = new BasicManagedEntity(entity, this.managedConn, reuse);
                response.setEntity(entity);
            }
            return response;
        }
        catch (HttpException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.abortConnection();
            throw ex;
        }
    }

    protected ManagedClientConnection allocateConnection(HttpRoute route, long timeout) throws HttpException, ConnectionPoolTimeoutException {
        return this.connManager.getConnection(route, timeout);
    }

    protected void establishRoute(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int step;
        RouteDirector rowdy = new RouteDirector();
        do {
            HttpRoute fact = this.managedConn.getRoute();
            step = rowdy.nextStep(route, fact);
            switch (step) {
                case 1: 
                case 2: {
                    this.managedConn.open(route, context, this.params);
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnel(route, context);
                    LOG.debug((Object)"Tunnel created");
                    this.managedConn.tunnelCreated(secure, this.params);
                    break;
                }
                case 4: {
                    throw new UnsupportedOperationException("Proxy chains are not supported.");
                }
                case 5: {
                    this.managedConn.layerProtocol(context, this.params);
                    break;
                }
                case -1: {
                    throw new IllegalStateException("Unable to establish route.\nplanned = " + route + "\ncurrent = " + fact);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    protected boolean createTunnel(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int status;
        HttpHost proxy = route.getProxyHost();
        HttpHost target = route.getTargetHost();
        HttpResponse response = null;
        boolean done = false;
        while (!done) {
            int status2;
            HttpRequest connect;
            block13: {
                done = true;
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(route, context, this.params);
                }
                connect = this.createConnectRequest(route, context);
                String agent = HttpProtocolParams.getUserAgent((HttpParams)this.params);
                if (agent != null) {
                    connect.addHeader("User-Agent", agent);
                }
                connect.addHeader("Host", target.toHostString());
                AuthScheme authScheme = this.proxyAuthState.getAuthScheme();
                AuthScope authScope = this.proxyAuthState.getAuthScope();
                Credentials creds = this.proxyAuthState.getCredentials();
                if (!(creds == null || authScope == null && authScheme.isConnectionBased())) {
                    try {
                        connect.addHeader(authScheme.authenticate(creds, connect));
                    }
                    catch (AuthenticationException ex) {
                        if (!LOG.isErrorEnabled()) break block13;
                        LOG.error((Object)("Proxy authentication error: " + ex.getMessage()));
                    }
                }
            }
            if ((status2 = (response = this.requestExec.execute(connect, (HttpClientConnection)this.managedConn, context)).getStatusLine().getStatusCode()) < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            HttpState state = (HttpState)context.getAttribute("http.state");
            if (state == null || !HttpClientParams.isAuthenticating(this.params)) continue;
            if (this.authHandler.isProxyAuthenticationRequested(response, context)) {
                block14: {
                    LOG.debug((Object)"Proxy requested authentication");
                    Map challenges = this.authHandler.getProxyChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!LOG.isWarnEnabled()) break block14;
                        LOG.warn((Object)("Authentication error: " + ex.getMessage()));
                        break;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, state);
                if (this.proxyAuthState.getCredentials() == null) continue;
                done = false;
                if (this.reuseStrategy.keepAlive(response, context)) {
                    LOG.debug((Object)"Connection kept alive");
                    HttpEntity entity = response.getEntity();
                    if (entity == null) continue;
                    entity.consumeContent();
                    continue;
                }
                this.managedConn.close();
                continue;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        if ((status = response.getStatusLine().getStatusCode()) > 299) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        this.managedConn.markReusable();
        return false;
    }

    protected HttpRequest createConnectRequest(HttpRoute route, HttpContext context) {
        HttpHost target = route.getTargetHost();
        String host = target.getHostName();
        int port = target.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(target.getSchemeName());
            port = scheme.getDefaultPort();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(host.length() + 6);
        buffer.append(host);
        buffer.append(":");
        buffer.append(Integer.toString(port));
        String authority = buffer.toString();
        HttpVersion ver = HttpProtocolParams.getVersion((HttpParams)this.params);
        BasicHttpRequest req = new BasicHttpRequest("CONNECT", authority, ver);
        return req;
    }

    protected RoutedRequest handleResponse(RoutedRequest roureq, HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRoute route = roureq.getRoute();
        HttpHost target = route.getTargetHost();
        HttpHost proxy = route.getProxyHost();
        InetAddress localAddress = route.getLocalAddress();
        HttpParams params = request.getParams();
        if (HttpClientParams.isRedirecting(params) && this.redirectHandler.isRedirectRequested(response, context)) {
            URI uri;
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            try {
                uri = this.redirectHandler.getLocationURI(response, context);
            }
            catch (ProtocolException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)ex.getMessage());
                }
                return null;
            }
            HttpHost newTarget = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            Scheme schm = this.connManager.getSchemeRegistry().getScheme(newTarget.getSchemeName());
            HttpRoute newRoute = new HttpRoute(newTarget, localAddress, proxy, schm.isLayered(), proxy != null, proxy != null);
            HttpGet redirect = new HttpGet(uri);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Redirecting to '" + uri + "' via " + newRoute));
            }
            return new RoutedRequest.Impl(redirect, newRoute);
        }
        HttpState state = (HttpState)context.getAttribute("http.state");
        if (state != null && HttpClientParams.isAuthenticating(params)) {
            if (this.authHandler.isTargetAuthenticationRequested(response, context)) {
                block16: {
                    target = (HttpHost)context.getAttribute("http.target_host");
                    if (target == null) {
                        target = route.getTargetHost();
                    }
                    LOG.debug((Object)"Target requested authentication");
                    Map challenges = this.authHandler.getTargetChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.targetAuthState, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!LOG.isWarnEnabled()) break block16;
                        LOG.warn((Object)("Authentication error: " + ex.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.targetAuthState, target, state);
                if (this.targetAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.targetAuthState.setAuthScope(null);
            if (this.authHandler.isProxyAuthenticationRequested(response, context)) {
                block17: {
                    LOG.debug((Object)"Proxy requested authentication");
                    Map challenges = this.authHandler.getProxyChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!LOG.isWarnEnabled()) break block17;
                        LOG.warn((Object)("Authentication error: " + ex.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, state);
                if (this.proxyAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        return null;
    }

    private void abortConnection() throws IOException {
        block3: {
            ManagedClientConnection mcc = this.managedConn;
            if (mcc != null) {
                this.managedConn = null;
                try {
                    mcc.abortConnection();
                }
                catch (IOException ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void processChallenges(Map challenges, AuthState authState, HttpResponse response, HttpContext context) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authscheme;
        String id;
        Header challenge;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            authScheme = this.authHandler.selectScheme(challenges, response, context);
            authState.setAuthScheme(authScheme);
        }
        if ((challenge = (Header)challenges.get((id = (authscheme = authState.getAuthScheme()).getSchemeName()).toLowerCase())) == null) {
            throw new AuthenticationException(id + " authorization challenge expected, but not found");
        }
        authscheme.processChallenge(challenge);
        LOG.debug((Object)"Authorization challenge processed");
    }

    private void updateAuthState(AuthState authState, HttpHost host, HttpState state) {
        Credentials creds;
        String hostname = host.getHostName();
        int port = host.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(host);
            port = scheme.getDefaultPort();
        }
        AuthScheme authScheme = authState.getAuthScheme();
        AuthScope authScope = new AuthScope(hostname, port, authScheme.getRealm(), authScheme.getSchemeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication scope: " + authScope));
        }
        if ((creds = authState.getCredentials()) == null) {
            creds = state.getCredentials(authScope);
            if (LOG.isDebugEnabled()) {
                if (creds != null) {
                    LOG.debug((Object)"Found credentials");
                } else {
                    LOG.debug((Object)"Credentials not found");
                }
            }
        } else if (authScheme.isComplete()) {
            LOG.debug((Object)"Authentication failed");
            creds = null;
        }
        authState.setAuthScope(authScope);
        authState.setCredentials(creds);
    }
}

